/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.cmp.CertRequest;
import oracle.security.crypto.cmp.POPOSigningKey;
import oracle.security.crypto.cmp.ProofOfPossession;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.InvalidMACException;
import oracle.security.crypto.core.PasswordBasedMAC;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class SignaturePOP
extends ProofOfPossession {
    private static final ProofOfPossession.Type TYPE = ProofOfPossession.Type.SIGNATURE;
    private POPOSigningKey poposk;
    private transient ASN1Object contents;

    public SignaturePOP() {
    }

    public SignaturePOP(AlgorithmIdentifier sigAlgID) {
        this.poposk = new POPOSigningKey(sigAlgID);
    }

    public SignaturePOP(AlgorithmIdentifier sigAlgID, PublicKey pubKey, GeneralName sender) throws InvalidKeyException {
        this.poposk = new POPOSigningKey(sigAlgID, pubKey, sender);
    }

    public SignaturePOP(AlgorithmIdentifier sigAlgID, PublicKey pubKey, byte[] password) throws NoSuchAlgorithmException, AlgorithmIdentifierException {
        this(sigAlgID, pubKey, password, SecureRandom.getInstance("SHA1PRNG"));
    }

    public SignaturePOP(AlgorithmIdentifier sigAlgID, PublicKey pubKey, byte[] password, SecureRandom sr) throws AlgorithmIdentifierException {
        this.poposk = new POPOSigningKey(sigAlgID, pubKey, password, sr);
    }

    public SignaturePOP(InputStream is) throws IOException {
        this.input(is);
    }

    @Override
    public ProofOfPossession.Type getType() {
        return TYPE;
    }

    public void sign(PrivateKey privKey, SecureRandom sr) throws SignatureException {
        try {
            this.poposk.sign(privKey, sr != null ? sr : SecureRandom.getInstance("SHA1PRNG"));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException(ex.toString());
        }
    }

    public void sign(CertRequest certReq, PrivateKey privKey, SecureRandom sr) throws SignatureException {
        try {
            this.poposk.sign(certReq, privKey, sr != null ? sr : SecureRandom.getInstance("SHA1PRNG"));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException(ex.toString());
        }
    }

    public boolean verify(PublicKey pubKey, CertRequest certReq) throws SignatureException {
        return this.poposk.verifySignature(pubKey, certReq);
    }

    public boolean verify(PublicKey pubKey, GeneralName sender) throws SignatureException {
        if (!sender.equals((Object)this.poposk.getSenderName())) {
            return false;
        }
        return this.poposk.verifySignature(pubKey);
    }

    public boolean verify(PublicKey pubKey, byte[] password) throws SignatureException, InvalidMACException {
        try {
            PasswordBasedMAC pbmac = new PasswordBasedMAC(this.poposk.getMacAlgID(), password);
            byte[] macBytes = pbmac.computeDigest(Utils.toBytes((Streamable)CryptoUtils.subjectPublicKeyInfo((oracle.security.crypto.core.PublicKey)CMPUtils.toPhaosPublicKey(pubKey))));
            if (!Utils.areEqual((byte[])macBytes, (byte[])this.poposk.getMacBytes())) {
                return false;
            }
        }
        catch (AlgorithmIdentifierException ex) {
            throw new InvalidMACException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException(ex.toString());
        }
        return this.poposk.verifySignature(pubKey);
    }

    public AlgorithmIdentifier getSignatureAlgID() {
        return this.poposk.getSignatureAlgID();
    }

    public byte[] getSignatureBytes() {
        return this.poposk.getSignatureBytes();
    }

    public GeneralName getSenderName() {
        return this.poposk.getSenderName();
    }

    public AlgorithmIdentifier getMacAlgID() {
        return this.poposk.getMacAlgID();
    }

    public byte[] getMacBytes() {
        return this.poposk.getMacBytes();
    }

    public PublicKey getPublicKey() {
        return this.poposk.getPublicKey();
    }

    public String toString() {
        return TYPE + " " + (this.poposk != null ? this.poposk.toString() : "= null");
    }

    public void input(InputStream is) throws IOException {
        this.poposk = new POPOSigningKey(is);
        this.update();
        this.contents = this.poposk;
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            this.contents = this.poposk;
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

