/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cmp.PKICertID;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.cmp.PKIStatusInfo;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class RevocationResponse
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.REVOCATION_RESPONSE;
    private Vector status = new Vector();
    private Vector revCerts;
    private Vector crls;
    private transient ASN1Object contents;

    public RevocationResponse() {
    }

    public RevocationResponse(PKIStatusInfo stat) {
        this.status.addElement(stat);
    }

    public RevocationResponse(PKIStatusInfo stat, PKICertID certID) {
        this(stat);
        this.revCerts = new Vector();
        this.revCerts.addElement(certID);
    }

    public RevocationResponse(InputStream is) throws IOException {
        this.input(is);
    }

    public void addStatus(PKIStatusInfo stat) {
        this.status.addElement(stat);
        this.update();
    }

    public void addStatus(PKIStatusInfo stat, PKICertID certID) {
        this.status.addElement(stat);
        if (this.revCerts == null) {
            this.revCerts = new Vector();
        }
        this.revCerts.addElement(certID);
        this.update();
    }

    public void addCRL(CRL crl) {
        if (this.crls == null) {
            this.crls = new Vector();
        }
        this.crls.addElement(crl);
        this.update();
    }

    public Vector getStatus() {
        return this.status;
    }

    public Vector getRevCertIDs() {
        return this.revCerts;
    }

    public Vector getCRLs() {
        return this.crls;
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(TYPE + " { ");
        s.append("status = { ");
        s.append("status = " + Utils.toString((Vector)this.status));
        if (this.revCerts != null) {
            s.append(", revCerts = " + Utils.toString((Vector)this.revCerts));
        }
        if (this.crls != null) {
            s.append(", crls = " + Utils.toString((Vector)this.crls));
        }
        s.append(" }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream eis;
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        ASN1SequenceInputStream pis = new ASN1SequenceInputStream((InputStream)sis);
        while (pis.hasMoreData()) {
            this.status.addElement(new PKIStatusInfo((InputStream)pis));
        }
        pis.terminate();
        if (sis.hasMoreData() && sis.getCurrentTag() == 0) {
            ASN1ConstructedInputStream ris = new ASN1ConstructedInputStream((InputStream)sis, 0);
            eis = new ASN1SequenceInputStream((InputStream)ris);
            if (this.revCerts == null) {
                this.revCerts = new Vector();
            } else {
                this.revCerts.removeAllElements();
            }
            while (eis.hasMoreData()) {
                this.revCerts.addElement(new PKICertID((InputStream)eis));
            }
            eis.terminate();
            ris.terminate();
        } else {
            this.revCerts = null;
        }
        if (sis.hasMoreData() && sis.getCurrentTag() == 1) {
            ASN1ConstructedInputStream cis = new ASN1ConstructedInputStream((InputStream)sis, 1);
            eis = new ASN1SequenceInputStream((InputStream)cis);
            if (this.crls == null) {
                this.crls = new Vector();
            } else {
                this.crls.removeAllElements();
            }
            while (eis.hasMoreData()) {
                this.crls.addElement(new CRL((InputStream)eis));
            }
            eis.terminate();
            cis.terminate();
        } else {
            this.crls = null;
        }
        sis.terminate();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)new ASN1Sequence(this.status));
            if (this.revCerts != null && this.revCerts.size() > 0) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1Sequence(this.revCerts), 0));
            }
            if (this.crls != null && this.crls.size() > 0) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1Sequence(this.crls), 1));
            }
            this.contents = s;
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

