/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class PKICertID
implements ASN1Object {
    private GeneralName issuer;
    private BigInteger serialNumber;
    private ASN1Object contents;

    public PKICertID() {
    }

    public PKICertID(GeneralName issuer, BigInteger serialNumber) {
        this.issuer = issuer;
        this.serialNumber = serialNumber;
    }

    public PKICertID(InputStream is) throws IOException {
        this.input(is);
    }

    public GeneralName getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNo() {
        return this.serialNumber;
    }

    public String toString() {
        return "{ issuer = " + this.issuer + ", serialNo = " + this.serialNumber + " }";
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PKICertID)) {
            return false;
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)((PKICertID)o)));
    }

    public int hashCode() {
        return new String(Utils.toBytes((Streamable)this)).hashCode();
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.issuer = new GeneralName((InputStream)sis);
        this.serialNumber = ASN1Integer.inputValue((InputStream)sis);
        sis.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)this.issuer);
            s.addElement((ASN1Object)new ASN1Integer(this.serialNumber));
            this.contents = s;
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }
}

