/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cmp.PKIMessageBody;
import oracle.security.crypto.cmp.PKIStatusInfo;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class ErrorMessage
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.ERROR_MESSAGE;
    private PKIStatusInfo status;
    private BigInteger code;
    private Vector details;
    private transient ASN1Object contents;

    public ErrorMessage(PKIStatusInfo status) {
        this.status = status;
    }

    public ErrorMessage(PKIStatusInfo status, BigInteger code, String detail) {
        this.status = status;
        this.code = code;
        this.addErrorDetail(detail);
    }

    public ErrorMessage(InputStream is) throws IOException {
        this.input(is);
    }

    public PKIStatusInfo getStatusInfo() {
        return this.status;
    }

    public BigInteger getErrorCode() {
        return this.code;
    }

    public void addErrorDetail(String detail) {
        if (this.details == null) {
            this.details = new Vector();
        }
        this.details.addElement(detail);
        this.update();
    }

    public String getErrorDetail() {
        if (this.details != null && this.details.size() > 0) {
            return (String)this.details.elementAt(0);
        }
        return null;
    }

    public Vector getErrorDetails() {
        return this.details;
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(TYPE + " { statusInfo = " + this.status);
        if (this.code != null) {
            s.append(", errorCode = " + this.code);
        }
        if (this.details != null) {
            s.append(", errorDetails = " + Utils.toString((Vector)this.details));
        }
        s.append(" }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.status = new PKIStatusInfo((InputStream)sis);
        this.code = sis.hasMoreData() && sis.getCurrentTag() == 2 ? ASN1Integer.inputValue((InputStream)sis) : null;
        if (sis.hasMoreData() && sis.getCurrentTag() == 16) {
            ASN1SequenceInputStream dis = new ASN1SequenceInputStream((InputStream)sis);
            if (this.details == null) {
                this.details = new Vector();
            } else {
                this.details.removeAllElements();
            }
            while (dis.hasMoreData()) {
                this.details.addElement(ASN1String.inputValue((InputStream)dis));
            }
            dis.terminate();
        } else {
            this.details = null;
        }
        sis.terminate();
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)this.status);
            if (this.code != null) {
                s.addElement((ASN1Object)new ASN1Integer(this.code));
            }
            if (this.details != null) {
                ASN1Sequence d = new ASN1Sequence();
                int n = this.details.size();
                for (int i = 0; i < n; ++i) {
                    d.addElement((ASN1Object)new ASN1String((String)this.details.elementAt(i), 12));
                }
                s.addElement((ASN1Object)d);
            }
            this.contents = s;
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

