/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class EncryptedValue
implements ASN1Object {
    private AlgorithmIdentifier intendedAlg;
    private AlgorithmIdentifier symmAlg;
    private byte[] encSymmKey;
    private AlgorithmIdentifier keyAlg;
    private byte[] valueHint;
    private byte[] encValue;
    private transient ASN1Object contents;

    public static EncryptedValue encrypt(ASN1Object obj, SecretKey encrKey, PublicKey recipKey) throws NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException {
        String algo = CMPUtils.addPadding(encrKey.getAlgorithm());
        Cipher s = Cipher.getInstance(algo);
        s.init(1, encrKey);
        byte[] encValue = s.doFinal(Utils.toBytes((Streamable)obj));
        EncryptedValue encVal = new EncryptedValue(encValue);
        encVal.symmAlg = CMPUtils.getAlgoID(s.getAlgorithm());
        String algo1 = recipKey.getAlgorithm();
        if (algo1.indexOf("RSA") != -1) {
            algo1 = "RSA/ /PKCS1Padding";
            Cipher k = Cipher.getInstance(algo1);
            k.init(3, recipKey);
            encVal.encSymmKey = k.wrap(encrKey);
            encVal.keyAlg = CMPUtils.getAlgoID(k.getAlgorithm());
        } else {
            Cipher k = Cipher.getInstance(algo1);
            k.init(1, recipKey);
            encVal.encSymmKey = k.doFinal(encrKey.getEncoded());
            encVal.keyAlg = CMPUtils.getAlgoID(k.getAlgorithm());
        }
        return encVal;
    }

    public static byte[] decrypt(EncryptedValue encVal, PrivateKey recipKey) throws NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException {
        Cipher k;
        String algo = CMPUtils.getAlgoName(encVal.keyAlg);
        SecretKey decrKey = null;
        if (algo.indexOf("RSA") != -1) {
            algo = "RSA/ /PKCS1Padding";
            k = Cipher.getInstance(algo);
            k.init(4, recipKey);
            decrKey = (SecretKey)k.unwrap(encVal.encSymmKey, CMPUtils.getAlgoName(encVal.symmAlg), 3);
        } else {
            k = Cipher.getInstance(algo);
            k.init(2, recipKey);
            byte[] keybytes = k.doFinal(encVal.encSymmKey);
            SecretKeySpec sks = new SecretKeySpec(keybytes, CMPUtils.getAlgoName(encVal.symmAlg));
            SecretKeyFactory skf = SecretKeyFactory.getInstance(CMPUtils.getAlgoName(encVal.symmAlg));
            decrKey = skf.generateSecret(sks);
        }
        Cipher s = Cipher.getInstance(CMPUtils.getAlgoName(encVal.symmAlg));
        s.init(2, decrKey);
        return s.doFinal(encVal.encValue);
    }

    public EncryptedValue() {
    }

    public EncryptedValue(byte[] encValue) {
        this.encValue = encValue;
    }

    public EncryptedValue(InputStream is) throws IOException {
        this.input(is);
    }

    public byte[] getEncValue() {
        return this.encValue;
    }

    public void setIntendedAlg(AlgorithmIdentifier intendedAlg) {
        this.intendedAlg = intendedAlg;
        this.update();
    }

    public AlgorithmIdentifier getIntendedAlg() {
        return this.intendedAlg;
    }

    public void setSymmAlg(AlgorithmIdentifier symmAlg) {
        this.symmAlg = symmAlg;
        this.update();
    }

    public AlgorithmIdentifier getSymmAlg() {
        return this.symmAlg;
    }

    public void setEncSymmKey(byte[] encSymmKey) {
        this.encSymmKey = encSymmKey;
        this.update();
    }

    public byte[] getEncSymmKey() {
        return this.encSymmKey;
    }

    public void setKeyAlg(AlgorithmIdentifier keyAlg) {
        this.keyAlg = keyAlg;
        this.update();
    }

    public AlgorithmIdentifier getKeyAlg() {
        return this.keyAlg;
    }

    public void setValueHint(byte[] valueHint) {
        this.valueHint = valueHint;
        this.update();
    }

    public byte[] getValueHint() {
        return this.valueHint;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{");
        if (this.intendedAlg != null) {
            s.append(" intendedAlg = ");
            s.append(this.intendedAlg);
            s.append(',');
        }
        if (this.symmAlg != null) {
            s.append(" symmAlg = ");
            s.append(this.symmAlg);
            s.append(',');
        }
        if (this.encSymmKey != null) {
            s.append(" encSymmKey = ");
            s.append(Utils.toHexString((byte[])this.encSymmKey));
            s.append(',');
        }
        if (this.keyAlg != null) {
            s.append(" keyAlg = ");
            s.append(this.keyAlg);
            s.append(',');
        }
        if (this.valueHint != null) {
            s.append(" valueHint = ");
            s.append(Utils.toHexString((byte[])this.valueHint));
            s.append(',');
        }
        if (s.charAt(s.length() - 1) != ',') {
            s.append(',');
        }
        s.append(" encValue = ");
        s.append(Utils.toHexString((byte[])this.encValue));
        s.append(" }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        this.update();
        ASN1Sequence contents = new ASN1Sequence(is);
        this.keyAlg = null;
        this.symmAlg = null;
        this.intendedAlg = null;
        this.encValue = null;
        this.encSymmKey = null;
        this.valueHint = null;
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)contents));
        int n = contents.size();
        block7: for (int i = 0; i < n - 1 && sis.hasMoreData(); ++i) {
            int tag = sis.getCurrentTag();
            switch (tag) {
                case 0: {
                    sis.setCurrentTag(16);
                    this.intendedAlg = new AlgorithmIdentifier((InputStream)sis);
                    continue block7;
                }
                case 1: {
                    sis.setCurrentTag(16);
                    this.symmAlg = new AlgorithmIdentifier((InputStream)sis);
                    continue block7;
                }
                case 2: {
                    sis.setCurrentTag(3);
                    this.encSymmKey = ASN1BitString.inputValue((InputStream)sis);
                    continue block7;
                }
                case 3: {
                    sis.setCurrentTag(16);
                    this.keyAlg = new AlgorithmIdentifier((InputStream)sis);
                    continue block7;
                }
                case 4: {
                    sis.setCurrentTag(4);
                    this.valueHint = ASN1OctetString.inputValue((InputStream)sis);
                    continue block7;
                }
                default: {
                    throw new ASN1FormatException("Unexpected tag in sequence: " + tag);
                }
            }
        }
        this.encValue = ASN1BitString.inputValue((InputStream)sis);
        sis.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            if (this.intendedAlg != null) {
                s.addElement(ASN1Utils.addImplicitTag((ASN1Object)this.intendedAlg, (int)0));
            }
            if (this.symmAlg != null) {
                s.addElement(ASN1Utils.addImplicitTag((ASN1Object)this.symmAlg, (int)1));
            }
            if (this.encSymmKey != null) {
                s.addElement(ASN1Utils.addImplicitTag((ASN1Object)new ASN1BitString(this.encSymmKey), (int)2));
            }
            if (this.keyAlg != null) {
                s.addElement(ASN1Utils.addImplicitTag((ASN1Object)this.keyAlg, (int)3));
            }
            if (this.valueHint != null) {
                s.addElement(ASN1Utils.addImplicitTag((ASN1Object)new ASN1OctetString(this.valueHint), (int)4));
            }
            s.addElement((ASN1Object)new ASN1BitString(this.encValue));
            this.contents = s;
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }
}

