/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class CertTemplate
implements ASN1Object {
    private BigInteger version;
    private BigInteger serialNo;
    private AlgorithmIdentifier signingAlg;
    private X500Principal issuer;
    private Date notBeforeDate;
    private Date notAfterDate;
    private X500Principal subject;
    private PublicKey publicKey;
    private oracle.security.crypto.core.PublicKey oraPublicKey;
    private byte[] issuerUID;
    private byte[] subjectUID;
    private X509ExtensionSet extensions;
    private ASN1Object contents;

    public CertTemplate() {
    }

    public CertTemplate(InputStream is) throws IOException {
        this.input(is);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    public AlgorithmIdentifier getSigAlgID() {
        return this.signingAlg;
    }

    public X500Principal getIssuer() {
        return this.issuer;
    }

    public Date getNotBeforeDate() {
        return this.notBeforeDate;
    }

    public Date getNotAfterDate() {
        return this.notAfterDate;
    }

    public X500Principal getSubject() {
        return this.subject;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getIssuerUID() {
        return this.issuerUID;
    }

    public byte[] getSubjectUID() {
        return this.subjectUID;
    }

    public X509ExtensionSet getExtensions() {
        return this.extensions;
    }

    public void setVersion(BigInteger version) {
        this.version = version;
        this.update();
    }

    public void setSerialNo(BigInteger serialNo) {
        this.serialNo = serialNo;
        this.update();
    }

    public void setSigAlgID(AlgorithmIdentifier signingAlg) {
        this.signingAlg = signingAlg;
        this.update();
    }

    public void setIssuer(X500Principal issuer) {
        this.issuer = issuer;
        this.update();
    }

    public void setNotBeforeDate(Date notBeforeDate) {
        this.notBeforeDate = notBeforeDate;
        this.update();
    }

    public void setNotAfterDate(Date notAferDate) {
        this.notAfterDate = this.notAfterDate;
        this.update();
    }

    public void setSubject(X500Principal subject) {
        this.subject = subject;
        this.update();
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = publicKey;
        this.oraPublicKey = CMPUtils.toPhaosPublicKey(publicKey);
        this.update();
    }

    public void setIssuerUID(byte[] issuerUID) {
        this.issuerUID = issuerUID;
        this.update();
    }

    public void setSubjectUID(byte[] subjectUID) {
        this.subjectUID = subjectUID;
        this.update();
    }

    public void setExtensions(X509ExtensionSet extensions) {
        this.extensions = extensions;
        this.update();
    }

    public void addExtension(X509Extension ext) {
        if (this.extensions == null) {
            this.extensions = new X509ExtensionSet();
        }
        this.extensions.addExtension(ext);
        this.update();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('{');
        if (this.serialNo != null) {
            s.append(" serialNo = ");
            s.append(this.serialNo);
            s.append(',');
        }
        if (this.signingAlg != null) {
            s.append(" signingAlg = ");
            s.append(this.signingAlg);
            s.append(',');
        }
        if (this.issuer != null) {
            s.append(" issuer = ");
            s.append(this.issuer);
            s.append(',');
        }
        if (this.subject != null) {
            s.append(" subject = ");
            s.append(this.subject);
            s.append(',');
        }
        if (this.notBeforeDate != null) {
            s.append(" notBefore = ");
            s.append(this.notBeforeDate);
            s.append(',');
        }
        if (this.notAfterDate != null) {
            s.append(" notAfter = ");
            s.append(this.notAfterDate);
            s.append(',');
        }
        if (this.publicKey != null) {
            s.append(" publicKey = ");
            s.append(this.publicKey);
            s.append(',');
        }
        if (this.issuerUID != null) {
            s.append(" issuerUID = ");
            s.append(Utils.toHexString((byte[])this.issuerUID));
            s.append(',');
        }
        if (this.subjectUID != null) {
            s.append(" subjectUID = ");
            s.append(Utils.toHexString((byte[])this.subjectUID));
            s.append(',');
        }
        if (this.extensions != null) {
            s.append(" extensions = ");
            s.append(this.extensions);
        }
        if (s.charAt(s.length() - 1) == ',') {
            s.setLength(s.length() - 1);
        }
        s.append(" }");
        return s.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CertTemplate)) {
            return false;
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)((CertTemplate)o)));
    }

    public void input(InputStream is) throws IOException {
        try {
            ASN1ConstructedInputStream cis;
            this.update();
            this.contents = new ASN1Sequence(is);
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
            if (sis.hasMoreData() && sis.getCurrentTag() == 0) {
                sis.setCurrentTag(2);
                this.version = ASN1Integer.inputValue((InputStream)sis);
            } else {
                this.version = null;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 1) {
                sis.setCurrentTag(2);
                this.serialNo = ASN1Integer.inputValue((InputStream)sis);
            } else {
                this.serialNo = null;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 2) {
                sis.setCurrentTag(16);
                this.signingAlg = new AlgorithmIdentifier((InputStream)sis);
            } else {
                this.signingAlg = null;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 3) {
                cis = new ASN1ConstructedInputStream((InputStream)sis, 3);
                this.issuer = new X500Principal((InputStream)cis);
                cis.terminate();
            } else {
                this.issuer = null;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 4) {
                sis.setCurrentTag(16);
                ASN1SequenceInputStream vis = new ASN1SequenceInputStream((InputStream)sis);
                if (vis.hasMoreData() && vis.getCurrentTag() == 0) {
                    ASN1ConstructedInputStream bis = new ASN1ConstructedInputStream((InputStream)vis);
                    this.notBeforeDate = ASN1Date.inputValue((InputStream)bis);
                    bis.terminate();
                } else {
                    this.notBeforeDate = null;
                }
                if (vis.hasMoreData() && vis.getCurrentTag() == 1) {
                    ASN1ConstructedInputStream ais = new ASN1ConstructedInputStream((InputStream)vis);
                    this.notAfterDate = ASN1Date.inputValue((InputStream)ais);
                    ais.terminate();
                } else {
                    this.notAfterDate = null;
                }
                vis.terminate();
            } else {
                this.notAfterDate = null;
                this.notBeforeDate = null;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 5) {
                cis = new ASN1ConstructedInputStream((InputStream)sis, 5);
                this.subject = new X500Principal((InputStream)cis);
                cis.terminate();
            } else {
                this.subject = null;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 6) {
                sis.setCurrentTag(16);
                this.oraPublicKey = CryptoUtils.inputSPKI((InputStream)sis);
                this.publicKey = CMPUtils.toJCEPublicKey(this.oraPublicKey);
            } else {
                this.publicKey = null;
                this.oraPublicKey = null;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 7) {
                sis.setCurrentTag(3);
                this.issuerUID = ASN1BitString.inputValue((InputStream)sis);
            } else {
                this.issuerUID = null;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 8) {
                sis.setCurrentTag(3);
                this.subjectUID = ASN1BitString.inputValue((InputStream)sis);
            } else {
                this.subjectUID = null;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 9) {
                sis.setCurrentTag(16);
                this.extensions = new X509ExtensionSet((InputStream)sis);
            } else {
                this.extensions = null;
            }
            sis.terminate();
        }
        catch (NoSuchAlgorithmException ed) {
            throw new IOException(ed.toString());
        }
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    ASN1Object toASN1() {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            if (this.version != null) {
                seq.addElement(ASN1Utils.addImplicitTag((ASN1Object)new ASN1Integer(this.version), (int)0));
            }
            if (this.serialNo != null) {
                seq.addElement(ASN1Utils.addImplicitTag((ASN1Object)new ASN1Integer(this.serialNo), (int)1));
            }
            if (this.signingAlg != null) {
                seq.addElement(ASN1Utils.addImplicitTag((ASN1Object)this.signingAlg, (int)2));
            }
            if (this.issuer != null) {
                seq.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new X500Name(this.issuer.getName()), 3));
            }
            if (this.notBeforeDate != null || this.notAfterDate != null) {
                ASN1Sequence validity = new ASN1Sequence();
                if (this.notBeforeDate != null) {
                    Calendar bef = Calendar.getInstance();
                    bef.setTime(this.notBeforeDate);
                    validity.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1Date(this.notBeforeDate, bef.get(1) > 2049), 0));
                }
                if (this.notAfterDate != null) {
                    Calendar aft = Calendar.getInstance();
                    aft.setTime(this.notAfterDate);
                    validity.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1Date(this.notAfterDate, aft.get(1) > 2049), 1));
                }
                seq.addElement(ASN1Utils.addImplicitTag((ASN1Object)validity, (int)4));
            }
            if (this.subject != null) {
                seq.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new X500Name(this.subject.getName()), 5));
            }
            if (this.publicKey != null) {
                seq.addElement(ASN1Utils.addImplicitTag((ASN1Object)CryptoUtils.subjectPublicKeyInfo((oracle.security.crypto.core.PublicKey)this.oraPublicKey), (int)6));
            }
            if (this.issuerUID != null) {
                seq.addElement(ASN1Utils.addImplicitTag((ASN1Object)new ASN1BitString(this.issuerUID), (int)7));
            }
            if (this.subjectUID != null) {
                seq.addElement(ASN1Utils.addImplicitTag((ASN1Object)new ASN1BitString(this.subjectUID), (int)8));
            }
            if (this.extensions != null) {
                seq.addElement(ASN1Utils.addImplicitTag((ASN1Object)this.extensions, (int)9));
            }
            this.contents = seq;
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }
}

