/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.AttributeTypeAndValue;
import oracle.security.crypto.cert.AttributeTypeAndValueList;
import oracle.security.crypto.cmp.CertRequest;
import oracle.security.crypto.cmp.CertTemplate;
import oracle.security.crypto.cmp.ProofOfPossession;
import oracle.security.crypto.cmp.SignaturePOP;
import oracle.security.crypto.cmp.attribute.RegistrationInfo;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.Utils;

public class CertReqMsg
implements ASN1Object {
    private CertRequest certReq;
    private ProofOfPossession pop;
    private AttributeTypeAndValueList regInfo;
    private transient ASN1Object contents;

    public CertReqMsg() {
    }

    public CertReqMsg(CertRequest certReq) {
        this.certReq = certReq;
    }

    public CertReqMsg(CertRequest certReq, ProofOfPossession pop) {
        this(certReq);
        this.pop = pop;
        if (pop.getType() == ProofOfPossession.Type.SIGNATURE) {
            throw new IllegalArgumentException("SignaturePOP not allowed");
        }
    }

    public CertReqMsg(CertRequest certReq, SignaturePOP pop, PrivateKey privKey) throws SignatureException, NoSuchAlgorithmException {
        this(certReq, pop, privKey, SecureRandom.getInstance("SHA1PRNG"));
    }

    public CertReqMsg(CertRequest certReq, SignaturePOP pop, PrivateKey privKey, SecureRandom sr) throws SignatureException {
        this(certReq);
        this.pop = pop;
        if (pop.getSignatureBytes() == null) {
            try {
                this.assertSigPOPRules();
            }
            catch (InvalidInputException ex) {
                throw new IllegalArgumentException(ex.toString());
            }
            CertTemplate ct = certReq.getCertTemplate();
            if (ct.getSubject() != null && ct.getPublicKey() != null) {
                pop.sign(certReq, privKey, sr);
            } else if (pop.getPublicKey() != null) {
                pop.sign(privKey, sr);
            } else {
                throw new IllegalArgumentException("Illegal SignaturePOP parameters for certTemplate missing publicKey and/or subjectName");
            }
        }
    }

    public CertReqMsg(InputStream is) throws IOException {
        this.input(is);
    }

    public CertRequest getCertRequest() {
        return this.certReq;
    }

    public ProofOfPossession getPOP() {
        return this.pop;
    }

    public void assertSigPOPRules() throws InvalidInputException {
        if (this.pop != null && this.pop.getType() == ProofOfPossession.Type.SIGNATURE) {
            CertTemplate ct = this.certReq.getCertTemplate();
            if (((SignaturePOP)this.pop).getPublicKey() != null) {
                if (ct.getPublicKey() != null && ct.getSubject() != null) {
                    throw new InvalidInputException("Illegal SignaturePOP parameters for certTemplate containing both publicKey and subjectName");
                }
            } else if (ct.getPublicKey() == null) {
                throw new InvalidInputException("Illegal SignaturePOP parameters for certTemplate missing publicKey and/or subjectName");
            }
        }
    }

    public void addRegInfo(RegistrationInfo ri) {
        if (this.regInfo == null) {
            this.regInfo = new AttributeTypeAndValueList();
        }
        this.regInfo.addAttribute((AttributeTypeAndValue)ri);
        this.update();
    }

    public void addRegInfo(ASN1ObjectID type, ASN1Object value) {
        RegistrationInfo info = null;
        Class c = OIDManager.getOIDManager().getMapping(type, "registrationInfo");
        if (c != null) {
            try {
                info = (RegistrationInfo)((Object)c.newInstance());
                info.setValue(value);
            }
            catch (IllegalAccessException ex) {
                info = null;
            }
            catch (InstantiationException ex) {
                info = null;
            }
            catch (ClassCastException ex) {
                info = null;
            }
        }
        if (info == null) {
            info = new RegistrationInfo(type, value);
        }
        this.addRegInfo(info);
    }

    public AttributeTypeAndValueList getRegInfo() {
        return this.regInfo;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{ certReq = " + this.certReq);
        if (this.pop != null) {
            s.append(", pop = " + this.pop);
        }
        if (this.regInfo != null) {
            s.append(", regInfo = " + this.regInfo);
        }
        s.append(" }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.certReq = new CertRequest((InputStream)sis);
        this.pop = sis.hasMoreData() && sis.getCurrentTag() != 16 ? ProofOfPossession.inputInstance((InputStream)sis) : null;
        if (sis.hasMoreData()) {
            this.regInfo = new AttributeTypeAndValueList();
            ASN1SequenceInputStream sisInfo = new ASN1SequenceInputStream((InputStream)sis);
            while (sisInfo.hasMoreData()) {
                this.regInfo.addAttribute((AttributeTypeAndValue)RegistrationInfo.inputInstance((InputStream)sisInfo));
            }
            sisInfo.terminate();
        } else {
            this.regInfo = null;
        }
        sis.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            if (this.certReq == null) {
                throw new StreamableOutputException("Missing CertRequest");
            }
            seq.addElement((ASN1Object)this.certReq);
            if (this.pop != null) {
                seq.addElement((ASN1Object)this.pop);
            }
            if (this.regInfo != null && this.regInfo.size() > 0) {
                seq.addElement((ASN1Object)this.regInfo);
            }
            this.contents = seq;
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }
}

