/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cmp.CertReqMsg;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.Utils;

public class CertReqMessages
implements ASN1Object {
    private Vector certReqs = new Vector();
    private transient ASN1Object contents;

    public CertReqMessages() {
    }

    public CertReqMessages(CertReqMsg crm) {
        this.certReqs.addElement(crm);
    }

    public CertReqMessages(InputStream is) throws IOException {
        this.input(is);
    }

    public void addCertReqMsg(CertReqMsg crm) {
        this.certReqs.addElement(crm);
        this.update();
    }

    public Vector getCertReqMsgs() {
        return this.certReqs;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{ ");
        int n = this.certReqs.size();
        for (int i = 0; i < n; ++i) {
            s.append(this.certReqs.elementAt(i).toString());
            if (i >= n - 1) continue;
            s.append(", ");
        }
        s.append(" }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        this.certReqs.removeAllElements();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        while (sis.hasMoreData()) {
            this.certReqs.addElement(new CertReqMsg((InputStream)sis));
        }
        sis.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    ASN1Object toASN1() {
        if (this.contents == null) {
            if (this.certReqs.size() == 0) {
                throw new StreamableOutputException("No CertReqMsg items found");
            }
            this.contents = new ASN1Sequence(this.certReqs);
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }
}

