/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.cmp.PKIMessageBody;

public class CertAnnouncement
extends PKIMessageBody {
    private static final PKIMessageBody.Type TYPE = PKIMessageBody.Type.CERTIFICATE_ANNOUNCEMENT;
    private X509Certificate cert;
    private X509 X509Cert;
    private transient ASN1Object contents;

    public CertAnnouncement() {
    }

    public CertAnnouncement(X509Certificate cert) throws CertificateEncodingException {
        this.cert = cert;
        this.X509Cert = CMPUtils.convertX509(cert);
    }

    public CertAnnouncement(InputStream is) throws IOException {
        this.input(is);
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    @Override
    public PKIMessageBody.Type getType() {
        return TYPE;
    }

    public String toString() {
        return "{ type = " + TYPE + ", cert = " + this.cert + " } ";
    }

    public void input(InputStream is) throws IOException {
        try {
            this.X509Cert = new X509(is);
            this.cert = CMPUtils.toJCECertificate(this.X509Cert);
            this.update();
            this.contents = this.X509Cert;
        }
        catch (CertificateException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    ASN1Object toASN1Object() {
        if (this.contents == null) {
            this.contents = this.X509Cert;
        }
        return this.contents;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }
}

