/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.AbstractFindToolbarController;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyUtil;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.Utilities;
import oracle.javatools.ui.search.PromptedTextField;

public final class BasicFindToolbarController
extends AbstractFindToolbarController {
    private final boolean allowReplace;
    private final JComponent toolbarPanel = new JPanel();
    private final Toolbar findToolbar;
    private final Toolbar replaceToolbar;

    public BasicFindToolbarController(BasicEditorPane editor, boolean forceKeyBinding, boolean allowReplace) {
        super(editor);
        this.toolbarPanel.setLayout(new BorderLayout());
        this.toolbarPanel.setOpaque(false);
        this.allowReplace = allowReplace;
        this.findToolbar = this.getFindAndOptionsToolbar();
        this.replaceToolbar = this.getReplaceToolbar().getToolbar();
        this.toolbarPanel.add((Component)this.findToolbar, "North");
        this.toolbarPanel.add((Component)this.replaceToolbar, "South");
        this.findToolbar.setVisible(false);
        this.replaceToolbar.setVisible(false);
        if (!allowReplace) {
            this.getFindToolbarOptions().disallowReplace();
        }
        this.getFindToolbarOptions().getOptionsComponent().setVisible(true);
        if (forceKeyBinding) {
            this.addKeyBindings();
        }
    }

    private void addKeyBindings() {
        KeyStroke replaceStroke;
        BasicEditorPane editor = this.getEditor();
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap ksm = kso.getGlobalKeyMap();
        KeyStroke findStroke = KeyUtil.getBestAccelerator((KeyStrokeMap)ksm, (int)23);
        if (findStroke != null) {
            String FIND = "find";
            editor.getInputMap(0).put(findStroke, "find");
            editor.getActionMap().put("find", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicFindToolbarController.this.setFindShowing(true);
                }
            });
        }
        if ((replaceStroke = KeyUtil.getBestAccelerator((KeyStrokeMap)ksm, (int)24)) != null && this.allowReplace) {
            String REPLACE = "replace";
            editor.getInputMap(0).put(replaceStroke, "replace");
            editor.getActionMap().put("replace", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicFindToolbarController.this.setReplaceShowing(true);
                }
            });
            PromptedTextField findField = this.getFindToolbar().getSearchField().getTextField();
            String SHOW_REPLACE = "showReplace";
            findField.getInputMap(0).put(replaceStroke, "showReplace");
            findField.getActionMap().put("showReplace", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicFindToolbarController.this.setReplaceShowing(true);
                    BasicFindToolbarController.this.getReplaceToolbar().getReplaceField().requestFocus();
                }
            });
        }
        if (this.allowReplace && findStroke != null) {
            PromptedTextField replaceField = this.getReplaceToolbar().getReplaceField().getTextField();
            String FOCUS_FIND = "focusFind";
            replaceField.getInputMap(0).put(findStroke, "focusFind");
            replaceField.getActionMap().put("focusFind", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BasicFindToolbarController.this.getFindToolbar().getSearchField().requestFocus();
                }
            });
        }
    }

    @Override
    public boolean isReplaceShowing() {
        return this.replaceToolbar.isVisible();
    }

    @Override
    public boolean isFindShowing() {
        return this.findToolbar.isVisible();
    }

    @Override
    public void setReplaceShowing(boolean showing) {
        if (showing && this.allowReplace) {
            String text;
            if (this.getEditor().hasFocus() && (text = Utilities.getCurrentWord((BasicEditorPane)this.getEditor())) != null) {
                if (!this.findToolbar.isVisible()) {
                    this.getFindToolbar().getSearchField().setText(text);
                }
                if (!this.replaceToolbar.isVisible()) {
                    this.getReplaceToolbar().setSearchFieldText(text);
                }
            }
            this.findToolbar.setVisible(true);
            this.replaceToolbar.setVisible(true);
            this.getReplaceToolbar().getReplaceField().requestFocus();
        } else {
            this.replaceToolbar.setVisible(false);
        }
    }

    @Override
    public void setFindShowing(boolean showing) {
        this.findToolbar.setVisible(showing);
        if (!showing) {
            this.replaceToolbar.setVisible(false);
        }
        if (showing) {
            String text;
            if (this.getEditor().hasFocus() && (text = Utilities.getCurrentWord((BasicEditorPane)this.getEditor())) != null) {
                this.getFindToolbar().getSearchField().setText(text);
            }
            this.getFindToolbar().getSearchField().requestFocus();
        }
    }

    public JComponent getToolbarsComponent() {
        return this.toolbarPanel;
    }
}

