/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNURL;

public class SVNRepositoryTreeNode
extends DefaultMutableTreeNode {
    public static final int CHILD_POLICY_DIRECTORIES_FILES = 0;
    public static final int CHILD_POLICY_DIRECTORIES_ONLY = 1;
    public static final int CHILD_POLICY_FILES_ONLY = 2;
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNRepositoryTreeNode.class.getName());
    private final SVNRepositoryInfo _parentRepos;
    private final SVNNodeKind _nodeKind;
    private final SVNUrl _url;
    private final int _childNodePolicy;
    private final ISVNClientAdapter _client;
    private boolean _populating;
    private boolean _populated;
    private boolean _sort;

    public SVNRepositoryTreeNode(SVNRepositoryInfo parentRepos, SVNNodeKind nodeKind, SVNUrl url, String path, int childNodePolicy, ISVNClientAdapter client) {
        this(parentRepos, nodeKind, url, path, childNodePolicy, false, client);
    }

    public SVNRepositoryTreeNode(SVNRepositoryInfo parentRepos, SVNNodeKind nodeKind, SVNUrl url, String path, int childNodePolicy, boolean sort, ISVNClientAdapter client) {
        super(path, nodeKind != null && nodeKind.equals((Object)SVNNodeKind.DIR));
        this._parentRepos = parentRepos;
        this._nodeKind = nodeKind;
        this._url = url;
        if (childNodePolicy < 0 || childNodePolicy > 2) {
            throw new IllegalStateException(String.valueOf(childNodePolicy));
        }
        this._childNodePolicy = childNodePolicy;
        this._client = client;
        this.children = new Vector();
        this._sort = sort;
    }

    public SVNRepositoryInfo getParentRepository() {
        return this._parentRepos;
    }

    public SVNNodeKind getNodeKind() {
        return this._nodeKind;
    }

    public SVNUrl getURL() {
        return this._url;
    }

    public SVNURL getSVNURL() {
        return SVNUtil.toSVNURL(this._url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repopulate() {
        Vector vector = this.children;
        synchronized (vector) {
            this.removeAllChildren();
            this._populated = false;
            this.populateChildrenSilently(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration children() {
        Vector vector = this.children;
        synchronized (vector) {
            this.populateChildrenSilently(false);
        }
        return super.children();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeNode getChildAt(int index) {
        Vector vector = this.children;
        synchronized (vector) {
            this.populateChildrenSilently(false);
        }
        return super.getChildAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildCount() {
        Vector vector = this.children;
        synchronized (vector) {
            this.populateChildrenSilently(false);
        }
        return super.getChildCount();
    }

    @Override
    public boolean isLeaf() {
        return this.getNodeKind().equals((Object)SVNNodeKind.FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateChildrenSilently(boolean force) {
        Vector vector = this.children;
        synchronized (vector) {
            try {
                this.populateChildren(force);
            }
            catch (SVNClientException ce) {
                sLogger.log(Level.WARNING, "unable to list children of " + this.getURL().toString(), ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateChildren(boolean force) throws SVNClientException {
        Vector vector = this.children;
        synchronized (vector) {
            if (this._populating) {
                return;
            }
            if (!this.getNodeKind().equals((Object)SVNNodeKind.DIR) || this._populated && !force) {
                return;
            }
            this._populating = true;
            ISVNDirEntry[] entries = null;
            try {
                SVNClientInteraction.getInstance().beginInteraction(this._client, this._parentRepos);
                entries = this._client.getList(this.getURL(), SVNRevision.HEAD, false);
                if (this._sort) {
                    entries = this.sortEntries(entries);
                }
            }
            finally {
                SVNClientInteraction.getInstance().endInteraction();
            }
            if (entries != null && entries.length > 0) {
                for (int i = 0; i < entries.length; ++i) {
                    SVNNodeKind childKind = entries[i].getNodeKind();
                    String childPath = entries[i].getPath();
                    SVNUrl childUrl = this.getURL().appendPath(childPath);
                    boolean includeMe = false;
                    if (childKind.equals((Object)SVNNodeKind.DIR)) {
                        if (this._childNodePolicy != 2) {
                            includeMe = true;
                        }
                    } else if (childKind.equals((Object)SVNNodeKind.FILE)) {
                        if (this._childNodePolicy != 1) {
                            includeMe = true;
                        }
                    } else {
                        sLogger.fine("unhandled node type for " + childUrl.toString() + ": " + childKind.toString());
                    }
                    if (!includeMe) continue;
                    this.add(new SVNRepositoryTreeNode(this.getParentRepository(), childKind, childUrl, childPath, this._childNodePolicy, this._sort, this._client));
                }
            }
            this._populating = false;
            this._populated = true;
        }
    }

    private ISVNDirEntry[] sortEntries(ISVNDirEntry[] entries) {
        ArrayList<ISVNDirEntry> sort = new ArrayList<ISVNDirEntry>();
        for (ISVNDirEntry entry : entries) {
            sort.add(entry);
        }
        Collections.sort(sort, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof ISVNDirEntry) || !(o2 instanceof ISVNDirEntry)) {
                    return 0;
                }
                ISVNDirEntry e1 = (ISVNDirEntry)o1;
                ISVNDirEntry e2 = (ISVNDirEntry)o2;
                return e1.getPath().compareToIgnoreCase(e2.getPath());
            }
        });
        entries = sort.toArray(new ISVNDirEntry[0]);
        return entries;
    }
}

