/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.prefs;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class SVNEnvironmentPrefs
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.jdevimpl.vcs.svn.prefs.SVNEnvironmentPrefs";
    public static final String KEY_USE_OVERLAYS = "useOverlays";
    private static final Boolean DEFAULT_USE_OVERLAYS = Boolean.TRUE;
    public static final String KEY_AUTO_CHECKOUTS = "autoCheckouts";
    private static final Boolean DEFAULT_AUTO_CHECKOUTS = Boolean.TRUE;
    public static final String KEY_AUTO_ADD_FILES = "autoAddFiles";
    private static final Boolean DEFAULT_AUTO_ADD_FILES = Boolean.FALSE;
    public static final String KEY_OPERATION_TIMEOUT = "operationTimeout";
    private static final Integer DEFAULT_OPERATION_TIMEOUT = new Integer(60);
    public static final String KEY_USE_LABEL_DECORATIONS = "useLabelDecorations";
    private static final Boolean DEFAULT_USE_LABEL_DECORATIONS = Boolean.TRUE;
    public static final String KEY_AUTO_CHECKOUT_COMMENT = "autoCheckoutComment";
    private static final String DEFAULT_AUTO_CHECKOUT_COMMENT = "";
    public static final String KEY_AUTO_PROGRESS_ON_CHECKOUT = "autoProgressOnCheckout";
    private static final Boolean DEFAULT_AUTO_PROGRESS_CHECKOUT = Boolean.TRUE;
    public static final String KEY_AUTO_LOG_MESSAGES = "autoLogMessages";
    private static final Boolean DEFAULT_AUTO_LOG_MESSAGES = Boolean.TRUE;
    private static final String AUTO_LOCK = "autoLock";
    private static final boolean DEFAULT_AUTO_LOCK = false;
    private static final String SHOW_SVN_CONSOLE = "showSvnConsole";
    private static final boolean DEFAULT_SHOW_SVN_CONSOLE = true;

    private SVNEnvironmentPrefs(HashStructure hash) {
        super(hash);
    }

    public static SVNEnvironmentPrefs getInstance(PropertyStorage prefs) {
        return new SVNEnvironmentPrefs(SVNEnvironmentPrefs.findOrCreate((PropertyStorage)prefs, (String)DATA_KEY));
    }

    public boolean getUseOverlays() {
        return this._hash.getBoolean(KEY_USE_OVERLAYS, DEFAULT_USE_OVERLAYS.booleanValue());
    }

    public void setUseOverlays(boolean useOverlays) {
        this._hash.putBoolean(KEY_USE_OVERLAYS, useOverlays);
    }

    public boolean getAutoCheckouts() {
        return this._hash.getBoolean(KEY_AUTO_CHECKOUTS, DEFAULT_AUTO_CHECKOUTS.booleanValue());
    }

    public void setAutoCheckouts(boolean autoCheckouts) {
        this._hash.putBoolean(KEY_AUTO_CHECKOUTS, autoCheckouts);
    }

    public boolean getAutoAddFiles() {
        return this._hash.getBoolean(KEY_AUTO_ADD_FILES, DEFAULT_AUTO_ADD_FILES.booleanValue());
    }

    public void setAutoAddFiles(boolean autoAddFiles) {
        this._hash.putBoolean(KEY_AUTO_ADD_FILES, autoAddFiles);
    }

    public int getOperationTimeout() {
        return this._hash.getInt(KEY_OPERATION_TIMEOUT, DEFAULT_OPERATION_TIMEOUT.intValue());
    }

    public void setOperationTimeout(int operationTimeout) {
        this._hash.putInt(KEY_OPERATION_TIMEOUT, operationTimeout);
    }

    public boolean getUseLabelDecorations() {
        return this._hash.getBoolean(KEY_USE_LABEL_DECORATIONS, DEFAULT_USE_LABEL_DECORATIONS.booleanValue());
    }

    public void setUseLabelDecorations(boolean useLabelDecorations) {
        this._hash.putBoolean(KEY_USE_LABEL_DECORATIONS, useLabelDecorations);
    }

    public String getAutoCheckoutComment() {
        return this._hash.getString(KEY_AUTO_CHECKOUT_COMMENT, DEFAULT_AUTO_CHECKOUT_COMMENT);
    }

    public void setAutoCheckoutComment(String autoCheckoutComment) {
        this._hash.putString(KEY_AUTO_CHECKOUT_COMMENT, autoCheckoutComment);
    }

    public boolean getAutoProgressOnCheckout() {
        return this._hash.getBoolean(KEY_AUTO_PROGRESS_ON_CHECKOUT, DEFAULT_AUTO_PROGRESS_CHECKOUT.booleanValue());
    }

    public void setAutoProgressOnCheckout(boolean autoProgressOnCheckout) {
        this._hash.putBoolean(KEY_AUTO_PROGRESS_ON_CHECKOUT, autoProgressOnCheckout);
    }

    public boolean getAutoLogMessages() {
        return this._hash.getBoolean(KEY_AUTO_LOG_MESSAGES, DEFAULT_AUTO_LOG_MESSAGES.booleanValue());
    }

    public void setAutoLogMessages(boolean autoLogMessages) {
        this._hash.putBoolean(KEY_AUTO_LOG_MESSAGES, autoLogMessages);
    }

    public boolean getAutoLock() {
        return this._hash.getBoolean(AUTO_LOCK, false);
    }

    public void setAutoLock(boolean autoLock) {
        this._hash.putBoolean(AUTO_LOCK, autoLock);
    }

    public boolean getShowSVNConsole() {
        return this._hash.getBoolean(SHOW_SVN_CONSOLE, true);
    }

    public void setShowSVNConsole(boolean showSvnConsole) {
        this._hash.putBoolean(SHOW_SVN_CONSOLE, showSvnConsole);
    }
}

