/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;

public final class SVNOperationRemove
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.remove";

    public SVNOperationRemove() {
        super(COMMAND_ID);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        Locatable[] locatables = this.getOperands(profile);
        CommandState commandState = this.getCommandState(profile, locatables);
        if (commandState == null) {
            return 9;
        }
        boolean success = this.invokeCommand(profile, commandState);
        this.postInvoke(profile, commandState);
        return success ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        DeterminateProgressMonitor progress = new DeterminateProgressMonitor(parentUi, this.getProgressTitle(), (Object)this.getProgressMessage(), "", 0, -1);
        progress.setCancellable(true);
        progress.setCloseOnFinish(true);
        ArrayList<Locatable> nodes = new ArrayList<Locatable>(Arrays.asList(commandState.getLocatables()));
        VCSCommandUtils.removeNonEditableNodes(nodes);
        URL[] resources = VCSModelUtils.convertNodesToURLs(nodes);
        TreeSet<URL> directories = new TreeSet<URL>(new Comparator(){

            public int compare(Object o1, Object o2) {
                return URLFileSystem.getPlatformPathName((URL)((URL)o2)).compareTo(URLFileSystem.getPlatformPathName((URL)((URL)o1)));
            }
        });
        HashSet<URL> files = new HashSet<URL>(resources.length * 2);
        for (int i = 0; i < resources.length; ++i) {
            if (URLFileSystem.isDirectoryPath((URL)resources[i])) {
                directories.add(resources[i]);
                continue;
            }
            files.add(resources[i]);
        }
        progress.setMaximum(resources.length);
        progress.setProgress(0);
        Collection processed = this.getProcessedUrlsNotifier(commandState);
        try {
            URL url;
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(client, null, progress);
            Iterator it = files.iterator();
            while (it.hasNext()) {
                progress.setProgress(processed.size());
                url = (URL)it.next();
                client.remove(new File[]{SVNUtil.toFile(url)}, true);
                processed.add(url);
            }
            it = directories.iterator();
            while (it.hasNext()) {
                progress.setProgress(processed.size());
                url = (URL)it.next();
                client.remove(new File[]{SVNUtil.toFile(url)}, true);
                processed.add(url);
            }
            commandState.setProperty(PROPERTY_RESOURCES_DELETED, (Object)processed.toArray(new URL[processed.size()]));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SVNOperationRemove.this.closeRemovedFileEditors();
                }
            });
            SVNOperationLogger.getInstance().successFinish(Resource.get("OP_REMOVE"));
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
            progress.finish();
            commandState.setProperty("oracle.jdeveloper.subversion.RECURSIVE", (Object)Boolean.TRUE);
        }
        return true;
    }

    private String getProgressTitle() {
        return Resource.get("ACTION_REMOVE_PROGRESS_TITLE");
    }

    private String getProgressMessage() {
        return Resource.get("ACTION_REMOVE_PROGRESS_MESSAGE");
    }

    private void closeRemovedFileEditors() {
        ArrayList<Editor> editorsToClose = new ArrayList<Editor>();
        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
            Node editorNode = editor.getContext().getNode();
            if (URLFileSystem.exists((URL)editorNode.getURL())) continue;
            editorsToClose.add(editor);
        }
        EditorManager.getEditorManager().closeEditors((List)editorsToClose);
    }
}

