/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.javatools.util.ImageIconCache;
import oracle.jdeveloper.vcs.nav.ConnectionNode;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteContainer;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNRepositoryNode
extends SVNRemoteContainer
implements ConnectionNode {
    private SVNRepositoryInfo _reposInfo;

    public SVNRepositoryNode(SVNRepositoryInfo reposInfo) {
        super(null, null, reposInfo.getURL());
        this._reposInfo = reposInfo;
    }

    public Map<String, String> getConnectionCriteria() {
        SVNUrl url = this.getSVNUrl();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("url", url.toString());
        return criteria;
    }

    @Override
    public SVNRepositoryNode getParentRepository() {
        return this;
    }

    public String getShortLabel() {
        SVNRepositoryInfo reposInfo = this.getReposInfo();
        String label = reposInfo.getAlias();
        if (label == null || label.equals("")) {
            label = reposInfo.getURL().toString();
        }
        return label;
    }

    public Icon getIcon() {
        return ImageIconCache.get((URL)Resource.class.getResource(Resource.get("NAV_ICON_REPOSITORY_NODE")));
    }

    @Override
    public String getToolTipText() {
        return this.getSVNUrl().toString();
    }

    @Override
    public Object getData() {
        return this.getReposInfo();
    }

    private SVNRepositoryInfo getReposInfo() {
        SVNRepositoryInfo info = SVNUtil.resolveRepository(this.getSVNUrl());
        return info == null ? this._reposInfo : info;
    }
}

