/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.svn.SVNEventParser;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.mergewiz.MergeOperation;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizard;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizardModel;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.ui.DepthOperationPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;

public class MergeOptionsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private static final String TRANSIENT_TREE_PATH_KEY = MergeOptionsPanel.class.getName() + ".treePath";
    private boolean _initialized = false;
    private SVNMergeWizardModel _model;
    private DepthOperationPanel _depthPanel;
    private JCheckBox _ignoreAncestryBox;
    private JCheckBox _recordBox;
    private JCheckBox _forceBox;
    private JButton _testButton;
    private JMultiLineLabel _hint;
    private JLabel _statusLabel;
    private JTextArea _statusArea;
    private JScrollPane _scrollPane;
    static String _pre_complete_msg = null;
    static String _pre_error_msg = null;
    boolean _newSession = true;

    public MergeOptionsPanel() {
        this.setLayout(new GridBagLayout());
    }

    public void onEntry(TraversableContext dataContext) {
        this._model = (SVNMergeWizardModel)dataContext.get(SVNMergeWizard.DATA_KEY);
        this.initialize();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this._model = (SVNMergeWizardModel)dataContext.get(SVNMergeWizard.DATA_KEY);
        this.updateModelWithOptions();
    }

    private synchronized void initialize() {
        if (this._initialized) {
            this._statusArea.setText("");
            return;
        }
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
        this._initialized = true;
    }

    private void createComponents() {
        this._hint = new JMultiLineLabel();
        this._hint.setText(Resource.get("MERGE_UI_OPTIONS_HINT"));
        this._depthPanel = new DepthOperationPanel();
        this._ignoreAncestryBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._ignoreAncestryBox, (String)Resource.get("UI_OPTIONSPANEL_ANCESTRY_CHECKBOX"));
        this._forceBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._forceBox, (String)Resource.get("UI_OPTIONSPANEL_FORCE_CHECKBOX"));
        this._recordBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._recordBox, (String)Resource.get("UI_OPTIONSPANEL_RECORD_CHECKBOX"));
        this._testButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._testButton, (String)Resource.get("UI_OPTIONSPANEL_TESTMERGE_BUTTON"));
        this._statusLabel = new JLabel();
        this._statusArea = new JTextArea();
        this._statusArea.setEditable(false);
        this._statusArea.setRows(3);
        this._statusArea.setLineWrap(true);
        this._statusArea.setText("");
        ResourceUtils.resLabel((JLabel)this._statusLabel, (Component)this._statusArea, (String)Resource.get("UI_MERGE_PANEL_LABEL_STATUS"));
        this._scrollPane = new JScrollPane(this._statusArea);
    }

    private void layoutComponents() {
        Insets insets = new Insets(6, 2, 2, 6);
        this.add((Component)this._hint, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add(this._depthPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add(this._ignoreAncestryBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add(this._forceBox, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add(this._recordBox, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add(this._testButton, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add(this._statusLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add(this._scrollPane, new GridBagConstraints(0, 7, 1, 3, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 8, 1, 1, 0.0, 1.0, 15, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initListeners() {
        this._testButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModelWithOptions();
        if (e.getSource().equals(this._testButton)) {
            this._statusArea.setText("");
            TextAreaNotificationListener tanListener = new TextAreaNotificationListener();
            MergeTestThread mergeThread = new MergeTestThread(this._model, true, tanListener);
            mergeThread.start();
        }
    }

    private void updateModelWithOptions() {
        this._model.setDepth(this._depthPanel.getDepthSelected());
        this._model.setIgnoreAncestry(this._ignoreAncestryBox.isSelected());
        this._model.setRecordOnly(this._recordBox.isSelected());
        this._model.setForce(this._forceBox.isSelected());
    }

    private class MergeTestThread
    extends Thread {
        private int _mergeType = 0;
        private SVNMergeWizardModel m_model;
        private boolean m_dryrun;
        private ISVNEventHandler m_tanListener;

        public MergeTestThread(SVNMergeWizardModel model, boolean dryrun, ISVNEventHandler tanListener) {
            this.m_model = model;
            this.m_dryrun = dryrun;
            this.m_tanListener = tanListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            WaitCursor wc;
            block12: {
                this._mergeType = this.m_model.getMergeType();
                wc = null;
                SVNDiffClient client = null;
                try {
                    SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(this.m_model.getFromSVNURL());
                    client = SVNUtil.getDiffClient(repoInfo);
                    client.setEventHandler(this.m_tanListener);
                    wc = new WaitCursor((Component)((Object)MergeOptionsPanel.this));
                    wc.show();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MergeOptionsPanel.this._testButton.setEnabled(false);
                        }
                    });
                    switch (this._mergeType) {
                        case 0: {
                            this.doRangeMerge(client);
                            break;
                        }
                        case 2: {
                            this.doTreeMerge(client);
                        }
                    }
                    MergeOptionsPanel.this._newSession = true;
                    if (this.m_tanListener == null) break block12;
                }
                catch (SVNException e) {
                    block13: {
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MergeOptionsPanel.this._statusArea.setText(e.getMessage());
                                }
                            });
                            SVNProfile.getQualifiedLogger(MergeOperation.class.getName()).warning(e.getMessage());
                            MergeOptionsPanel.this._newSession = true;
                            if (this.m_tanListener == null) break block13;
                        }
                        catch (Throwable throwable) {
                            MergeOptionsPanel.this._newSession = true;
                            if (this.m_tanListener != null) {
                                client.setEventHandler(null);
                            }
                            if (wc != null) {
                                wc.hide();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        MergeOptionsPanel.this._testButton.setEnabled(true);
                                    }
                                });
                            }
                            throw throwable;
                        }
                        client.setEventHandler(null);
                    }
                    if (wc != null) {
                        wc.hide();
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                client.setEventHandler(null);
            }
            if (wc != null) {
                wc.hide();
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }

        private synchronized void doRangeMerge(SVNDiffClient client) throws SVNException {
            ArrayList<SVNRevisionRange> range = new ArrayList<SVNRevisionRange>();
            for (SVNRevisionRange fromRange : this.m_model.getFromRevisionRanges()) {
                range.add(fromRange);
            }
            client.doMerge(this.m_model.getFromSVNURL(), SVNRevision.HEAD, range, this.m_model.getLocalPath(), SVNUtil.depth(this.m_model.getDepth()), !this.m_model.isIgnoreAncestry(), this.m_model.isForce(), this.m_dryrun, this.m_model.isRecordOnly());
        }

        private synchronized void doTreeMerge(SVNDiffClient client) throws SVNException {
            client.doMerge(this.m_model.getFromSVNURL(), this.m_model.getFromRevision(), this.m_model.getToSVNUrl(), this.m_model.getToRevision(), this.m_model.getLocalPath(), SVNUtil.depth(this.m_model.getDepth()), !this.m_model.isIgnoreAncestry(), this.m_model.isForce(), this.m_dryrun, this.m_model.isRecordOnly());
        }
    }

    private final class TextAreaNotificationListener
    implements ISVNEventHandler {
        private SVNEventParser _parser = new SVNEventParser();

        private TextAreaNotificationListener() {
        }

        public void handleEvent(SVNEvent event, double progress) throws SVNException {
            this.appendLater(this._parser.parse(event));
            this.appendLater("");
        }

        public void checkCancelled() throws SVNCancelException {
        }

        private void appendLater(final String message) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MergeOptionsPanel.this._statusArea.append(message);
                    MergeOptionsPanel.this._statusArea.append("\n");
                }
            });
        }
    }
}

