/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.merge;

import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareMergeAlgorithm;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.algorithm.list.ListCompareAlgorithm;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.jdevimpl.compare.CompareUtil;
import oracle.jdevimpl.vcs.svn.merge.SVNDirectoryCompareContributor;

public class SVNDirectoryMergeAlgorithm
extends ListCompareAlgorithm
implements CompareMergeAlgorithm {
    public static final CompareType SVN_DIRECTORIES = new CompareType("SVN_DIRECTORIES");

    public CompareModel compare(CompareContributor first, CompareContributor second) throws CompareFailedException {
        CompareModel compareModel = super.compare(first, second);
        compareModel.setType(SVN_DIRECTORIES);
        return compareModel;
    }

    public CompareModel merge(CompareContributor first, CompareContributor second, CompareContributor ancestor) throws CompareFailedException {
        SequenceCompareDifference[] diffs;
        SVNDirectoryCompareContributor con1 = (SVNDirectoryCompareContributor)first;
        SVNDirectoryCompareContributor con2 = (SVNDirectoryCompareContributor)second;
        CompareModel compareModel = CompareUtil.createCompareModel(null, (CompareContributor)con1, (CompareContributor)con2, (CompareType)SVN_DIRECTORIES);
        for (SequenceCompareDifference diff : diffs = (SequenceCompareDifference[])compareModel.getDifferences()) {
            diff.setAncestorLength(diff.getFirstLength());
            diff.setAncestorStart(diff.getFirstStart());
            diff.setConflict(true);
            diff.setResolved(false);
            diff.setId((Object)diff.toString());
        }
        compareModel = new SequenceCompareModel((SequenceCompareContributor)con1, (SequenceCompareContributor)con2, (SequenceCompareContributor)con1, diffs);
        return compareModel;
    }
}

