/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.imp;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.svn.imp.SVNImportModel;
import oracle.jdevimpl.vcs.svn.imp.SVNImportWizard;
import oracle.jdevimpl.vcs.svn.res.Resource;

public final class OthersPanel
extends DefaultTraversablePanel {
    private boolean _initialized = false;
    private JMultiLineLabel _hint;
    private JCheckBox _noRecurseCheck;
    private JCheckBox _checkoutCheck;

    public void onEntry(TraversableContext ctx) {
        this.initialize();
        SVNImportModel model = (SVNImportModel)ctx.get(SVNImportWizard.DATA_KEY);
        this._noRecurseCheck.setSelected(!model.getRecursive());
        this._checkoutCheck.setSelected(model.getCheckout());
        ctx.getWizardCallbacks().wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
    }

    public void onExit(TraversableContext ctx) throws TraversalException {
        this.initialize();
        SVNImportModel model = (SVNImportModel)ctx.get(SVNImportWizard.DATA_KEY);
        model.setRecursive(!this._noRecurseCheck.isSelected());
        model.setCheckout(this._checkoutCheck.isSelected());
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        this.createComponents();
        this.layoutComponents();
        this._initialized = true;
    }

    private void createComponents() {
        this._hint = new JMultiLineLabel();
        this._hint.setText(Resource.get("IMPORT_UI_OTHERS_HINT"));
        this._noRecurseCheck = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._noRecurseCheck, (String)Resource.get("IMPORT_UI_NORECURSE"));
        this._checkoutCheck = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._checkoutCheck, (String)Resource.get("IMPORT_UI_CHECKOUT"));
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hint, this.gbc(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 20, 0), 0, 0));
        this.add(this._noRecurseCheck, this.gbc(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._checkoutCheck, this.gbc(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), this.gbc(0, 3, 1, 1, 0.0, 1.0, 16, 3, new Insets(0, 0, 0, 0), 0, 0));
    }
}

