/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.commithistory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.vcs.commithistory.CommitNode;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSDetailException;
import oracle.jdevimpl.compare.CompareIdeViewer;
import oracle.jdevimpl.vcs.svn.SVNExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SVNCommitVersionCompare
extends VCSCommand {
    public static String COMMAND_ID = "oracle.jdeveloper.vcs.svn.commitversioncompare";

    public SVNCommitVersionCompare() {
        super(Ide.findOrCreateCmdID((String)COMMAND_ID));
    }

    protected int doitImpl() throws Exception {
        final String filepath = (String)this.getContext().getProperty("commit-version-file-path");
        final String commitid = (String)this.getContext().getProperty("commit-version-id");
        URL root = (URL)this.getContext().getProperty("commit-svn-root");
        SVNURL rootUrl = SVNURLInfoCache.getInstance().getSVNURL(root);
        final SVNURL fileUrl = SVNUtil.appendPath(rootUrl, filepath);
        final SVNWCClient client = SVNUtil.getWCClient(SVNUtil.getFirstAssociatedRepository(root));
        final URL url = SVNUtil.toURL(fileUrl);
        final String type = SVNUtil.getSuffixAsType(url);
        final String charsetName = StreamDecoder.getDefaultEncoding((URL)url);
        final SVNRevision rev = SVNRevision.create((long)Long.parseLong(commitid));
        RequestProcessor processor = new RequestProcessor("Subversion compare history", 1, true);
        processor.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String filename = null;
                SVNCancellable cancel = new SVNCancellable();
                ProgressHandle handle = ProgressHandle.createHandle((String)Resource.get("COMMIT_COMPARE_PREVIOUS"), (Cancellable)cancel);
                try {
                    handle.start();
                    if (cancel.isCancel()) {
                        return;
                    }
                    ByteArrayOutputStream commitOS = new ByteArrayOutputStream();
                    client.doGetFileContents(fileUrl, rev, rev, false, (OutputStream)commitOS);
                    SVNRevision revPrev = SVNRevision.create((long)(Long.parseLong(commitid) - 1L));
                    ByteArrayOutputStream previous = new ByteArrayOutputStream();
                    if (cancel.isCancel()) {
                        return;
                    }
                    try {
                        client.doGetFileContents(fileUrl, rev, revPrev, false, (OutputStream)previous);
                    }
                    catch (SVNException svne) {
                        svne.printStackTrace();
                    }
                    filename = filepath.substring(filepath.lastIndexOf(47) + 1);
                    String title = previous.size() == 0 ? Resource.get("COMMIT_HISTORY_NOFILE") : Resource.format("COMMIT_HISTORY_PREVIOUS", filename, revPrev.toString());
                    InputStreamTextContributor prvContrib = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(previous.toByteArray()), charsetName, title, title, type);
                    title = Resource.format("COMMIT_HISTORY_REVISION", filename, rev.toString());
                    InputStreamTextContributor commitContrib = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(commitOS.toByteArray()), charsetName, title, title, type);
                    if (cancel.isCancel()) {
                        return;
                    }
                    CompareIdeViewer.getCompareIdeViewer().show((CompareContributor)prvContrib, (CompareContributor)commitContrib, (Element)new CommitNode(url));
                }
                catch (Exception ex) {
                    SVNProfile.getQualifiedLogger(SVNCommitVersionCompare.class.getName()).log(Level.WARNING, ex.getMessage());
                    if (filename != null) {
                        VCSDetailException exception = new VCSDetailException(Resource.get("COMMIT_COMPARE_ERROR_TITLE"), Resource.format("COMMIT_COMPARE_ERROR", filename), ex.getMessage());
                        new SVNExceptionHandler().handleException((Exception)exception);
                    }
                }
                finally {
                    handle.finish();
                }
            }
        });
        return 0;
    }

    private static class SVNCancellable
    implements Cancellable {
        private boolean _cancel = false;

        private SVNCancellable() {
        }

        public boolean cancel() {
            this._cancel = true;
            return this._cancel;
        }

        private boolean isCancel() {
            return this._cancel;
        }
    }
}

