/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.client;

import java.util.HashMap;
import java.util.Map;

public final class SVNRAInfo {
    public static final String RA_PROTOCOL_HTTP = "http";
    public static final String RA_PROTOCOL_HTTPS = "https";
    public static final String RA_PROTOCOL_FILE = "file";
    public static final String RA_PROTOCOL_SVN = "svn";
    public static final String RA_PROTOCOL_SVNSSH = "svn+ssh";
    private final Map _supports = new HashMap(10);

    public SVNRAInfo(boolean supportsHTTP, boolean supportsHTTPS, boolean supportsFile, boolean supportsSVN, boolean supportsSVNSSH) {
        this._supports.put(RA_PROTOCOL_HTTP, supportsHTTP);
        this._supports.put(RA_PROTOCOL_HTTPS, supportsHTTPS);
        this._supports.put(RA_PROTOCOL_FILE, supportsFile);
        this._supports.put(RA_PROTOCOL_SVN, supportsSVN);
        this._supports.put(RA_PROTOCOL_SVNSSH, supportsSVNSSH);
    }

    public boolean supportsProtocol(String protocol) {
        Boolean supported = (Boolean)this._supports.get(protocol);
        return supported != null ? supported : false;
    }

    public boolean supportsHTTP() {
        return this.supportsProtocol(RA_PROTOCOL_HTTP);
    }

    public boolean supportsHTTPS() {
        return this.supportsProtocol(RA_PROTOCOL_HTTPS);
    }

    public boolean supportsFile() {
        return this.supportsProtocol(RA_PROTOCOL_FILE);
    }

    public boolean supportsSVN() {
        return this.supportsProtocol(RA_PROTOCOL_SVN);
    }

    public boolean supportsSVNSSH() {
        return this.supportsProtocol(RA_PROTOCOL_SVNSSH);
    }
}

