/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.adapter.javahl;

import java.util.logging.Level;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.vcs.util.VCSOperatingSystem;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.adapter.javahl.OJhlClientAdapter;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;

public class OJhlClientAdapterFactory
extends SVNClientAdapterFactory {
    public static final String JAVAHL_CLIENT = "javahl";

    private OJhlClientAdapterFactory() {
    }

    protected ISVNClientAdapter createSVNClientImpl() {
        return new OJhlClientAdapter();
    }

    protected String getClientType() {
        return JAVAHL_CLIENT;
    }

    public static void setup() throws SVNClientException {
        if (!OJhlClientAdapterFactory.isAvailable()) {
            if (!IdeUtil.isHeadless()) {
                throw new SVNClientException(Resource.get("INFO_NO_JAVAHL"));
            }
            return;
        }
        SVNClientAdapterFactory.registerAdapterFactory((SVNClientAdapterFactory)new OJhlClientAdapterFactory());
    }

    public static boolean isAvailable() {
        boolean available = JhlClientAdapterFactory.isAvailable();
        if (!available) {
            String error = OJhlClientAdapterFactory.getLibraryLoadErrors();
            if (error.startsWith("Incompatible JavaHL library loaded.  1.6.x")) {
                if (!VCSOperatingSystem.isWindows()) {
                    try {
                        System.loadLibrary("libsvnjavahl-1");
                    }
                    catch (Exception ex) {
                        return false;
                    }
                    catch (UnsatisfiedLinkError le) {
                        return false;
                    }
                }
                return true;
            }
            if (!IdeUtil.isHeadless()) {
                SVNProfile.getQualifiedLogger(OJhlClientAdapterFactory.class.getName()).log(Level.WARNING, "JavaHL Error " + error);
            }
        }
        return available;
    }

    public static boolean isOsWindows() {
        return JhlClientAdapterFactory.isOsWindows();
    }

    public static String getLibraryLoadErrors() {
        return JhlClientAdapterFactory.getLibraryLoadErrors();
    }
}

