/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import oracle.ide.config.Preferences;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.prefs.SVNEnvironmentPrefs;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.svn.util.TimingUtil;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;

public final class SVNOverlayProducer
extends VCSOverlayItemProducer {
    private static final Icon sUnmodifiedDirIcon = OracleIcons.getIcon((String)"extras/overlay_sandbox.png");
    private static final Icon sLocked = OracleIcons.getIcon((String)"extras/overlay_locked.png");
    private static final String TIMING_CTX_PRODUCE = "produce";
    private static final String TIMING_CTX_DECORATE = "decorate";
    private final VCSProfile _profile;
    private final VCSStatusFilter _remoteFilter;
    private SVNStatusClient _client;
    private final Lock _prefsLock = new ReentrantLock();
    private SVNEnvironmentPrefs _prefs;

    public SVNOverlayProducer(StatusCache<VCSStatus> statusCache) {
        super(null, statusCache);
        this._profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
        this._remoteFilter = this._profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.EXISTS_REMOTELY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IconOverlay produceOverlay(URL url, VCSStatus status) throws Exception {
        SVNEnvironmentPrefs prefs = this.getPreferences();
        boolean useIcons = prefs.getUseOverlays();
        boolean useLabels = prefs.getUseLabelDecorations();
        if (SVNRepositoryManager.getInstance().isEmpty() || !useIcons && !useLabels) {
            return null;
        }
        String timingContext = this.beginTimeOverlay(TIMING_CTX_PRODUCE, url);
        try {
            if (useLabels) {
                IconOverlay iconOverlay = this.getDecoratedOverlay(url, status, useIcons);
                return iconOverlay;
            }
            IconOverlay iconOverlay = new IconOverlay(useIcons ? status.getOverlay().getIcon() : null, null, null);
            return iconOverlay;
        }
        finally {
            this.endTimeOverlay(timingContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IconOverlay getDecoratedOverlay(URL url, VCSStatus status, boolean useIcons) throws Exception {
        String timingContext = this.beginTimeOverlay(TIMING_CTX_DECORATE, url);
        try {
            String tooltip = this.createTooltip(url, status);
            if (this.isLocked(url)) {
                IconOverlay iconOverlay = new IconOverlay(sLocked, this.createLabelDecoration(url), tooltip);
                return iconOverlay;
            }
            if (URLFileSystem.isDirectory((URL)url)) {
                boolean unmodified;
                boolean bl = unmodified = status == this._profile.getStatusInstance("UNMODIFIED");
                IconOverlay iconOverlay = new IconOverlay(useIcons ? (unmodified ? sUnmodifiedDirIcon : status.getOverlay().getIcon()) : null, null, tooltip);
                return iconOverlay;
            }
            IconOverlay iconOverlay = new IconOverlay(useIcons ? status.getOverlay().getIcon() : null, this.createLabelDecoration(url), tooltip);
            return iconOverlay;
        }
        finally {
            this.endTimeOverlay(timingContext);
        }
    }

    private boolean isLocked(URL url) throws SVNException {
        try {
            this._client = this.getClient();
            SVNStatus status = this._client.doStatus(SVNUtil.toFile(url), false);
            if (status == null || status.getLocalLock() == null) {
                return false;
            }
        }
        catch (SVNException ex) {
            return false;
        }
        return true;
    }

    private SVNStatusClient getClient() {
        if (this._client != null) {
            return this._client;
        }
        return SVNUtil.getStatusClient();
    }

    private String createLabelDecoration(URL url) throws SVNException, IOException {
        FastStringBuffer buff = new FastStringBuffer(50);
        Node node = NodeFactory.find((URL)url);
        if (node != null && node instanceof Project) {
            SVNUrl reposUrl = SVNURLInfoCache.getInstance().getURL(url);
            if (reposUrl != null) {
                String hostName = reposUrl.getHost();
                if (hostName == null || hostName.trim().equals("")) {
                    hostName = "localhost";
                }
                buff.append('[').append(hostName).append(']');
            }
        } else {
            long revInt = SVNURLInfoCache.getInstance().getLastChangedRevision(url);
            if (revInt > -1L) {
                buff.append(' ').append(String.valueOf(revInt));
            }
        }
        return buff.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createTooltip(URL url, VCSStatus status) throws SVNException, IOException {
        SVNURLInfoCache cache = SVNURLInfoCache.getInstance();
        long revInt = cache.getLastChangedRevision(url);
        if (revInt <= -1L) return status.getOverlay().getToolTipText();
        FastStringBuffer buff = new FastStringBuffer(50);
        buff.append("svn: ");
        buff.append(String.valueOf(revInt));
        buff.append(" - ");
        String author = cache.getLastCommitAuthor(url);
        if (author != null) {
            buff.append(author);
            buff.append(" - ");
        }
        if (SVNUtil.isModified(status, this._profile)) {
            boolean propsModified = SVNUtil.isPropertiesModified(url);
            boolean textModified = SVNUtil.isTextModified(url);
            if (propsModified && textModified) {
                buff.append(Resource.get("TOOLTIP_FRAG_PROPS_TEXT_MODIFIED"));
                return buff.toString();
            } else if (propsModified) {
                buff.append(Resource.get("TOOLTIP_FRAG_PROPS_MODIFIED"));
                return buff.toString();
            } else {
                if (!textModified) throw new IllegalStateException();
                buff.append(Resource.get("TOOLTIP_FRAG_TEXT_MODIFIED"));
            }
            return buff.toString();
        } else if (SVNUtil.isConflicted(status, this._profile)) {
            boolean propsConflicted = SVNUtil.isPropertiesConflicted(url);
            boolean textConflicted = SVNUtil.isTextConflicted(url);
            boolean treeConflicted = SVNUtil.isTreeConflicted(url);
            if (propsConflicted && textConflicted) {
                buff.append(Resource.get("TOOLTIP_FRAG_PROPS_TEXT_CONFLICT"));
                return buff.toString();
            } else if (propsConflicted) {
                buff.append(Resource.get("TOOLTIP_FRAG_PROPS_CONFLICT"));
                return buff.toString();
            } else if (textConflicted) {
                buff.append(Resource.get("TOOLTIP_FRAG_TEXT_CONFLICT"));
                return buff.toString();
            } else {
                if (!treeConflicted) throw new IllegalStateException();
                buff.append(Resource.get("TOOLTIP_FRAG_TREE_CONFLICT"));
            }
            return buff.toString();
        } else if (SVNUtil.isIgnored(status, this._profile)) {
            buff.append(Resource.get("TOOLTIP_FRAG_IGNORED"));
            return buff.toString();
        } else {
            buff.append(status.getOverlay().getToolTipText());
        }
        return buff.toString();
    }

    private String beginTimeOverlay(String contextOperation, URL url) {
        if (TimingUtil.canTime()) {
            String context = contextOperation + ".{" + URLFileSystem.getPlatformPathName((URL)url) + "}";
            TimingUtil.beginTiming(((Object)((Object)this)).getClass(), context);
            return context;
        }
        return null;
    }

    private void endTimeOverlay(String context) {
        if (context != null) {
            TimingUtil.endTiming(((Object)((Object)this)).getClass(), context);
        }
    }

    public void preferencesChanged() {
        this._prefsLock.lock();
        try {
            this._prefs = null;
        }
        finally {
            this._prefsLock.unlock();
        }
    }

    private final SVNEnvironmentPrefs getPreferences() {
        this._prefsLock.lock();
        try {
            if (this._prefs == null) {
                this._prefs = SVNEnvironmentPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
            }
            SVNEnvironmentPrefs sVNEnvironmentPrefs = this._prefs;
            return sVNEnvironmentPrefs;
        }
        finally {
            this._prefsLock.unlock();
        }
    }
}

