/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.awt.Component;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.log.LogManager;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.util.VCSConfigUtils;
import oracle.jdeveloper.vcs.util.VCSIdeEventRecorder;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.client.SVNClient;
import oracle.jdevimpl.vcs.svn.client.SVNClientRegistry;
import oracle.jdevimpl.vcs.svn.prefs.SVNClientsPreferences;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public final class SVNClientSelector
extends StructureChangeListener {
    private final VCSProfile _profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");

    public SVNClientSelector() {
        this.structureValuesChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void structureValuesChanged(StructureChangeEvent sce) {
        if (!VCSConfigUtils.isSignificantStructureChange((StructureChangeEvent)sce)) {
            return;
        }
        if (!this.clientBindingsAvailable()) {
            this.feedbackNoBindings();
            return;
        }
        int preferredClient = SVNClientsPreferences.getInstance((PropertyStorage)Preferences.getPreferences()).getClientType();
        SVNClientRegistry reg = SVNClientRegistry.getInstance();
        try {
            switch (preferredClient) {
                case 1: {
                    reg.setContextClient(SVNProfile.IDE_CLIENT_CONTEXT_ID, reg.getNativeClient());
                    return;
                }
                case 2: {
                    reg.setContextClient(SVNProfile.IDE_CLIENT_CONTEXT_ID, reg.getSVNKitClient());
                    return;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (SVNClientException ce) {
            Object[] defaults = this.getDefaultClient();
            if (defaults == null) {
                reg.setContextClient(SVNProfile.IDE_CLIENT_CONTEXT_ID, null);
                SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning("No default client");
                throw new IllegalStateException("No default client");
            }
            reg.setContextClient(SVNProfile.IDE_CLIENT_CONTEXT_ID, (SVNClient)defaults[0]);
            this.feedbackDefaultBinding();
            return;
        }
        finally {
            if (this._profile.getPolicyStatusCache() != null) {
                this._profile.getPolicyStatusCache().clear();
            }
            SVNURLInfoCache.getInstance().clear();
        }
    }

    private Object[] getDefaultClient() {
        try {
            SVNClientRegistry reg = SVNClientRegistry.getInstance();
            if (reg.isNativeClientAvailable()) {
                return new Object[]{reg.getNativeClient(), new Integer(1)};
            }
            if (reg.isSVNKitClientAvailable()) {
                return new Object[]{reg.getSVNKitClient(), new Integer(2)};
            }
            return null;
        }
        catch (SVNClientException ce) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning("No client available");
            return null;
        }
    }

    private boolean clientBindingsAvailable() {
        SVNClientRegistry reg = SVNClientRegistry.getInstance();
        return reg.isNativeClientAvailable() || reg.isSVNKitClientAvailable();
    }

    private void feedbackDefaultBinding() {
        if (VCSIdeEventRecorder.hasMainWindowOpened()) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.get("INFO_MSG_DEFAULT_CLIENT"), (String)Resource.get("INFO_TITLE_DEFAULT_CLIENT"), (String)"f1_svnuseddefaultclient_html");
        } else {
            LogManager.getLogManager().getMsgPage().log((Object)Resource.get("INFO_MSG_DEFAULT_CLIENT"));
        }
    }

    private void feedbackNoBindings() {
        String message = null;
        message = PlatformUtils.isWindows() ? Resource.get("ERROR_MSG_NO_CLIENTS_WIN32") : (PlatformUtils.isLinux() ? Resource.get("ERROR_MSG_NO_CLIENTS_LINUX") : Resource.get("ERROR_MSG_NO_CLIENTS_GENERIC"));
        if (VCSIdeEventRecorder.hasMainWindowOpened()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)message, (String)Resource.get("ERROR_TITLE_NO_CLIENTS"), (String)"f1_subversionclientunavailable_html");
        } else {
            LogManager.getLogManager().getMsgPage().log((Object)message);
        }
    }
}

