/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.shapes;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.DrawableObjectMap;

public abstract class DrawableObjectParser {
    protected Map<String, DrawableObjectMap> m_objMap;
    protected ErrorHandler m_eh;

    public DrawableObjectParser(ErrorHandler eh) {
        this.m_eh = eh;
        this.m_objMap = new HashMap<String, DrawableObjectMap>();
    }

    public void addObj(String groupName, String objKey, DrawableObject obj) {
        DrawableObjectMap map = this.m_objMap.get(groupName);
        if (map == null) {
            map = new DrawableObjectMap();
        }
        map.put(objKey, obj);
        this.m_objMap.put(groupName, map);
    }

    public DrawableObjectMap getObjects(String groupName) {
        return this.m_objMap.get(groupName);
    }

    public Map<String, DrawableObjectMap> getObjectMap() {
        return this.m_objMap;
    }

    public abstract void parseFile(String var1);

    public abstract void parseFile(InputStream var1);
}

