/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.shapes;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Fill;
import oracle.dss.util.shapes.Stroke;

public class Container
extends DrawableObject {
    protected ArrayList<DrawableObject> m_drawables;

    public Container(String id) {
        super(null);
        this.setID(id);
        this.m_drawables = new ArrayList();
    }

    public void add(DrawableObject obj) {
        this.m_drawables.add(obj);
    }

    public DrawableObject remove(int index) {
        return this.m_drawables.remove(index);
    }

    public List<DrawableObject> getDrawables() {
        return this.m_drawables;
    }

    @Override
    public void setTransform(AffineTransform at) {
        List<DrawableObject> drawables = this.getDrawables();
        for (DrawableObject obj : drawables) {
            if (obj.getTransform() == null) {
                obj.setTransform(at);
                continue;
            }
            at.concatenate(obj.getTransform());
            obj.setTransform(at);
        }
    }

    @Override
    public void setFill(Fill f) {
        List<DrawableObject> drawables = this.getDrawables();
        for (DrawableObject obj : drawables) {
            if (obj.getFill() != null) continue;
            obj.setFill(f);
        }
    }

    @Override
    public void setStroke(Stroke s) {
        List<DrawableObject> drawables = this.getDrawables();
        for (DrawableObject obj : drawables) {
            if (obj.getStroke() != null) continue;
            obj.setStroke(s);
        }
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D bounds = null;
        List<DrawableObject> drawables = this.getDrawables();
        for (DrawableObject obj : drawables) {
            Rectangle2D objBounds = obj.getBounds();
            if (obj.getTransform() != null) {
                objBounds = obj.getTransform().createTransformedShape(obj.getShape()).getBounds2D();
            }
            if (bounds == null) {
                bounds = objBounds;
                continue;
            }
            bounds.add(objBounds);
        }
        return bounds;
    }
}

