/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.math.CurveFitIF;
import oracle.dss.graph.pfj.math.FP;

public class FitModHyperbolic
implements CurveFitIF {
    private static final int NUM_COEFFS = 2;

    @Override
    public double compute(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= 3);
        double y = 1.0 / (a[1] + a[2] * x);
        if (Double.isNaN(y)) {
            throw new AssertionException();
        }
        return y;
    }

    @Override
    public void eval(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= 3);
        a[1] = 1.0;
        a[2] = x;
    }

    @Override
    public int numCoeffs() {
        return 2;
    }

    @Override
    public double transformY(double y) throws AssertionException {
        PfjAssert.pfjAssert(FP.nonzero(y));
        return 1.0 / y;
    }

    @Override
    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    @Override
    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) throws AssertionException {
        PfjAssert.pfjAssert(strCoeffs.length >= 3);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + " * x";
        if (bHighOrderFirst) {
            return "y = 1 / (" + strTerm2 + " + " + strTerm1 + ")";
        }
        return "y = 1 / (" + strTerm1 + " + " + strTerm2 + ")";
    }
}

