/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.TDGMouseState;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.event.TDGEventManager;

public class SelList
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SELMODE_NONE = 0;
    public static final int SELMODE_SINGLE = 1;
    public static final int SELMODE_ALLIFDATA = 2;
    public static final int SELMODE_ALL = 3;
    public static final int SELMODE_ZOOM_POINT = 4;
    public static final int SELMODE_ZOOM_RECT = 5;
    private static final int HANDLE_SIZE = 6;
    private static final int BOX_SIZE_MIN = 10;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_RESIZE = 1;
    private static final int ACTION_MOVE = 2;
    private static final int ACTION_BARRESIZE = 3;
    private static final int LEFT_TOP = 0;
    private static final int TOP = 1;
    private static final int RIGHT_TOP = 2;
    private static final int RIGHT = 3;
    private static final int RIGHT_BOTTOM = 4;
    private static final int BOTTOM = 5;
    private static final int LEFT_BOTTOM = 6;
    private static final int LEFT = 7;
    private Vector m_selList;
    private Perspective m_Perspective;
    private int m_nCurrentItem;
    private Rectangle[] m_rHandles;
    private int m_nActiveHandle;
    private Rectangle m_rOriginalPos;
    private Point m_DeltaPos;
    private int m_nAction;
    private Rectangle m_rSelBounds;
    private Vector m_MovingOriginalDelta;
    private Vector m_MovingOriginal;
    private double m_nResizeValue;
    private boolean m_bDragged;
    private int m_nResizeCoord;
    private int m_nOriginalResizeCoord;
    private int m_nOriginalResizeCoordBase;
    private int m_nScaling;
    private int m_nDirection;
    private DataItem m_item;
    private Point m_ptMouseDown;
    private boolean m_bCanSwitchDirection;
    TDGMouseState m_mouseStateDeadZone = null;
    private Rectangle m_rBoundParent;

    public SelList(Perspective perspective) {
        this.m_Perspective = perspective;
        this.m_selList = new Vector(10);
        this.m_nCurrentItem = 0;
        this.m_nActiveHandle = -1;
    }

    public boolean add(Graphics g, Point pt, boolean bAdd, boolean bSelectRelatedObjects, int nSelectionMode, VC vc) {
        if (nSelectionMode == 0) {
            return false;
        }
        DetObj detObj = this.m_Perspective.getDetectiv().findNodeOf(pt.x, pt.y, vc);
        if (detObj != null) {
            if (!(detObj.getObjectID() != 499 && detObj.getObjectID() != 500 || bSelectRelatedObjects)) {
                detObj = this.m_Perspective.getDetectiv().findNodeOf(new IdentObj(2));
            }
            this.add(g, detObj, bAdd, bSelectRelatedObjects, nSelectionMode, vc);
            return true;
        }
        return false;
    }

    public void add(Graphics g, DetObj detObj, boolean bAdd, boolean bSelectRelatedObjects, int nSelectionMode, VC vc) {
        TDGEventManager evtMgr = this.m_Perspective.getEventManager();
        int nColorMode = this.m_Perspective.isColorByHeight() ? 3 : (this.m_Perspective.isColorByGroup() ? 2 : 1);
        switch (nSelectionMode) {
            case 0: 
            case 4: 
            case 5: {
                break;
            }
            case 1: {
                if (this.isInList(detObj)) {
                    return;
                }
                this.clear(g, vc);
                switch (detObj.getObjectID()) {
                    case 256: 
                    case 258: 
                    case 314: 
                    case 315: 
                    case 316: 
                    case 317: 
                    case 318: 
                    case 473: 
                    case 475: 
                    case 476: {
                        Enumeration e = this.m_Perspective.getDetectiv().getList();
                        while (e.hasMoreElements()) {
                            DetObj dto = (DetObj)e.nextElement();
                            if (!dto.isDetectable() || !dto.isHiliteable() || !detObj.isSelRelated(dto, nColorMode) || detObj.getObjectID() != dto.getObjectID()) continue;
                            this.m_selList.addElement(dto);
                            this.hiliteDetObj(g, dto, vc);
                        }
                        break;
                    }
                    default: {
                        this.m_selList.addElement(detObj);
                        this.hiliteDetObj(g, detObj, vc);
                    }
                }
                evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3959, this.m_mouseStateDeadZone);
                break;
            }
            case 2: 
            case 3: {
                if (nSelectionMode == 2 && !detObj.getIdentID().isSeriesRelated()) {
                    this.clear(g, vc);
                    return;
                }
                if (this.isInList(detObj)) {
                    return;
                }
                if (!bAdd) {
                    this.clear(g, vc);
                }
                this.m_selList.addElement(detObj);
                this.hiliteDetObj(g, detObj, vc);
                if (bSelectRelatedObjects) {
                    int nFound = 0;
                    Enumeration e = this.m_Perspective.getDetectiv().getList();
                    while (e.hasMoreElements()) {
                        DetObj dto = (DetObj)e.nextElement();
                        if (detObj.equals(dto)) {
                            ++nFound;
                            continue;
                        }
                        if (!dto.isDetectable() || !dto.isHiliteable() || !detObj.isSelRelated(dto, nColorMode)) continue;
                        this.m_selList.addElement(dto);
                        this.hiliteDetObj(g, dto, vc);
                    }
                }
                evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3959, this.m_mouseStateDeadZone);
            }
        }
    }

    public void calc() {
        Vector sl = this.m_selList;
        this.m_selList = new Vector(sl.size());
        Enumeration eSelList = sl.elements();
        while (eSelList.hasMoreElements()) {
            DetObj selObj = (DetObj)eSelList.nextElement();
            int nFound = 0;
            Enumeration eDetList = this.m_Perspective.getDetectiv().getList();
            while (eDetList.hasMoreElements()) {
                DetObj detObj = (DetObj)eDetList.nextElement();
                if (selObj.equals(detObj)) {
                    this.m_selList.addElement(detObj);
                    ++nFound;
                    continue;
                }
                if (!detObj.isExceptional() && !selObj.isExceptional()) continue;
                IdentObj idDet = detObj.getIdentID().stripExceptional();
                IdentObj idSel = selObj.getIdentID().stripExceptional();
                if (!idSel.equals(idDet)) continue;
                this.m_selList.addElement(detObj);
                ++nFound;
                TDGEventManager evtMgr = this.m_Perspective.getEventManager();
                evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3959, null);
            }
        }
    }

    public void clear(Graphics g, VC vc) {
        Enumeration e = this.m_selList.elements();
        while (e.hasMoreElements()) {
            DetObj detObj = (DetObj)e.nextElement();
            this.hiliteDetObj(g, detObj, vc);
        }
        this.m_selList.removeAllElements();
    }

    public void saveDeadZoneMouseState(TDGMouseState mouseState) {
        this.m_mouseStateDeadZone = mouseState;
    }

    public void dump() {
        Enumeration e = this.m_selList.elements();
        while (e.hasMoreElements()) {
            DetObj detObj = (DetObj)e.nextElement();
            IdentObj id = detObj.getIdentID();
            int s = id.getSeriesID();
            int g = id.getGroupID();
        }
    }

    private DetObj findNodeOf(int x, int y, VC vc) {
        DetObj detObj = null;
        boolean bFound = false;
        Enumeration e = this.m_selList.elements();
        while (e.hasMoreElements()) {
            detObj = (DetObj)e.nextElement();
            if (!detObj.isPointInObj(x, y, vc)) continue;
            bFound = true;
        }
        return detObj;
    }

    public DetObj firstDetObjElement() {
        this.m_nCurrentItem = 0;
        DetObj aDetObj = null;
        if (this.hasMoreElements()) {
            aDetObj = (DetObj)this.m_selList.elementAt(this.m_nCurrentItem);
        }
        return aDetObj;
    }

    public IdentObj firstElement() {
        this.m_nCurrentItem = 0;
        IdentObj id = null;
        if (this.hasMoreElements()) {
            id = ((DetObj)this.m_selList.elementAt(this.m_nCurrentItem)).getIdentID();
        }
        if (id != null) {
            id = id.getObjectID() == 270 ? new IdentObj(id.getObjectID(), id.getSeriesID(), id.getGroupID(), id.getStackID(), id.getMiscID()) : new IdentObj(id.getObjectID(), id.getSeriesID(), id.getGroupID(), id.getStackID(), -3);
        }
        return id;
    }

    public boolean hasMoreElements() {
        return this.m_nCurrentItem < this.m_selList.size();
    }

    public void hilite(Graphics g, VC vc) {
        Enumeration e = this.m_selList.elements();
        while (e.hasMoreElements()) {
            DetObj detObj = (DetObj)e.nextElement();
            this.hiliteDetObj(g, detObj, vc);
        }
    }

    private void hiliteDetObj(Graphics g, DetObj detObj, VC vc) {
        if (detObj.isMoveable() && this.m_Perspective.getSelectionEnableMove()) {
            if (detObj.getObjectID() == 620) {
                detObj = this._getFunnelBoundRect(detObj.getObjectID());
            }
            this.hiliteWithHandles(g, detObj, vc);
        } else if (detObj.isHiliteable()) {
            detObj.hilite(g, vc);
        }
    }

    private DetObj _getFunnelBoundRect(int id) {
        IdentObj identObj = new IdentObj(id);
        identObj.setMiscID(627);
        return this.m_Perspective.getDetectiv().findNodeOf(identObj);
    }

    public void hiliteResizer(Graphics g, DetObj detObj, VC vc) {
        Rectangle rBound = vc.virtToDest(detObj.getBounds());
        int nResizeCoord = this.m_nResizeCoord;
        if (this.m_nScaling != 1) {
            nResizeCoord += this.m_nOriginalResizeCoordBase;
        }
        g.setXORMode(Color.yellow);
        if (this.m_nDirection == 1) {
            g.drawLine(rBound.x + rBound.width, nResizeCoord, rBound.x + rBound.width + 5, nResizeCoord);
        } else {
            g.drawLine(nResizeCoord, rBound.y + rBound.height, nResizeCoord, rBound.y + rBound.height + 5);
        }
        Font font = new Font("Geneva", 0, 14);
        g.setFont(font);
        String str = TDGNumberFormat.toString(this.m_Perspective, 17, this.m_nResizeValue, "");
        if (this.m_Perspective.isNumberFormatCallBack()) {
            this.m_Perspective.getNumberFormatCallBack().setState(3, detObj.getSeriesID(), detObj.getGroupID(), -1, -3);
            str = this.m_Perspective.getNumberFormatCallBack().toString(this.m_nResizeValue);
        }
        if (this.m_nDirection == 1) {
            g.drawString(str, rBound.x + rBound.width + 7, nResizeCoord + 4);
        } else {
            g.drawString(str, nResizeCoord + 4, rBound.y + rBound.height + 7);
        }
        g.setPaintMode();
    }

    protected void hiliteWithHandles(Graphics g, DetObj detObj, VC vc) {
        Rectangle dest = vc.virtToDest(detObj.getLooseBounds());
        g.setXORMode(Color.yellow);
        int nLeft = dest.x - 3;
        int nXMiddle = dest.x + (dest.width - 3) / 2;
        int nRight = dest.x + dest.width + 1 - 3 - 1;
        int nBottom = dest.y + dest.height + 1 - 3 - 1;
        int nYMiddle = dest.y + (dest.height - 6) / 2;
        int nTop = dest.y - 3;
        this.m_rHandles = new Rectangle[8];
        this.m_rHandles[0] = new Rectangle(nLeft, nTop, 6, 6);
        this.m_rHandles[1] = new Rectangle(nXMiddle, nTop, 6, 6);
        this.m_rHandles[2] = new Rectangle(nRight, nTop, 6, 6);
        this.m_rHandles[3] = new Rectangle(nRight, nYMiddle, 6, 6);
        this.m_rHandles[4] = new Rectangle(nRight, nBottom, 6, 6);
        this.m_rHandles[5] = new Rectangle(nXMiddle, nBottom, 6, 6);
        this.m_rHandles[6] = new Rectangle(nLeft, nBottom, 6, 6);
        this.m_rHandles[7] = new Rectangle(nLeft, nYMiddle, 6, 6);
        for (int i = 0; i < 8; ++i) {
            g.fillRect(this.m_rHandles[i].x, this.m_rHandles[i].y, this.m_rHandles[i].width, this.m_rHandles[i].height);
        }
        g.drawLine(dest.x + 3 + 1, dest.y, nXMiddle - 3 + 1, dest.y);
        g.drawLine(nXMiddle + 6, dest.y, nRight - 3 + 1, dest.y);
        g.drawLine(dest.x + 3 + 1, dest.y + dest.height, nXMiddle - 3 + 1, dest.y + dest.height);
        g.drawLine(nXMiddle + 6, dest.y + dest.height, nRight - 3 + 1, dest.y + dest.height);
        g.drawLine(dest.x, nTop + 6, dest.x, nYMiddle - 3 + 1);
        g.drawLine(dest.x, nYMiddle + 6, dest.x, nBottom - 3 + 1);
        g.drawLine(dest.x + dest.width, nTop + 6, dest.x + dest.width, nYMiddle - 3 + 1);
        g.drawLine(dest.x + dest.width, nYMiddle + 6, dest.x + dest.width, nBottom - 3 + 1);
        g.setPaintMode();
    }

    public boolean ptInsideHandles(Point ptPressed) {
        boolean bInside = false;
        if (this.m_rHandles != null) {
            for (int i = 0; i < 8; ++i) {
                if (!this.m_rHandles[i].contains(ptPressed.x, ptPressed.y)) continue;
                bInside = true;
                break;
            }
        }
        return bInside;
    }

    public boolean isEmpty() {
        return this.m_selList.size() == 0;
    }

    public int size() {
        return this.m_selList.size();
    }

    private boolean isInList(DetObj detObj) {
        DetObj dobj = null;
        boolean bFound = false;
        Enumeration e = this.m_selList.elements();
        while (e.hasMoreElements()) {
            dobj = (DetObj)e.nextElement();
            if (!dobj.equals(detObj)) continue;
            bFound = true;
        }
        return bFound;
    }

    public void mouseDown(Graphics g, Point pt, boolean bAdd, boolean bSelectRelatedObjects, boolean bBarResize, VC vc) {
        DetObj detObj;
        int nSelectionMode = this.m_Perspective.getSelectionEnable();
        boolean bSelectionEnableMove = this.m_Perspective.getSelectionEnableMove();
        JGraphType gt = this.m_Perspective.getJGraphType();
        this.m_nAction = 0;
        this.m_nScaling = gt.getScalingMethod();
        this.m_nDirection = gt.getPreferredResizeDirection();
        this.m_item = gt.getPreferredResizeItem();
        this.m_ptMouseDown = new Point(pt.x, pt.y);
        this.m_bCanSwitchDirection = gt.getCanSwitchDirection();
        if (nSelectionMode == 0) {
            return;
        }
        this.m_rBoundParent = new Rectangle(this.m_Perspective.getThickPFJ().getSize());
        if (bSelectionEnableMove && this.m_selList.size() == 1 && (detObj = (DetObj)this.m_selList.elementAt(0)).isMoveable()) {
            for (int i = 0; i < 8; ++i) {
                if (!this.m_rHandles[i].contains(pt.x, pt.y)) continue;
                this.m_nActiveHandle = i;
                this.m_rOriginalPos = vc.virtToDest(detObj.getBounds());
                this.m_DeltaPos = new Point(pt.x - this.m_rHandles[i].x - this.m_rHandles[i].width / 2, pt.y - this.m_rHandles[i].y - this.m_rHandles[i].height / 2);
                this.m_nAction = 1;
                return;
            }
        }
        this.add(g, vc.destToVirt(pt), bAdd, bSelectRelatedObjects, nSelectionMode, vc);
        IdentObj id = this.firstElement();
        if (id == null) {
            return;
        }
        int nObj = id.getObjectID();
        int nListSize = this.m_selList.size();
        if (bBarResize && this.m_selList.size() == 1 && (nObj == 277 || nObj == 259 || nObj == 354)) {
            if (this.m_nDirection == 1) {
                this.m_nOriginalResizeCoord = this.m_nResizeCoord = vc.virtToDestY(this.m_Perspective.getDataCoord(id, this.m_item, false));
                if (this.m_nScaling != 1) {
                    this.m_nOriginalResizeCoordBase = vc.virtToDestY(this.m_Perspective.getDataCoord(id, this.m_item, true)) - vc.virtToDestY(this.m_Perspective.getDataCoord(id, this.m_item, false));
                }
            } else {
                this.m_nOriginalResizeCoord = this.m_nResizeCoord = vc.virtToDestX(this.m_Perspective.getDataCoord(id, this.m_item, false));
                if (this.m_nScaling != 1) {
                    this.m_nOriginalResizeCoordBase = vc.virtToDestX(this.m_Perspective.getDataCoord(id, this.m_item, true)) - vc.virtToDestX(this.m_Perspective.getDataCoord(id, this.m_item, false));
                }
            }
            this.hiliteResizer(g, this.firstDetObjElement(), vc);
            this.m_nAction = 3;
            this.m_bDragged = false;
            return;
        }
        if (bSelectionEnableMove && !this.m_selList.isEmpty()) {
            Rectangle rBounds;
            DetObj detObj2;
            Enumeration e = this.m_selList.elements();
            while (e.hasMoreElements()) {
                detObj2 = (DetObj)e.nextElement();
                rBounds = vc.virtToDest(detObj2.getLooseBounds());
                if (!rBounds.contains(pt.x, pt.y) || !detObj2.isMoveable()) continue;
                this.m_rOriginalPos = new Rectangle(rBounds.x, rBounds.y, rBounds.width, rBounds.height);
                this.m_nAction = 2;
                this.m_DeltaPos = new Point(pt.x - rBounds.x, pt.y - rBounds.y);
                break;
            }
            if (this.m_nAction == 2) {
                this.m_rSelBounds = null;
                this.m_MovingOriginalDelta = new Vector();
                this.m_MovingOriginal = new Vector();
                e = this.m_selList.elements();
                while (e.hasMoreElements()) {
                    detObj2 = (DetObj)e.nextElement();
                    if (!detObj2.isMoveable()) continue;
                    rBounds = vc.virtToDest(detObj2.getBounds());
                    if (this.m_rSelBounds != null) {
                        this.m_rSelBounds = this.m_rSelBounds.union(rBounds);
                        continue;
                    }
                    this.m_rSelBounds = new Rectangle(rBounds.x, rBounds.y, rBounds.width, rBounds.height);
                }
                this.m_rOriginalPos = new Rectangle(this.m_rSelBounds.x, this.m_rSelBounds.y, this.m_rSelBounds.width, this.m_rSelBounds.height);
                this.m_DeltaPos = new Point(pt.x - this.m_rSelBounds.x, pt.y - this.m_rSelBounds.y);
                e = this.m_selList.elements();
                while (e.hasMoreElements()) {
                    detObj2 = (DetObj)e.nextElement();
                    if (!detObj2.isMoveable()) continue;
                    rBounds = vc.virtToDest(detObj2.getBounds());
                    this.m_MovingOriginalDelta.addElement(new Point(rBounds.x - this.m_rSelBounds.x, rBounds.y - this.m_rSelBounds.y));
                    this.m_MovingOriginal.addElement(rBounds);
                }
            }
        }
    }

    public void mouseDragMove(Graphics g, Point pt, VC vc) {
        IdentObj id = new IdentObj(1);
        Rectangle rBck = vc.virtToDest(this.m_Perspective.getRect(id));
        rBck = rBck.intersection(this.m_rBoundParent);
        int nNewPosX = pt.x - this.m_DeltaPos.x;
        int nNewPosY = pt.y - this.m_DeltaPos.y;
        nNewPosX = Math.max(nNewPosX, rBck.x + 1);
        nNewPosX = Math.min(nNewPosX + this.m_rSelBounds.width, rBck.x + rBck.width - 1) - this.m_rSelBounds.width;
        nNewPosY = Math.max(nNewPosY, 1);
        nNewPosY = Math.min(nNewPosY + this.m_rSelBounds.height, rBck.y + rBck.height - 1) - this.m_rSelBounds.height;
        this.m_rSelBounds.x = nNewPosX;
        this.m_rSelBounds.y = nNewPosY;
        int nCounter = 0;
        Enumeration e = this.m_selList.elements();
        while (e.hasMoreElements()) {
            DetObj detObj = (DetObj)e.nextElement();
            if (!detObj.isMoveable()) continue;
            Rectangle rBoundsVC = detObj.getBounds();
            Rectangle rBounds = vc.virtToDest(rBoundsVC);
            this.hiliteWithHandles(g, detObj, vc);
            rBounds.x = nNewPosX + ((Point)this.m_MovingOriginalDelta.elementAt((int)nCounter)).x;
            rBounds.y = nNewPosY + ((Point)this.m_MovingOriginalDelta.elementAt((int)nCounter)).y;
            Rectangle r = vc.destToVirt(rBounds);
            r.width = rBoundsVC.width;
            r.height = rBoundsVC.height;
            detObj.setBounds(r);
            this.hiliteWithHandles(g, detObj, vc);
            ++nCounter;
        }
    }

    public void mouseDragResize(Graphics g, Point pt, VC vc) {
        int nTemp;
        DetObj detObj = (DetObj)this.m_selList.elementAt(0);
        Rectangle rBoundsVC = detObj.getBounds();
        Rectangle rBounds = vc.virtToDest(rBoundsVC);
        IdentObj id = new IdentObj(1);
        Rectangle rBck = vc.virtToDest(this.m_Perspective.getRect(id));
        rBck = rBck.intersection(this.m_rBoundParent);
        this.hiliteWithHandles(g, detObj, vc);
        if (this.m_nActiveHandle == 7 || this.m_nActiveHandle == 0 || this.m_nActiveHandle == 6) {
            nTemp = pt.x - rBounds.x - this.m_DeltaPos.x;
            nTemp = Math.max(rBounds.x + nTemp, rBck.x + 1) - rBounds.x;
            nTemp = Math.min(rBounds.width - 10, nTemp);
            nTemp = vc.destToVirtWidth(nTemp);
            rBoundsVC.x += nTemp;
            rBoundsVC.width -= nTemp;
        } else if (this.m_nActiveHandle == 3 || this.m_nActiveHandle == 2 || this.m_nActiveHandle == 4) {
            nTemp = pt.x - rBounds.x - this.m_DeltaPos.x;
            nTemp = Math.min(rBounds.x + nTemp, rBck.x + rBck.width - 1) - rBounds.x;
            nTemp = Math.max(10, nTemp);
            rBoundsVC.width = nTemp = vc.destToVirtWidth(nTemp);
        }
        if (this.m_nActiveHandle == 1 || this.m_nActiveHandle == 0 || this.m_nActiveHandle == 2) {
            nTemp = pt.y - rBounds.y - this.m_DeltaPos.y;
            nTemp = Math.max(rBounds.y + nTemp, rBck.y + 1) - rBounds.y;
            nTemp = Math.min(rBounds.height - 10, nTemp);
            nTemp = vc.destToVirtHeight(nTemp);
            rBoundsVC.height -= nTemp;
        } else if (this.m_nActiveHandle == 5 || this.m_nActiveHandle == 6 || this.m_nActiveHandle == 4) {
            nTemp = pt.y - rBounds.y - this.m_DeltaPos.y;
            nTemp = Math.min(rBounds.y + nTemp, rBck.y + rBck.height - 1) - rBounds.y;
            nTemp = Math.max(10, nTemp);
            nTemp = vc.destToVirtHeight(nTemp);
            rBoundsVC.y -= nTemp - rBoundsVC.height;
            rBoundsVC.height = nTemp;
        }
        detObj.setBounds(rBoundsVC);
        this.hiliteWithHandles(g, detObj, vc);
    }

    public void mouseDragRiserResize(Graphics g, Point pt, VC vc) {
        this.hiliteResizer(g, this.firstDetObjElement(), vc);
        JGraphType gt = this.m_Perspective.getJGraphType();
        IdentObj id = this.firstElement();
        int dx = Math.abs(pt.x - this.m_ptMouseDown.x);
        int dy = Math.abs(pt.y - this.m_ptMouseDown.y);
        if (this.m_bCanSwitchDirection) {
            if (dy > dx) {
                if (this.m_nDirection == 0) {
                    this.m_nDirection = 1;
                    this.m_item = gt.getDataFormat().getDataItem(1);
                    this.m_nOriginalResizeCoord = this.m_nResizeCoord = vc.virtToDestY(this.m_Perspective.getDataCoord(id, this.m_item, false));
                    if (this.m_nScaling != 1) {
                        this.m_nOriginalResizeCoordBase = vc.virtToDestY(this.m_Perspective.getDataCoord(id, this.m_item, true)) - vc.virtToDestY(this.m_Perspective.getDataCoord(id, this.m_item, false));
                    }
                }
            } else if (this.m_nDirection == 1) {
                this.m_nDirection = 0;
                this.m_item = gt.getDataFormat().getDataItem(1);
                this.m_nOriginalResizeCoord = this.m_nResizeCoord = vc.virtToDestX(this.m_Perspective.getDataCoord(id, this.m_item, false));
                if (this.m_nScaling != 1) {
                    this.m_nOriginalResizeCoordBase = vc.virtToDestX(this.m_Perspective.getDataCoord(id, this.m_item, true)) - vc.virtToDestX(this.m_Perspective.getDataCoord(id, this.m_item, false));
                }
            }
        }
        Rectangle rInnerFrame = vc.virtToDest(this.m_Perspective.getFrameRect(true));
        rInnerFrame = rInnerFrame.intersection(this.m_rBoundParent);
        if (this.m_nDirection == 1) {
            if (pt.y < rInnerFrame.y) {
                pt.y = rInnerFrame.y;
            } else if (pt.y > rInnerFrame.y + rInnerFrame.height) {
                pt.y = rInnerFrame.y + rInnerFrame.height - 1;
            }
        } else if (pt.x < rInnerFrame.x) {
            pt.x = rInnerFrame.x;
        } else if (pt.x > rInnerFrame.x + rInnerFrame.width) {
            pt.x = rInnerFrame.x + rInnerFrame.width - 1;
        }
        Rectangle rBar = vc.virtToDest(this.firstDetObjElement().getBounds());
        int nMargin = vc.virtToDestWidth(1000);
        if (this.m_nDirection == 1) {
            this.m_nResizeCoord = pt.x < rBar.x - nMargin || pt.x > rBar.x + rBar.width + nMargin ? this.m_nOriginalResizeCoord : (this.m_nScaling == 1 ? pt.y : pt.y - this.m_nOriginalResizeCoordBase);
            this.m_nResizeValue = this.m_Perspective.getDataFromCoord(this.firstElement(), this.m_item, vc.destToVirtY(this.m_nResizeCoord));
        } else {
            this.m_nResizeCoord = pt.y < rBar.y - nMargin || pt.y > rBar.y + rBar.height + nMargin ? this.m_nOriginalResizeCoord : (this.m_nScaling == 1 ? pt.x : pt.x - this.m_nOriginalResizeCoordBase);
            this.m_nResizeValue = this.m_Perspective.getDataFromCoord(this.firstElement(), this.m_item, vc.destToVirtX(this.m_nResizeCoord));
        }
        this.hiliteResizer(g, this.firstDetObjElement(), vc);
        this.m_bDragged = true;
    }

    public void mouseDrag(Graphics g, Point pt, VC vc) {
        if (this.m_nAction == 1) {
            this.mouseDragResize(g, pt, vc);
        } else if (this.m_nAction == 2) {
            this.mouseDragMove(g, pt, vc);
        } else if (this.m_nAction == 3) {
            this.mouseDragRiserResize(g, pt, vc);
        }
    }

    public void cancelMoveDrag(Graphics g, VC vc) {
        if (this.m_nAction == 1) {
            DetObj detObj = (DetObj)this.m_selList.elementAt(0);
            this.hiliteWithHandles(g, detObj, vc);
            Rectangle r = vc.destToVirt(this.m_rOriginalPos);
            detObj.setBounds(r);
            this.hiliteWithHandles(g, detObj, vc);
        } else if (this.m_nAction == 2) {
            int nCounter = 0;
            Enumeration e = this.m_selList.elements();
            while (e.hasMoreElements()) {
                DetObj detObj = (DetObj)e.nextElement();
                if (!detObj.isMoveable()) continue;
                Rectangle rBoundsVC = detObj.getBounds();
                Rectangle rBounds = vc.virtToDest(rBoundsVC);
                this.hiliteWithHandles(g, detObj, vc);
                Rectangle r = vc.destToVirt((Rectangle)this.m_MovingOriginal.elementAt(nCounter));
                detObj.setBounds(r);
                this.hiliteWithHandles(g, detObj, vc);
                ++nCounter;
            }
        } else if (this.m_nAction == 3) {
            this.hiliteResizer(g, this.firstDetObjElement(), vc);
            this.m_bDragged = false;
        }
        this.m_nAction = 0;
    }

    public void mouseUp(Graphics g, VC vc) {
        if (this.m_nAction == 1) {
            DetObj detObj = (DetObj)this.m_selList.elementAt(0);
            Rectangle rBounds = vc.virtToDest(detObj.getBounds());
            if (!rBounds.equals(this.m_rOriginalPos)) {
                this.m_Perspective.setRect(detObj.getIdentID(), detObj.getBounds());
                if (detObj.getIdentID().getObjectID() == 12) {
                    this.m_Perspective.getEventManager().notifyPerspectiveListener((Object)this.m_Perspective, 4001, 0);
                }
            }
        } else if (this.m_nAction == 2) {
            DetObj detObj = (DetObj)this.m_selList.elementAt(0);
            Rectangle rBounds = vc.virtToDest(detObj.getBounds());
            if (!rBounds.equals(this.m_rOriginalPos)) {
                Enumeration e = this.m_selList.elements();
                while (e.hasMoreElements()) {
                    detObj = (DetObj)e.nextElement();
                    if (!detObj.isMoveable()) continue;
                    this.m_Perspective.setRect(detObj.getIdentID(), detObj.getBounds());
                    if (detObj.getIdentID().getObjectID() != 12) continue;
                    this.m_Perspective.getEventManager().notifyPerspectiveListener((Object)this.m_Perspective, 4001, 0);
                }
            }
        } else if (this.m_nAction == 3) {
            this.hiliteResizer(g, this.firstDetObjElement(), vc);
            if (this.m_bDragged) {
                this.m_Perspective.useWorkDataStorage();
                this.m_Perspective.setDataValue(this.firstElement(), this.m_item, this.m_nResizeValue);
            }
        }
        this.m_nAction = 0;
    }

    public DetObj nextDetObjElement() {
        Object aDetObj = null;
        ++this.m_nCurrentItem;
        if (this.hasMoreElements()) {
            return (DetObj)this.m_selList.elementAt(this.m_nCurrentItem);
        }
        return null;
    }

    public IdentObj nextElement() {
        IdentObj id = null;
        ++this.m_nCurrentItem;
        if (this.hasMoreElements()) {
            id = ((DetObj)this.m_selList.elementAt(this.m_nCurrentItem)).getIdentID();
            id = new IdentObj(id.getObjectID(), id.getSeriesID(), id.getGroupID(), id.getStackID(), -3);
            return id;
        }
        return null;
    }

    public void setFirstElement(IdentObj newID) {
        IdentObj id;
        if (this.hasMoreElements() && (id = ((DetObj)this.m_selList.elementAt(0)).getIdentIDRef()) != null) {
            id.copy(newID);
        }
    }

    public DetObj testMouseDown(Point pt, VC vc) {
        int nSelectionMode = this.m_Perspective.getSelectionEnable();
        if (nSelectionMode == 0) {
            return null;
        }
        Point ptVirt = vc.destToVirt(pt);
        DetObj detObj = this.m_Perspective.getDetectiv().findNodeOf(ptVirt.x, ptVirt.y, vc);
        return detObj;
    }

    public int getResizeCursor(Point destCoordsMouseMovedPt) {
        DetObj detObj;
        int nCursor = 0;
        int nSelectionMode = this.m_Perspective.getSelectionEnable();
        boolean bSelectionEnableMove = this.m_Perspective.getSelectionEnableMove();
        if (nSelectionMode != 0 && bSelectionEnableMove && this.m_selList.size() == 1 && (detObj = (DetObj)this.m_selList.elementAt(0)).isMoveable()) {
            int nIdx = 0;
            boolean bMatchFound = false;
            while (nIdx < 8 && !bMatchFound) {
                if (this.m_rHandles[nIdx].contains(destCoordsMouseMovedPt.x, destCoordsMouseMovedPt.y)) {
                    bMatchFound = true;
                    continue;
                }
                ++nIdx;
            }
            switch (nIdx) {
                default: {
                    nCursor = 0;
                    break;
                }
                case 0: {
                    nCursor = 6;
                    break;
                }
                case 1: {
                    nCursor = 8;
                    break;
                }
                case 2: {
                    nCursor = 7;
                    break;
                }
                case 3: {
                    nCursor = 11;
                    break;
                }
                case 4: {
                    nCursor = 5;
                    break;
                }
                case 5: {
                    nCursor = 9;
                    break;
                }
                case 6: {
                    nCursor = 4;
                    break;
                }
                case 7: {
                    nCursor = 10;
                }
            }
        }
        return nCursor;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    private void handleIEJavascriptFunction(String strJS) {
        int aindex = strJS.indexOf(":");
        int bindex = strJS.indexOf("(");
        int cindex = strJS.indexOf(")");
        if (aindex > bindex || bindex > cindex) {
            return;
        }
        String JSName = strJS.substring(aindex + 1, bindex);
        String JSParm = strJS.substring(bindex + 1, cindex);
        String[] args = this.getJSArguments(JSParm);
    }

    private String[] getJSArguments(String parms) {
        if (parms == null || parms.length() == 0) {
            return null;
        }
        Vector<String> myVector = new Vector<String>();
        StringTokenizer Tokenizer = new StringTokenizer(parms, ",");
        while (Tokenizer.hasMoreTokens()) {
            String what = Tokenizer.nextToken();
            myVector.addElement(what);
        }
        String[] strCand = new String[myVector.size()];
        for (int i = 0; i < myVector.size(); ++i) {
            strCand[i] = (String)myVector.elementAt(i);
        }
        return strCand;
    }
}

