/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;

public class Polyline
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int m_npoints;
    public int[] m_xpoints = new int[4];
    public int[] m_ypoints = new int[4];
    public int m_nThickness;
    public Polygon m_polygon;

    public Polyline(int[] xpoints, int[] ypoints, int npoints, int nThickness) throws AssertionException {
        int i;
        PfjAssert.pfjAssert(npoints >= 2);
        PfjAssert.pfjAssert(xpoints.length >= npoints);
        PfjAssert.pfjAssert(ypoints.length >= npoints);
        PfjAssert.pfjAssert(nThickness > 0);
        this.m_npoints = npoints;
        this.m_xpoints = new int[npoints];
        this.m_ypoints = new int[npoints];
        System.arraycopy(xpoints, 0, this.m_xpoints, 0, npoints);
        System.arraycopy(ypoints, 0, this.m_ypoints, 0, npoints);
        this.m_nThickness = nThickness;
        int nRadius = this.m_nThickness / 2;
        this.m_polygon = new Polygon();
        for (i = 0; i < this.m_npoints; ++i) {
            this.m_polygon.addPoint(this.m_xpoints[i], this.m_ypoints[i] + nRadius);
        }
        for (i = this.m_npoints - 1; i >= 0; --i) {
            this.m_polygon.addPoint(this.m_xpoints[i], this.m_ypoints[i] - nRadius);
        }
        this.m_polygon.addPoint(this.m_xpoints[0], this.m_ypoints[0] + nRadius);
    }

    public void translate(int deltaX, int deltaY) {
        this.m_polygon.translate(deltaX, deltaY);
    }

    public Rectangle getBounds() {
        return this.m_polygon.getBounds();
    }
}

