/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import oracle.dss.graph.pfj.draw.GifEncoderHashitem;
import oracle.dss.graph.pfj.draw.ImageEncoder;
import oracle.dss.graph.pfj.draw.IntHashtable;

public class GifEncoder
extends ImageEncoder {
    private boolean interlace = false;
    int width;
    int height;
    int[][] rgbPixels;
    IntHashtable colorHash;
    int Width;
    int Height;
    boolean Interlace;
    int curx;
    int cury;
    int CountDown;
    int Pass = 0;
    static final int EOF = -1;
    int rl_pixel;
    int rl_basecode;
    int rl_count;
    int rl_table_pixel;
    int rl_table_max;
    boolean just_cleared;
    int out_bits;
    int out_bits_init;
    int out_count;
    int out_bump;
    int out_bump_init;
    int out_clear;
    int out_clear_init;
    int max_ocodes;
    int code_clear;
    int code_eof;
    int obuf;
    int obits;
    byte[] oblock = new byte[256];
    int oblen;
    OutputStream imageStream;
    boolean VERBOSE = false;
    static final int BITS = 12;

    public GifEncoder(ImageProducer prod, OutputStream out) throws IOException {
        super(prod, out);
    }

    public GifEncoder(ImageProducer prod, OutputStream out, boolean interlace) throws IOException {
        super(prod, out);
        this.interlace = interlace;
    }

    public GifEncoder(Image img, OutputStream out) throws IOException {
        super(img, out);
    }

    public GifEncoder(Image img, OutputStream out, boolean interlace) throws IOException {
        super(img, out);
        this.interlace = interlace;
    }

    void BumpPixel() {
        ++this.curx;
        if (this.curx == this.Width) {
            this.curx = 0;
            if (!this.Interlace) {
                ++this.cury;
            } else {
                switch (this.Pass) {
                    case 0: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 4;
                        break;
                    }
                    case 1: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 2;
                        break;
                    }
                    case 2: {
                        this.cury += 4;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 1;
                        break;
                    }
                    case 3: {
                        this.cury += 2;
                    }
                }
            }
        }
    }

    @Override
    void encodeDone() throws IOException {
        int transparentIndex = -1;
        int transparentRgb = -1;
        this.colorHash = new IntHashtable();
        int index = 0;
        for (int row = 0; row < this.height; ++row) {
            int rowOffset = row * this.width;
            for (int col = 0; col < this.width; ++col) {
                GifEncoderHashitem item;
                boolean isTransparent;
                int rgb = this.rgbPixels[row][col];
                boolean bl = isTransparent = rgb >>> 24 < 128;
                if (isTransparent) {
                    if (transparentIndex < 0) {
                        transparentIndex = index;
                        transparentRgb = rgb;
                    } else if (rgb != transparentRgb) {
                        this.rgbPixels[row][col] = rgb = transparentRgb;
                    }
                }
                if ((item = (GifEncoderHashitem)this.colorHash.get(rgb)) == null) {
                    if (index >= 256) {
                        throw new IOException("too many colors for a GIF");
                    }
                    item = new GifEncoderHashitem(rgb, 1, index, isTransparent);
                    ++index;
                    this.colorHash.put(rgb, (Object)item);
                    continue;
                }
                ++item.count;
            }
        }
        int logColors = index <= 2 ? 1 : (index <= 4 ? 2 : (index <= 16 ? 4 : 8));
        int mapSize = 1 << logColors;
        byte[] reds = new byte[mapSize];
        byte[] grns = new byte[mapSize];
        byte[] blus = new byte[mapSize];
        Enumeration e = this.colorHash.elements();
        while (e.hasMoreElements()) {
            GifEncoderHashitem item = (GifEncoderHashitem)e.nextElement();
            reds[item.index] = (byte)(item.rgb >> 16 & 0xFF);
            grns[item.index] = (byte)(item.rgb >> 8 & 0xFF);
            blus[item.index] = (byte)(item.rgb & 0xFF);
        }
        this.GIFEncode(this.out, this.width, this.height, this.interlace, (byte)0, transparentIndex, logColors, reds, grns, blus);
    }

    @Override
    void encodePixels(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        for (int row = 0; row < h; ++row) {
            System.arraycopy(rgbPixels, row * scansize + off, this.rgbPixels[y + row], x, w);
        }
    }

    @Override
    void encodeStart(int width, int height) throws IOException {
        this.width = width;
        this.height = height;
        this.rgbPixels = new int[height][width];
    }

    byte GetPixel(int x, int y) throws IOException {
        GifEncoderHashitem item = (GifEncoderHashitem)this.colorHash.get(this.rgbPixels[y][x]);
        if (item == null) {
            throw new IOException("color not found");
        }
        return (byte)item.index;
    }

    void GIFEncode(OutputStream outs, int Width, int Height, boolean Interlace, byte Background2, int Transparent, int BitsPerPixel, byte[] Red, byte[] Green, byte[] Blue) throws IOException {
        this.Width = Width;
        this.Height = Height;
        this.Interlace = Interlace;
        int ColorMapSize = 1 << BitsPerPixel;
        int TopOfs = 0;
        int LeftOfs = 0;
        this.CountDown = Width * Height;
        this.Pass = 0;
        int InitCodeSize = BitsPerPixel <= 1 ? 2 : BitsPerPixel;
        this.curx = 0;
        this.cury = 0;
        this.Putbyte((byte)71, outs);
        this.Putbyte((byte)73, outs);
        this.Putbyte((byte)70, outs);
        this.Putbyte((byte)56, outs);
        this.Putbyte((byte)57, outs);
        this.Putbyte((byte)97, outs);
        this.Putword(Width, outs);
        this.Putword(Height, outs);
        byte B = -128;
        B = (byte)(B | 0x70);
        B = (byte)(B | (byte)(BitsPerPixel - 1));
        this.Putbyte(B, outs);
        this.Putbyte(Background2, outs);
        this.Putbyte((byte)0, outs);
        for (int i = 0; i < ColorMapSize; ++i) {
            this.Putbyte(Red[i], outs);
            this.Putbyte(Green[i], outs);
            this.Putbyte(Blue[i], outs);
        }
        if (Transparent != -1) {
            this.Putbyte((byte)33, outs);
            this.Putbyte((byte)-7, outs);
            this.Putbyte((byte)4, outs);
            this.Putbyte((byte)1, outs);
            this.Putbyte((byte)0, outs);
            this.Putbyte((byte)0, outs);
            this.Putbyte((byte)Transparent, outs);
            this.Putbyte((byte)0, outs);
        }
        this.Putbyte((byte)44, outs);
        this.Putword(LeftOfs, outs);
        this.Putword(TopOfs, outs);
        this.Putword(Width, outs);
        this.Putword(Height, outs);
        if (Interlace) {
            this.Putbyte((byte)64, outs);
        } else {
            this.Putbyte((byte)0, outs);
        }
        this.Putbyte((byte)InitCodeSize, outs);
        this.compress(InitCodeSize + 1, outs);
        this.Putbyte((byte)0, outs);
        this.Putbyte((byte)59, outs);
    }

    int GIFNextPixel() throws IOException {
        if (this.CountDown == 0) {
            return -1;
        }
        --this.CountDown;
        byte r = this.GetPixel(this.curx, this.cury);
        this.BumpPixel();
        return r & 0xFF;
    }

    void Putbyte(byte b, OutputStream outs) throws IOException {
        outs.write(b);
    }

    void Putword(int w, OutputStream outs) throws IOException {
        this.Putbyte((byte)(w & 0xFF), outs);
        this.Putbyte((byte)(w >> 8 & 0xFF), outs);
    }

    void writeString(OutputStream out, String str) throws IOException {
        byte[] buf = str.getBytes();
        out.write(buf);
    }

    void write_block() {
        try {
            this.Putbyte((byte)(this.oblen & 0xFF), this.imageStream);
            this.imageStream.write(this.oblock, 0, this.oblen);
            this.oblen = 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void block_out(byte c) {
        this.oblock[this.oblen++] = c;
        if (this.oblen >= 255) {
            this.write_block();
        }
    }

    void block_flush() {
        if (this.oblen > 0) {
            this.write_block();
        }
    }

    void output(int val) {
        this.obuf |= val << this.obits;
        this.obits += this.out_bits;
        while (this.obits >= 8) {
            this.block_out((byte)(this.obuf & 0xFF));
            this.obuf >>= 8;
            this.obits -= 8;
        }
    }

    void output_flush() {
        if (this.obits > 0) {
            this.block_out((byte)this.obuf);
        }
        this.block_flush();
    }

    void did_clear() {
        this.out_bits = this.out_bits_init;
        this.out_bump = this.out_bump_init;
        this.out_clear = this.out_clear_init;
        this.out_count = 0;
        this.rl_table_max = 0;
        this.just_cleared = true;
    }

    void output_plain(int c) {
        this.just_cleared = false;
        this.output(c);
        ++this.out_count;
        if (this.out_count >= this.out_bump) {
            ++this.out_bits;
            this.out_bump += 1 << this.out_bits - 1;
        }
        if (this.out_count >= this.out_clear) {
            this.output(this.code_clear);
            this.did_clear();
        }
    }

    int isqrt(int x) {
        if (x < 2) {
            return x;
        }
        int v = x;
        int r = 1;
        while (v != 0) {
            v >>= 2;
            r <<= 1;
        }
        while ((v = (x / r + r) / 2) != r && v != r + 1) {
            r = v;
        }
        return r;
    }

    int compute_triangle_count(int count, int nrepcodes) {
        int cost = 0;
        int perrep = nrepcodes * (nrepcodes + 1) / 2;
        while (count >= perrep) {
            cost += nrepcodes;
            count -= perrep;
        }
        if (count > 0) {
            int n = this.isqrt(count);
            while (n * (n + 1) >= 2 * count) {
                --n;
            }
            while (n * (n + 1) < 2 * count) {
                ++n;
            }
            cost += n;
        }
        return cost;
    }

    void max_out_clear() {
        this.out_clear = this.max_ocodes;
    }

    void reset_out_clear() {
        this.out_clear = this.out_clear_init;
        if (this.out_count >= this.out_clear) {
            this.output(this.code_clear);
            this.did_clear();
        }
    }

    void rl_flush_fromclear(int count) {
        this.max_out_clear();
        this.rl_table_pixel = this.rl_pixel;
        int n = 1;
        while (count > 0) {
            if (n == 1) {
                this.rl_table_max = 1;
                this.output_plain(this.rl_pixel);
                --count;
            } else if (count >= n) {
                this.rl_table_max = n;
                this.output_plain(this.rl_basecode + n - 2);
                count -= n;
            } else if (count == 1) {
                ++this.rl_table_max;
                this.output_plain(this.rl_pixel);
                count = 0;
            } else {
                ++this.rl_table_max;
                this.output_plain(this.rl_basecode + count - 2);
                count = 0;
            }
            if (this.out_count == 0) {
                n = 1;
                continue;
            }
            ++n;
        }
        this.reset_out_clear();
    }

    void rl_flush_clearorrep(int count) {
        int withclr = 1 + this.compute_triangle_count(count, this.max_ocodes);
        if (withclr < count) {
            this.output(this.code_clear);
            this.did_clear();
            this.rl_flush_fromclear(count);
        } else {
            while (count > 0) {
                this.output_plain(this.rl_pixel);
                --count;
            }
        }
    }

    void rl_flush_withtable(int count) {
        int repleft;
        int repmax = count / this.rl_table_max;
        int leftover = count % this.rl_table_max;
        int n = repleft = leftover != 0 ? 1 : 0;
        if (this.out_count + repmax + repleft > this.max_ocodes) {
            repmax = this.max_ocodes - this.out_count;
            leftover = count - repmax * this.rl_table_max;
            repleft = 1 + this.compute_triangle_count(leftover, this.max_ocodes);
        }
        if (1 + this.compute_triangle_count(count, this.max_ocodes) < repmax + repleft) {
            this.output(this.code_clear);
            this.did_clear();
            this.rl_flush_fromclear(count);
            return;
        }
        this.max_out_clear();
        while (repmax > 0) {
            this.output_plain(this.rl_basecode + this.rl_table_max - 2);
            --repmax;
        }
        if (leftover != 0) {
            if (this.just_cleared) {
                this.rl_flush_fromclear(leftover);
            } else if (leftover == 1) {
                this.output_plain(this.rl_pixel);
            } else {
                this.output_plain(this.rl_basecode + leftover - 2);
            }
        }
        this.reset_out_clear();
    }

    void rl_flush() {
        if (this.VERBOSE) {
            System.err.println("rl_flush [ " + this.rl_count + " " + this.rl_pixel + "\n");
        }
        if (this.rl_count == 1) {
            this.output_plain(this.rl_pixel);
            this.rl_count = 0;
            if (this.VERBOSE) {
                System.err.println("rl_flush ]\n");
            }
            return;
        }
        if (this.just_cleared) {
            this.rl_flush_fromclear(this.rl_count);
        } else if (this.rl_table_max < 2 || this.rl_table_pixel != this.rl_pixel) {
            this.rl_flush_clearorrep(this.rl_count);
        } else {
            this.rl_flush_withtable(this.rl_count);
        }
        if (this.VERBOSE) {
            System.err.println("rl_flush ]\n");
        }
        this.rl_count = 0;
    }

    void compress(int init_bits, OutputStream outs) throws IOException {
        this.obuf = 0;
        this.obits = 0;
        this.oblen = 0;
        this.imageStream = outs;
        this.code_clear = 1 << init_bits - 1;
        this.code_eof = this.code_clear + 1;
        this.rl_basecode = this.code_eof + 1;
        this.out_bump_init = (1 << init_bits - 1) - 1;
        this.out_clear_init = init_bits <= 3 ? 9 : this.out_bump_init - 1;
        this.out_bits_init = init_bits;
        this.max_ocodes = 4096 - ((1 << this.out_bits_init - 1) + 3);
        this.did_clear();
        this.output(this.code_clear);
        this.rl_count = 0;
        while (true) {
            int c = this.GIFNextPixel();
            if (this.rl_count > 0 && c != this.rl_pixel) {
                this.rl_flush();
            }
            if (c == -1) break;
            if (this.rl_pixel == c) {
                ++this.rl_count;
                continue;
            }
            this.rl_pixel = c;
            this.rl_count = 1;
        }
        this.output(this.code_eof);
        this.output_flush();
    }
}

