/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.GraphSVGWriter;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.util.LocaleUtils;

public class DetLabel
extends DetObj {
    private static final long serialVersionUID = 1L;
    private Rectangle m_rBounds;
    private Rectangle m_rInnerBoundsDC;
    private Dimension m_dim;
    private TextStyleObj m_TextStyle;
    private String m_szText;
    private String m_fullText = null;

    public DetLabel(Detectiv m_Detectiv, IdentObj id, String szText, Rectangle rBounds, TextStyleObj textStyle, BlackBoxIF blackBox) {
        this(m_Detectiv, id, szText, rBounds, textStyle, blackBox, false, true);
    }

    public DetLabel(Detectiv m_Detectiv, IdentObj id, String szText, Rectangle rBounds, TextStyleObj textStyle, BlackBoxIF blackBox, boolean bMoveable) {
        this(m_Detectiv, id, szText, rBounds, textStyle, blackBox, bMoveable, true);
    }

    public DetLabel(Detectiv m_Detectiv, IdentObj id, String szText, String fullText, Rectangle rBounds, TextStyleObj textStyle, BlackBoxIF blackBox, boolean bMoveable) {
        this(m_Detectiv, id, szText, rBounds, textStyle, blackBox, bMoveable, true);
        this.m_fullText = fullText;
    }

    public DetLabel(Detectiv m_Detectiv, IdentObj id, String szText, String fullText, Rectangle rBounds, TextStyleObj textStyle, BlackBoxIF blackBox, boolean bMoveable, Rectangle rClip) {
        this(m_Detectiv, id, szText, rBounds, textStyle, blackBox, bMoveable, rClip);
        this.m_fullText = fullText;
    }

    public DetLabel(Detectiv m_Detectiv, IdentObj id, String szText, Rectangle rBounds, TextStyleObj textStyle, BlackBoxIF blackBox, boolean bMoveable, Rectangle rClip) {
        super(m_Detectiv, id, blackBox, bMoveable, true, true);
        this.m_rBounds = new Rectangle(rBounds.x, rBounds.y, rBounds.width, rBounds.height);
        this.m_TextStyle = new TextStyleObj(textStyle);
        this.m_szText = szText;
    }

    public DetLabel(Detectiv m_Detectiv, IdentObj id, String szText, Rectangle rBounds, TextStyleObj textStyle, BlackBoxIF blackBox, boolean bMoveable, boolean bDetectable) {
        super(m_Detectiv, id, blackBox, bMoveable, bDetectable, true);
        this.m_rBounds = new Rectangle(rBounds.x, rBounds.y, rBounds.width, rBounds.height);
        this.m_TextStyle = new TextStyleObj(textStyle);
        this.m_szText = szText;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetLabel)) {
            return false;
        }
        DetLabel detLabel = (DetLabel)obj;
        return this.m_id.equals(detLabel.m_id);
    }

    @Override
    public Rectangle getBounds() {
        return this.m_rBounds;
    }

    public String getLabelString() {
        return this.m_szText;
    }

    public String getFullText() {
        return this.m_fullText;
    }

    @Override
    public void hilite(Graphics g, VC vc) {
        if (this.m_rInnerBoundsDC != null) {
            g.setXORMode(Color.yellow);
            int rotationAngle = this.m_TextStyle.getRotationAngle();
            if (rotationAngle == 0 || rotationAngle == 270 || rotationAngle == 90) {
                g.drawRect(this.m_rInnerBoundsDC.x, this.m_rInnerBoundsDC.y, this.m_rInnerBoundsDC.width, this.m_rInnerBoundsDC.height);
            } else {
                Graphics2D g2d = (Graphics2D)g;
                g2d.draw(this.getTransformedShape(rotationAngle, this.m_rInnerBoundsDC));
            }
            g.setPaintMode();
        }
    }

    @Override
    public boolean isPointInObj(int x, int y, VC vc) {
        if (this.m_rInnerBoundsDC != null) {
            int rotationAngle = this.m_TextStyle.getRotationAngle();
            if (rotationAngle != 0 || rotationAngle != 270 || rotationAngle != 90) {
                Shape shape = this.getTransformedShape(rotationAngle, this.m_rInnerBoundsDC);
                return this.m_bDetectable && shape.contains(vc.virtToDestX(x), vc.virtToDestY(y));
            }
            return this.m_bDetectable && this.m_rInnerBoundsDC.contains(vc.virtToDestX(x), vc.virtToDestY(y));
        }
        return false;
    }

    @Override
    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    @Override
    public void paintIt(Graphics g, VC vc) {
        if (this.m_szText.length() > 0) {
            Rectangle rDest = this.calcBounds(g, vc);
            this.m_blackBox.paint(g, this.m_szText, this.m_rInnerBoundsDC, rDest, this.m_TextStyle, vc);
        }
    }

    @Override
    public void renderItToSVG(Map context) throws IOException, Exception {
        if (this.m_szText.length() > 0) {
            boolean bStartG;
            boolean bOnMouseOverOutPresent;
            boolean bOnClickPresent;
            GraphSVGWriter writer = (GraphSVGWriter)context.get("svgWriter");
            Graphics g = (Graphics)context.get("svgGraphics");
            VC vc = (VC)context.get("svgVC");
            int mode = (Integer)context.get("svgMode");
            boolean bTooltips = (mode & 2) != 0;
            String[] tooltipsArray = null;
            if (bTooltips) {
                tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
            }
            boolean bShapeAttributes = (mode & 0x10) != 0;
            String clickEventJS = null;
            boolean bl = bOnClickPresent = bShapeAttributes && writer.isOnClickPresent();
            if (bShapeAttributes && !bOnClickPresent) {
                clickEventJS = writer.getClickEventJS();
            }
            boolean bl2 = bOnMouseOverOutPresent = bShapeAttributes && writer.isOnMouseOverOutPresent();
            if (bOnMouseOverOutPresent) {
                bTooltips = false;
            }
            String saAlt = null;
            String saTitle = null;
            String saHRef = null;
            String saTarget = null;
            if (bShapeAttributes) {
                saAlt = writer.getShapeAttributesAlt();
                saTitle = writer.getShapeAttributesTitle();
                if (!bOnClickPresent) {
                    saHRef = writer.getShapeAttributesHRef();
                }
                saTarget = writer.getShapeAttributesTarget();
            }
            boolean bDrilling = (mode & 4) != 0;
            bDrilling = bDrilling && !bOnClickPresent && clickEventJS == null;
            String drillJS = null;
            String link = null;
            boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
            if (bLink && ((link = writer.getLink(this)) == null || link.length() < 1)) {
                bLink = false;
            }
            if (bDrilling && ((drillJS = writer.getDrillJS(this)) == null || drillJS.length() < 1)) {
                bDrilling = false;
            }
            if (bTooltips) {
                if (saAlt != null) {
                    tooltipsArray = new String[]{saAlt};
                } else if (saTitle != null) {
                    tooltipsArray = new String[]{saTitle};
                }
            }
            if (bDrilling && bTooltips && tooltipsArray == null) {
                tooltipsArray = new String[]{writer.getDrillTooltip(this)};
            }
            bTooltips = bTooltips && tooltipsArray != null && tooltipsArray.length > 0;
            Rectangle rDest = this.calcBounds(g, vc);
            boolean bStartA = bDrilling || bOnClickPresent || clickEventJS != null || saHRef != null || bLink;
            boolean bAnchorGroup = false;
            if (bStartA) {
                writer.startElement("a");
                String href = "";
                if (clickEventJS == null && !bDrilling && saHRef != null) {
                    href = saHRef;
                } else if (clickEventJS == null && !bDrilling && bLink) {
                    href = link;
                }
                writer.writeAttribute("xlink:href", href);
                if (saTarget != null) {
                    writer.writeAttribute("target", saTarget);
                }
                String strOnclick = null;
                if (clickEventJS != null) {
                    strOnclick = clickEventJS;
                } else if (bDrilling) {
                    strOnclick = drillJS;
                }
                if (strOnclick != null) {
                    bAnchorGroup = true;
                    writer.startElement("g");
                    writer.writeAttribute("onclick", strOnclick);
                }
            }
            boolean bl3 = bStartG = bTooltips || bDrilling || bShapeAttributes;
            if (bStartG) {
                writer.startElement("g");
                if (bShapeAttributes) {
                    writer.writeShapeAttributes();
                }
            }
            writer.writeElement(this.m_id, this.m_blackBox, g, this.m_szText, rDest, this.m_rInnerBoundsDC, this.m_TextStyle, vc);
            if (bStartG) {
                writer.startRectElement(rDest);
                writer.writeAttribute("fill", "none");
                writer.writeAttribute("pointer-events", "visible");
                String onMouseOverJS = null;
                String onMouseOutJS = null;
                int rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior);
                if (rbMode != 0 && this.m_id.isSeriesRelated()) {
                    String shfOver = new String("bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');");
                    String shfOut = new String("bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');");
                    onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                    onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
                }
                if (bTooltips) {
                    if (onMouseOverJS != null || onMouseOutJS != null) {
                        boolean bTooltipWritten = writer.writeTooltip(tooltipsArray, onMouseOverJS, onMouseOutJS);
                    } else {
                        boolean bl4 = writer.writeTooltip(tooltipsArray);
                    }
                } else {
                    if (onMouseOverJS != null) {
                        writer.writeAttribute("onmouseover", onMouseOverJS);
                    }
                    if (onMouseOutJS != null) {
                        writer.writeAttribute("onmouseout", onMouseOutJS);
                    }
                    if (saTitle != null) {
                        writer.writeTitleElement(saTitle);
                    }
                }
                writer.endElement();
            }
            if (bStartG) {
                writer.endElement();
            }
            if (bStartA) {
                if (bAnchorGroup) {
                    writer.endElement();
                }
                writer.endElement();
            }
        }
    }

    @Override
    public void renderItToXML(Map context) throws IOException, Exception {
        if (this.m_szText.length() > 0) {
            boolean bTooltips;
            String drillJS;
            boolean bDrilling;
            GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
            Graphics g = (Graphics)context.get("xmlGraphics");
            VC vc = (VC)context.get("xmlVC");
            String[] tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
            String link = null;
            boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
            if (bLink && ((link = this.m_Detectiv.getPerspective().getLink(this)) == null || link.length() < 1)) {
                bLink = false;
            }
            boolean bl = bDrilling = (drillJS = writer.getDrillJS(this)) != null && drillJS.length() > 0;
            if (bDrilling && tooltipsArray == null) {
                tooltipsArray = new String[]{writer.getDrillTooltip(this)};
            }
            boolean bl2 = bTooltips = tooltipsArray != null && tooltipsArray.length > 0;
            if (!bTooltips && tooltipsArray == null && this.m_fullText != null && this.m_fullText != this.m_szText && !this.m_fullText.equals(this.m_szText)) {
                tooltipsArray = new String[]{this.m_fullText};
                bTooltips = true;
            }
            Rectangle rDest = this.calcBounds(g, vc);
            writer.writeElement(this.m_id, this.m_blackBox, g, this.m_szText, rDest, this.m_rInnerBoundsDC, this.m_TextStyle, vc, bDrilling ? drillJS : null, bLink ? link : null, (String[])(bTooltips ? tooltipsArray : null), this.m_fullText != null ? this.m_fullText : this.m_szText);
        }
    }

    protected Rectangle calcBounds(Graphics g, VC vc) {
        Rectangle rDest = null;
        if (this.m_szText.length() > 0) {
            rDest = vc.virtToDest(this.m_rBounds);
            this.m_dim = this.m_TextStyle.preDraw(g, this.m_szText, rDest, vc, null, this.m_Detectiv.getPerspective().getFontMetricsResolver());
            this.m_rInnerBoundsDC = new Rectangle();
            Perspective pfj = this.m_Detectiv.getPerspective();
            int horzAlign = this.m_TextStyle.getHorizAlign();
            if (horzAlign == 10) {
                horzAlign = LocaleUtils.getReadingDirectionForLocale((Locale)pfj.getLocale());
                if (horzAlign == 1) {
                    horzAlign = 2;
                } else if (horzAlign == 2) {
                    horzAlign = 4;
                }
            }
            if (this.m_TextStyle.getRotationAngle() == 0) {
                if (this.m_dim.width <= rDest.width && this.m_dim.height <= rDest.height) {
                    this.m_rInnerBoundsDC.width = this.m_dim.width;
                    this.m_rInnerBoundsDC.height = this.m_dim.height;
                    switch (horzAlign) {
                        case 0: {
                            this.m_rInnerBoundsDC.x = rDest.x + (rDest.width - this.m_dim.width) / 2;
                            break;
                        }
                        case 4: {
                            this.m_rInnerBoundsDC.x = rDest.x + (rDest.width - this.m_dim.width);
                            break;
                        }
                        case 2: {
                            this.m_rInnerBoundsDC.x = rDest.x;
                        }
                    }
                    switch (this.m_TextStyle.getVertAlign()) {
                        case 0: {
                            this.m_rInnerBoundsDC.y = rDest.y + (rDest.height - this.m_dim.height) / 2;
                            break;
                        }
                        case 1: {
                            this.m_rInnerBoundsDC.y = rDest.y;
                            break;
                        }
                        case 3: {
                            this.m_rInnerBoundsDC.y = rDest.y + (rDest.height - this.m_dim.height);
                        }
                    }
                } else {
                    this.m_rInnerBoundsDC = rDest;
                }
            } else if (this.m_TextStyle.getRotationAngle() == 270) {
                if (this.m_dim.width <= rDest.height && this.m_dim.height <= rDest.width) {
                    this.m_rInnerBoundsDC.width = this.m_dim.height;
                    this.m_rInnerBoundsDC.height = this.m_dim.width;
                    switch (horzAlign) {
                        case 0: {
                            this.m_rInnerBoundsDC.y = rDest.y + (rDest.height - this.m_dim.width) / 2;
                            break;
                        }
                        case 4: {
                            this.m_rInnerBoundsDC.y = rDest.y + (rDest.height - this.m_dim.width);
                            break;
                        }
                        case 2: {
                            this.m_rInnerBoundsDC.y = rDest.y;
                        }
                    }
                    switch (this.m_TextStyle.getVertAlign()) {
                        case 0: {
                            this.m_rInnerBoundsDC.x = rDest.x + (rDest.width - this.m_dim.height) / 2;
                            break;
                        }
                        case 1: {
                            this.m_rInnerBoundsDC.x = rDest.x + (rDest.width - this.m_dim.height);
                            break;
                        }
                        case 3: {
                            this.m_rInnerBoundsDC.x = rDest.x;
                        }
                    }
                } else {
                    this.m_rInnerBoundsDC = rDest;
                }
            } else if (this.m_TextStyle.getRotationAngle() == 90) {
                if (this.m_dim.width <= rDest.height && this.m_dim.height <= rDest.width) {
                    this.m_rInnerBoundsDC.width = this.m_dim.height;
                    this.m_rInnerBoundsDC.height = this.m_dim.width;
                    switch (horzAlign) {
                        case 0: {
                            this.m_rInnerBoundsDC.y = rDest.y + (rDest.height - this.m_dim.width) / 2;
                            break;
                        }
                        case 2: {
                            this.m_rInnerBoundsDC.y = rDest.y + (rDest.height - this.m_dim.width);
                            break;
                        }
                        case 4: {
                            this.m_rInnerBoundsDC.y = rDest.y;
                        }
                    }
                    switch (this.m_TextStyle.getVertAlign()) {
                        case 0: {
                            this.m_rInnerBoundsDC.x = rDest.x + (rDest.width - this.m_dim.height) / 2;
                            break;
                        }
                        case 1: {
                            this.m_rInnerBoundsDC.x = rDest.x;
                            break;
                        }
                        case 3: {
                            this.m_rInnerBoundsDC.x = rDest.x + (rDest.width - this.m_dim.height);
                        }
                    }
                } else {
                    this.m_rInnerBoundsDC = rDest;
                }
            } else if (this.m_dim.width <= rDest.height && this.m_dim.height <= rDest.width) {
                this.m_rInnerBoundsDC.width = this.m_dim.width;
                this.m_rInnerBoundsDC.height = this.m_dim.height;
                switch (horzAlign) {
                    case 0: {
                        this.m_rInnerBoundsDC.x = rDest.x + (rDest.width - this.m_dim.width) / 2;
                        break;
                    }
                    case 4: {
                        this.m_rInnerBoundsDC.x = rDest.x + (rDest.width - this.m_dim.width);
                        break;
                    }
                    case 2: {
                        this.m_rInnerBoundsDC.x = rDest.x;
                    }
                }
                switch (this.m_TextStyle.getVertAlign()) {
                    case 0: {
                        this.m_rInnerBoundsDC.y = rDest.y + (rDest.height - this.m_dim.height) / 2;
                        break;
                    }
                    case 1: {
                        this.m_rInnerBoundsDC.y = rDest.y;
                        break;
                    }
                    case 3: {
                        this.m_rInnerBoundsDC.y = rDest.y + (rDest.height - this.m_dim.height);
                    }
                }
            } else {
                this.m_rInnerBoundsDC = rDest;
            }
        }
        return rDest;
    }

    @Override
    public void setBounds(Rectangle rBounds) {
        this.m_rBounds = rBounds;
    }

    @Override
    public Polygon getShape(VC vc) {
        return this.rectToPoly(this.m_rBounds);
    }

    private Shape getTransformedShape(double rotationAngle, Rectangle rect) {
        double actualRrotationAngle = 360.0 - rotationAngle;
        AffineTransform transform = new AffineTransform();
        transform.rotate(Math.toRadians(actualRrotationAngle), rect.x + rect.width / 2, rect.y + rect.height / 2);
        Shape shape = transform.createTransformedShape(rect);
        return shape;
    }
}

