/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.util.ArrayList;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.DataCallback;
import oracle.dss.graph.DataSelection;
import oracle.dss.graph.GraphSelectionSet;
import oracle.dss.graph.KeyMap;
import oracle.dss.util.DataAccess;

public class SelectionUtils {
    private static final String SERIES_SEP = "~;";
    private static final String SERIES_GROUP_SEP = "~:";
    private static final String GROUP_SEP = ";";

    public static GraphSelectionSet parseSelectionState(CommonGraph graph, String selInfo) {
        int groupEdgeSliceCount;
        DataCallback dataCallback = graph.getPFJ().getDataGridCallback();
        GraphSelectionSet dataSet = new GraphSelectionSet();
        int seriesEdge = graph.isDataRowShownAsASeries() ? 1 : 0;
        int groupEdge = graph.isDataRowShownAsASeries() ? 0 : 1;
        int seriesCount = graph.getPFJ().getNumTotalSeries();
        int n = groupEdgeSliceCount = groupEdge == 0 ? dataCallback.getColumns() : dataCallback.getRows();
        if (selInfo == null) {
            return dataSet;
        }
        String[] seriesArray = selInfo.indexOf("$afr$") > -1 ? selInfo.split("\\$afr\\$") : selInfo.split(SERIES_SEP);
        if (seriesArray == null) {
            return null;
        }
        for (int i = 0; i < seriesArray.length; ++i) {
            String seriesId;
            KeyMap seriesKey;
            String seriesGroups = seriesArray[i];
            String[] tempArray = seriesGroups.split(SERIES_GROUP_SEP);
            if (tempArray == null) {
                return null;
            }
            if (tempArray == null || tempArray.length <= 0 || (seriesKey = SelectionUtils.getSeriesKey(graph, dataCallback, seriesEdge, seriesCount, seriesId = tempArray[0])) == null) continue;
            for (int j = 1; j < tempArray.length; ++j) {
                ArrayList<KeyMap> groupKeySet = SelectionUtils.getGroupKeySet(graph, dataCallback, groupEdge, groupEdgeSliceCount, tempArray[j]);
                if (groupKeySet.size() <= 0) continue;
                dataSet.add(new DataSelection(seriesKey, groupKeySet));
            }
        }
        return dataSet;
    }

    public static KeyMap getSeriesKey(CommonGraph graph, DataCallback dataCallback, int seriesEdge, int seriesCount, String seriesId) {
        int seriesIndex = -1;
        for (int s = 0; s < seriesCount; ++s) {
            if (!dataCallback.getSeriesSliceId(s).equals(seriesId)) continue;
            seriesIndex = s;
            break;
        }
        if (seriesIndex == -1) {
            int graphType = graph.getGraphType();
            switch (graphType) {
                case 71: 
                case 82: 
                case 83: 
                case 84: 
                case 88: {
                    seriesIndex = 0;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return SelectionUtils.getKeyMap(graph, seriesEdge, seriesIndex);
    }

    public static ArrayList<KeyMap> getGroupKeySet(CommonGraph graph, DataCallback dataCallback, int groupEdge, int groupEdgeSliceCount, String groupIdList) {
        ArrayList<KeyMap> groupKeySet = new ArrayList<KeyMap>();
        String[] groupArray = groupIdList.split(GROUP_SEP);
        block0: for (int k = 0; k < groupArray.length; ++k) {
            String groupId = groupArray[k];
            for (int g = 0; g < groupEdgeSliceCount; ++g) {
                if (!dataCallback.getSliceId(groupEdge, g).equals(groupId)) continue;
                groupKeySet.add(SelectionUtils.getKeyMap(graph, groupEdge, g));
                continue block0;
            }
        }
        return groupKeySet;
    }

    public static KeyMap getKeyMap(CommonGraph graph, int edge, int slice) {
        DataAccess dataAccess = graph.getDataAccess();
        KeyMap graphKey = new KeyMap();
        try {
            int layers = dataAccess.getLayerCount(edge);
            for (int i = 0; i < layers; ++i) {
                String key = dataAccess.getLayerMetadata(edge, i, "layerName").toString();
                Object value = dataAccess.getMemberMetadata(edge, i, slice, "valueRaw");
                if (value == null) {
                    value = dataAccess.getMemberMetadata(edge, i, slice, "value");
                }
                if (value != null) {
                    graphKey.put(key, value.toString());
                    continue;
                }
                graphKey.put(key, null);
            }
        }
        catch (Exception e) {
            return null;
        }
        return graphKey;
    }
}

