/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Rectangle;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphFootnote;
import oracle.dss.graph.GraphSubtitle;
import oracle.dss.graph.GraphTitle;
import oracle.dss.graph.ThickGraph;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.Perspective;
import oracle.javatools.annotations.Concealed;

@Concealed
public class LegendLayout {
    private boolean m_bThreeDSurfaceGraph = false;
    private boolean m_bStandardRectDefault = true;
    private boolean m_bThreeDSurfaceRectDefault = true;
    protected int m_automaticPosition;
    private Perspective m_pfj;
    private CommonGraph m_commonGraph;

    public LegendLayout(Perspective pfj) {
        this.m_commonGraph = pfj.getCommonGraph();
        this.m_pfj = pfj;
    }

    @Concealed
    public void setRectDefault(boolean bDefault) {
        if (this.m_bThreeDSurfaceGraph) {
            this.setThreeDSurfaceRectDefault(bDefault);
        } else {
            this.setStandardRectDefault(bDefault);
        }
    }

    public Rectangle getDefaultPFJRect(int position, boolean bAlongGraphEdge) {
        switch (position) {
            case 2: {
                if (bAlongGraphEdge) {
                    return new Rectangle(10465, -16000, 5535, 32000);
                }
                return new Rectangle(10141, -13239, 5535, 25051);
            }
            case 1: {
                if (bAlongGraphEdge) {
                    return new Rectangle(-16000, -16000, 32000, 2063);
                }
                return new Rectangle(-12540, -13966, 25072, 2063);
            }
            case 3: {
                if (bAlongGraphEdge) {
                    return new Rectangle(-16000, -16000, 5535, 32000);
                }
                return new Rectangle(-15405, -13255, 5535, 25051);
            }
            case 0: {
                if (bAlongGraphEdge) {
                    return new Rectangle(-16000, 13937, 32000, 2063);
                }
                return new Rectangle(-12432, 10394, 25072, 2063);
            }
        }
        this.m_commonGraph.getErrorHandler().log("invalid position", this.getClass().getName(), "getDefaultRectForPosition(int position)");
        return null;
    }

    public void setAutomaticPosition(int position, boolean reset) {
        switch (position) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.m_pfj.putToLookNoCalc(this.m_pfj.getLegendArea(), Attr.LegendAreaRect, this.getDefaultPFJRect(position, this.m_commonGraph.getLegendArea().isAlongGraphEdge()), !reset);
                break;
            }
            default: {
                this.m_commonGraph.getErrorHandler().log("invalid position", this.getClass().getName(), "void setAutomaticPosition(int position)");
                return;
            }
        }
        this.m_automaticPosition = position;
        if (!this.m_commonGraph.isFrameSizeAutomatic()) {
            this.m_commonGraph.setFrameSizeAutomatic(true);
        }
        this.setFrameSize(this.m_commonGraph.getGraphType());
        if (this.m_commonGraph.getLegendArea().isAlongGraphEdge()) {
            this.adjustTitlesForLegendAlongEdge(this.getAutomaticPosition(), this.m_commonGraph.getLegendArea().isAlongGraphEdge());
        }
    }

    @Concealed
    public int getAutomaticPosition() {
        return this.m_automaticPosition;
    }

    public int calcAutomaticPosition() {
        if (this._isThreeDSurfaceGraph(this.m_commonGraph.getGraphType())) {
            return 1;
        }
        int position = this._calcAutomaticPosition();
        if (position == 2 && this.m_pfj.isBIDILocale()) {
            return 3;
        }
        return position;
    }

    private int _calcAutomaticPosition() {
        int graphType;
        Dimension imageSize = null;
        ThickGraph view = (ThickGraph)this.m_commonGraph.getThickDataview();
        imageSize = view != null && view.isShowing() ? view.getThickPFJ().getSize() : this.m_commonGraph.getImageSize();
        double availableWidth = imageSize.width;
        double availableHeight = imageSize.height;
        if (this.m_commonGraph.getTitle().isVisible()) {
            Rectangle titleRect = null;
            titleRect = this.m_pfj.getRect(this.m_pfj.getTitle());
            availableHeight -= (double)this.m_pfj.getVC().virtToDestHeight(titleRect.height);
        }
        if (this.m_commonGraph.getSubtitle().isVisible()) {
            Rectangle subtitleRect = null;
            subtitleRect = this.m_pfj.getRect(this.m_pfj.getSubtitle());
            availableHeight -= (double)this.m_pfj.getVC().virtToDestHeight(subtitleRect.height);
        }
        if (this.m_commonGraph.getFootnote().isVisible()) {
            Rectangle footnoteRect = null;
            footnoteRect = this.m_pfj.getRect(this.m_pfj.getFootnote());
            availableHeight -= (double)this.m_pfj.getVC().virtToDestHeight(footnoteRect.height);
        }
        if (this.m_commonGraph.isO1AxisSupported() && this.m_commonGraph.getO1Axis().isVisible()) {
            if (this.m_commonGraph.isHorizontal()) {
                availableWidth *= 0.8;
            } else {
                int textRotation = this.m_commonGraph.getO1TickLabel().getTextRotation();
                if (textRotation == 90 || textRotation == 270) {
                    availableHeight *= 0.8;
                }
            }
        }
        if (this._isDualY(graphType = this.m_commonGraph.getGraphType()) && this.m_commonGraph.getY1Axis().isVisible() && this.m_commonGraph.getY2Axis().isVisible()) {
            if (this.m_commonGraph.isHorizontal()) {
                availableHeight *= 0.9;
            } else {
                availableWidth *= 0.9;
            }
        }
        if (this._isPie(graphType) && this.m_commonGraph.getSliceLabel().isVisible()) {
            availableWidth *= 0.9;
        }
        if (graphType == 93 || graphType == 94) {
            availableWidth *= 0.9;
        }
        if (graphType == 67 || graphType == 68) {
            if (availableWidth > availableHeight * 1.4) {
                return 2;
            }
            return 1;
        }
        if (graphType == 65 || graphType == 66) {
            if (availableWidth > availableHeight * 1.2) {
                return 2;
            }
            return 1;
        }
        if (availableHeight > availableWidth) {
            return 1;
        }
        return 2;
    }

    boolean isSupported(int graphType) {
        switch (graphType) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 84: 
            case 85: 
            case 86: 
            case 96: {
                return false;
            }
        }
        return true;
    }

    public void setPositionForRect() {
        Rectangle rect = this.m_pfj.getRect(this.m_pfj.getLegendArea());
        this.m_pfj.setIntegerProp(0, Attr.AutomaticPlacement);
        int centerX = rect.x + rect.width / 2;
        int centerY = rect.y + rect.height / 2;
        if (centerY > 0) {
            if (centerX < 0) {
                if (Math.abs(centerY) > Math.abs(centerX)) {
                    this.setLegendPositionProp(0);
                } else {
                    this.setLegendPositionProp(3);
                }
            } else if (Math.abs(centerY) > Math.abs(centerX)) {
                this.setLegendPositionProp(0);
            } else {
                this.setLegendPositionProp(2);
            }
        } else if (centerX < 0) {
            if (Math.abs(centerY) < Math.abs(centerX)) {
                this.setLegendPositionProp(3);
            } else {
                this.setLegendPositionProp(1);
            }
        } else if (Math.abs(centerY) < Math.abs(centerX)) {
            this.setLegendPositionProp(2);
        } else {
            this.setLegendPositionProp(1);
        }
        this.m_pfj.setBooleanProp(false, Attr.AlongGraphEdge);
    }

    private boolean _isDualY(int graphType) {
        switch (graphType) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 62: 
            case 64: 
            case 71: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 88: 
            case 91: 
            case 92: 
            case 98: {
                return true;
            }
        }
        return false;
    }

    private boolean _isPie(int graphType) {
        switch (graphType) {
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 93: 
            case 94: {
                return true;
            }
        }
        return false;
    }

    @Concealed
    public void setThreeDSurfaceGraph(boolean b) {
        this.m_bThreeDSurfaceGraph = b;
    }

    private boolean _isThreeDSurfaceGraph(int type) {
        return type == 12 || type == 13 || type == 14;
    }

    @Concealed
    public Rectangle getThreeDSurfaceRect() {
        return this.getLegendRect(true);
    }

    @Concealed
    public void setThreeDSurfaceRect(Rectangle rect) {
        this.setLegendRect(rect, true);
    }

    @Concealed
    public Object getThreeDSurfacePosition() {
        return this.getLegendPosition(true);
    }

    @Concealed
    public void setThreeDSurfacePosition(int position) {
        this.setLegendPosition(position, true);
    }

    @Concealed
    public boolean isThreeDSurfaceRectDefault() {
        return this.m_bThreeDSurfaceRectDefault;
    }

    @Concealed
    public void setThreeDSurfaceRectDefault(boolean b) {
        this.m_bThreeDSurfaceRectDefault = b;
    }

    @Concealed
    public Rectangle getStandardRect() {
        return this.getLegendRect(false);
    }

    @Concealed
    public void setStandardRect(Rectangle rect) {
        this.setLegendRect(rect, false);
    }

    @Concealed
    public Object getStandardPosition() {
        return this.getLegendPosition(false);
    }

    @Concealed
    public void setStandardPosition(int position) {
        this.setLegendPosition(position, false);
    }

    @Concealed
    public boolean isStandardRectDefault() {
        return this.m_bStandardRectDefault;
    }

    @Concealed
    public void setStandardRectDefault(boolean b) {
        this.m_bStandardRectDefault = b;
    }

    @Concealed
    public Rectangle getLegendRect(boolean bThreeDSurface) {
        if (bThreeDSurface && this.m_bThreeDSurfaceGraph || !bThreeDSurface && !this.m_bThreeDSurfaceGraph) {
            return this.m_commonGraph.getLegendArea().getRect();
        }
        Rectangle pfjRect = (Rectangle)this.m_pfj.getObjProp(Attr.LegendAlternateRect);
        if (pfjRect != null) {
            Rectangle rect = new Rectangle(pfjRect);
            rect.y += rect.height;
            return rect;
        }
        return null;
    }

    @Concealed
    public void setLegendRect(Rectangle rect, boolean bThreeDSurface) {
        if (bThreeDSurface && this.m_bThreeDSurfaceGraph || !bThreeDSurface && !this.m_bThreeDSurfaceGraph) {
            this.m_commonGraph.getLegendArea().setRect(rect);
        } else {
            Rectangle r = new Rectangle(rect);
            r.y -= r.height;
            this.m_pfj.setObjProp(r, Attr.LegendAlternateRect);
        }
    }

    @Concealed
    public Object getLegendPosition(boolean bThreeDSurface) {
        if (bThreeDSurface && this.m_bThreeDSurfaceGraph || !bThreeDSurface && !this.m_bThreeDSurfaceGraph) {
            return this.m_pfj.getObjProp(Attr.LegendPosition);
        }
        return this.m_pfj.getObjProp(Attr.LegendAlternatePosition);
    }

    @Concealed
    public void setLegendPosition(int position, boolean bThreeDSurface) {
        if (bThreeDSurface && this.m_bThreeDSurfaceGraph || !bThreeDSurface && !this.m_bThreeDSurfaceGraph) {
            this.m_commonGraph.getLegendArea().setPosition(position);
            this.m_automaticPosition = position;
        } else {
            this.m_pfj.setIntegerProp(position, Attr.LegendAlternatePosition);
            this.m_pfj.setObjProp(this.getDefaultPFJRect(this.m_pfj.getIntegerProp(Attr.LegendAlternatePosition), this.m_commonGraph.getLegendArea().isAlongGraphEdge()), Attr.LegendAlternateRect);
        }
    }

    @Concealed
    public void adjustTitlesForLegendAlongEdge(int position, boolean alongEdge) {
        Rectangle newTitleRect = new Rectangle((Rectangle)Attr.TitleRect.getDefault());
        newTitleRect.y += newTitleRect.height;
        Rectangle newSubtitleRect = new Rectangle((Rectangle)Attr.SubtitleRect.getDefault());
        newSubtitleRect.y += newSubtitleRect.height;
        Rectangle newFootnoteRect = new Rectangle((Rectangle)Attr.FootnoteRect.getDefault());
        newFootnoteRect.y += newFootnoteRect.height;
        if (alongEdge) {
            Rectangle legendRect = this.m_pfj.getRect(this.m_pfj.getLegendArea());
            if (legendRect != null) {
                Rectangle rect = new Rectangle(legendRect);
                rect.y += rect.height;
                legendRect = rect;
            }
            if (position == 0) {
                newTitleRect.y -= legendRect.height;
                newSubtitleRect.y -= legendRect.height;
            } else if (position == 1) {
                newFootnoteRect.y += legendRect.height;
            } else if (position == 3) {
                newTitleRect.width -= legendRect.width;
                newSubtitleRect.width -= legendRect.width;
                newFootnoteRect.width -= legendRect.width;
                newTitleRect.x = -16000 + legendRect.width + (32000 - legendRect.width - newTitleRect.width) / 2;
                newSubtitleRect.x = -16000 + legendRect.width + (32000 - legendRect.width - newSubtitleRect.width) / 2;
                newFootnoteRect.x = -16000 + legendRect.width + (32000 - legendRect.width - newFootnoteRect.width) / 2;
            } else if (position == 2) {
                newTitleRect.width -= legendRect.width;
                newSubtitleRect.width -= legendRect.width;
                newFootnoteRect.width -= legendRect.width;
                newTitleRect.x = -16000 + (32000 - legendRect.width - newTitleRect.width) / 2;
                newSubtitleRect.x = -16000 + (32000 - legendRect.width - newSubtitleRect.width) / 2;
                newFootnoteRect.x = -16000 + (32000 - legendRect.width - newFootnoteRect.width) / 2;
            }
        }
        ((GraphTitle)this.m_commonGraph.getTitle()).setRect(newTitleRect);
        ((GraphSubtitle)this.m_commonGraph.getSubtitle()).setRect(newSubtitleRect);
        ((GraphFootnote)this.m_commonGraph.getFootnote()).setRect(newFootnoteRect);
    }

    @Concealed
    public void setFrameSize(int type) {
        int position = this.m_commonGraph.getLegendArea().getPosition();
        Rectangle rect = this.getPieFrameRect(type, position);
        if (rect != null) {
            Rectangle pfjRect = new Rectangle(rect.x, rect.y - rect.height, rect.width, rect.height);
            if (type == 100) {
                this.m_pfj.setRect(this.m_pfj.getFunnelFrame(), pfjRect);
            } else {
                this.m_pfj.setRect(this.m_pfj.getPieFrame(), pfjRect);
            }
            return;
        }
        rect = this.getFrameRect(type, position);
        if (rect != null) {
            Rectangle pfjRect = new Rectangle(rect.x, rect.y - rect.height, rect.width, rect.height);
            this.m_pfj.setRect(this.m_pfj.getFrame(), pfjRect);
        }
    }

    @Concealed
    public Rectangle getPieFrameRect(int type, int position) {
        Rectangle rect = null;
        block0 : switch (type) {
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 100: {
                switch (position) {
                    case 2: {
                        rect = new Rectangle(-15405, 11795, 24864, 24992);
                        break;
                    }
                    case 3: {
                        rect = new Rectangle(-9459, 11795, 24864, 24992);
                        break;
                    }
                    case 0: {
                        rect = new Rectangle(-15405, 9518, 30540, 22481);
                        break;
                    }
                    case 1: {
                        rect = new Rectangle(-15405, 11795, 30540, 22481);
                    }
                }
                break;
            }
            case 93: 
            case 94: {
                switch (position) {
                    case 2: {
                        rect = new Rectangle(-15405, 11735, 21729, 24934);
                        break block0;
                    }
                    case 3: {
                        rect = new Rectangle(-9135, 11737, 21729, 24934);
                        break block0;
                    }
                    case 0: {
                        rect = new Rectangle(-15405, 9460, 27459, 22131);
                        break block0;
                    }
                    case 1: {
                        rect = new Rectangle(-15405, 11735, 27459, 22131);
                    }
                }
            }
        }
        return rect;
    }

    @Concealed
    public Rectangle getFrameRect(int type, int position) {
        Rectangle rect = null;
        switch (type) {
            case 17: 
            case 18: 
            case 23: 
            case 61: 
            case 76: 
            case 89: 
            case 97: 
            case 99: {
                switch (position) {
                    case 2: {
                        rect = new Rectangle(-11360, 11807, 20811, 22814);
                        break;
                    }
                    case 3: {
                        rect = new Rectangle(-5459, 11778, 20811, 22814);
                        break;
                    }
                    case 0: {
                        rect = new Rectangle(-11360, 9460, 26540, 19912);
                        break;
                    }
                    case 1: {
                        rect = new Rectangle(-11360, 11807, 26540, 19912);
                    }
                }
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 62: 
            case 91: 
            case 98: {
                switch (position) {
                    case 2: {
                        rect = new Rectangle(-11360, 11807, 17190, 22814);
                        break;
                    }
                    case 3: {
                        rect = new Rectangle(-5459, 11778, 17190, 22814);
                        break;
                    }
                    case 0: {
                        rect = new Rectangle(-11360, 9460, 23567, 19912);
                        break;
                    }
                    case 1: {
                        rect = new Rectangle(-11360, 11807, 23567, 19912);
                    }
                }
                break;
            }
            case 24: 
            case 25: 
            case 30: {
                switch (position) {
                    case 2: {
                        rect = new Rectangle(-10604, 11807, 20054, 22814);
                        break;
                    }
                    case 3: {
                        rect = new Rectangle(-4648, 11807, 20054, 22814);
                        break;
                    }
                    case 0: {
                        rect = new Rectangle(-10604, 9460, 25729, 19854);
                        break;
                    }
                    case 1: {
                        rect = new Rectangle(-10604, 11807, 25729, 19854);
                    }
                }
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                switch (position) {
                    case 2: {
                        rect = new Rectangle(-10604, 10006, 20054, 21013);
                        break;
                    }
                    case 3: {
                        rect = new Rectangle(-4648, 10006, 20054, 21013);
                        break;
                    }
                    case 0: {
                        rect = new Rectangle(-10604, 7708, 25729, 18277);
                        break;
                    }
                    case 1: {
                        rect = new Rectangle(-10604, 10006, 25729, 18277);
                    }
                }
                break;
            }
            case 65: 
            case 67: {
                switch (position) {
                    case 2: {
                        rect = new Rectangle(-13677, 11735, 21837, 23824);
                        break;
                    }
                    case 3: {
                        rect = new Rectangle(-7945, 11735, 21837, 23824);
                        break;
                    }
                    case 0: {
                        rect = new Rectangle(-13677, 9577, 28108, 21781);
                        break;
                    }
                    case 1: {
                        rect = new Rectangle(-13677, 11735, 28108, 21781);
                    }
                }
                break;
            }
            case 70: {
                rect = new Rectangle(-11792, 11807, 26972, 22814);
                break;
            }
            case 71: {
                rect = new Rectangle(-11792, 11807, 23567, 22814);
                break;
            }
            case 88: {
                switch (position) {
                    default: {
                        rect = new Rectangle(-11360, 11807, 17190, 23474);
                        break;
                    }
                    case 3: {
                        rect = new Rectangle(-5459, 11778, 17190, 23474);
                        break;
                    }
                    case 0: {
                        rect = new Rectangle(-11360, 9518, 22540, 20496);
                        break;
                    }
                    case 1: {
                        rect = new Rectangle(-11360, 11807, 22540, 20496);
                    }
                }
            }
            case 96: {
                rect = new Rectangle(-11360, 11807, 23567, 22814);
            }
        }
        return rect;
    }

    public void setLegendPositionProp(int position) {
        if (this.m_pfj.getIntegerProp(Attr.LegendPosition) != position) {
            this.m_pfj.setIntegerProp(position, Attr.LegendPosition);
        }
        this.m_automaticPosition = position;
    }

    @Concealed
    public void resetToDefault() {
        this.m_bThreeDSurfaceGraph = false;
        this.m_bStandardRectDefault = true;
        this.m_bThreeDSurfaceRectDefault = true;
        this.m_automaticPosition = 2;
    }
}

