/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Font;
import oracle.dss.graph.pfj.FontCacheElement;

public class FontCache {
    static final int NUM_FONTS = 50;
    static final int NOT_FOUND = -1;
    protected FontCacheElement[] m_fontStuffArray = new FontCacheElement[50];
    protected int m_nCount = 0;

    public void addToCache(String szFontName, int nFontStyle, int nFontSize, Font font) {
        FontCacheElement fso = new FontCacheElement(szFontName, nFontStyle, nFontSize, font, this.m_nCount);
        int lru = this.m_nCount;
        int lruPos = 49;
        for (int i = 0; i < 50; ++i) {
            if (this.m_fontStuffArray[i] == null) {
                this.m_fontStuffArray[i] = fso;
                return;
            }
            if (this.m_fontStuffArray[i].m_nCount >= lru) continue;
            lru = this.m_fontStuffArray[i].m_nCount;
            lruPos = i;
        }
        this.m_fontStuffArray[lruPos] = fso;
    }

    public int cachePosition(String szFontName, int nFontStyle, int nFontSize) {
        FontCacheElement fso;
        int pos = -1;
        for (int i = 0; i < 50 && (fso = this.m_fontStuffArray[i]) != null; ++i) {
            if (fso.m_fontSize != nFontSize || fso.m_fontStyle != nFontStyle || !fso.m_fontName.equals(szFontName)) continue;
            pos = i;
            break;
        }
        return pos;
    }

    public Font getFont(String szFontName, int nFontStyle, int nFontSize) {
        Font font;
        int index = this.cachePosition(szFontName, nFontStyle, nFontSize);
        if (this.m_nCount == Integer.MAX_VALUE) {
            for (int i = 0; i < 50; ++i) {
                if (this.m_fontStuffArray[i] == null || this.m_fontStuffArray[i].m_nCount <= 0) continue;
                this.m_fontStuffArray[i].m_nCount -= Integer.MAX_VALUE;
            }
            this.m_nCount = 1;
        } else {
            ++this.m_nCount;
        }
        if (index == -1) {
            font = new Font(szFontName, nFontStyle, nFontSize);
            this.addToCache(szFontName, nFontStyle, nFontSize, font);
        } else {
            font = this.m_fontStuffArray[index].m_font;
            this.m_fontStuffArray[index].m_nCount = this.m_nCount;
        }
        return font;
    }
}

