/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.JChart_2D_BLA;
import oracle.dss.graph.pfj.JChart_2D_Scat;
import oracle.dss.graph.pfj.JChart_2D_Spec;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RangeSlider;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.ZoomState;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class ChartFrameZoom
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Perspective m_Perspective;
    protected JChart_Base m_Chart;
    public static final String O1AXIS_ID = "O1";
    public static final String X1AXIS_ID = "X1";
    public static final String Y1AXIS_ID = "Y1";
    public static final String Y2AXIS_ID = "Y2";
    public static final String ALLAXIS_ID = "ALL";
    @CodeSharingSafe(value="StaticField")
    private static final double[] ZOOM_RATIOS = new double[]{1.0, 1.25, 1.5, 2.0, 4.0, 8.0, 16.0};

    public ChartFrameZoom(Perspective perspective, JChart_Base chart) {
        this.m_Perspective = perspective;
        this.m_Chart = chart;
    }

    public static boolean isZoomAllowed(JChart_Base chart) {
        return chart != null && (chart instanceof JChart_2D_BLA || chart instanceof JChart_2D_Scat);
    }

    public void doZoomIn(ZoomState zoomState, Rectangle rZoom) {
        this.doZoomIn(zoomState, rZoom, true);
    }

    protected void doZoomIn(ZoomState zoomState, Rectangle rZoom, boolean bApply) {
        if (rZoom.width < 0 && rZoom.height < 0) {
            int zoomedAxes = 255;
            if (this.m_Perspective.getZoomDirection() == 1) {
                zoomedAxes = 9;
            } else if (this.m_Perspective.getZoomDirection() == 2) {
                zoomedAxes = 6;
            }
            this.doZoomIn(zoomState, rZoom.x, rZoom.y, bApply, zoomedAxes);
            return;
        }
        JGraphType gt = this.m_Perspective.getJGraphType();
        double fMin_X1 = 0.0;
        double fMin_Y1 = 0.0;
        double fMin_Y2 = 0.0;
        double fMax_X1 = 0.0;
        double fMax_Y1 = 0.0;
        double fMax_Y2 = 0.0;
        int nViewableGroups = this.m_Perspective.getEffectiveViewableGroups();
        int nViewableSeries = this.m_Perspective.getEffectiveViewableSeries();
        int nScrollOffsetGroup = this.m_Perspective.getEffectiveGroupOffset();
        int nScrollOffsetSeries = this.m_Perspective.getEffectiveSeriesOffset();
        boolean bAutoMinX1 = false;
        boolean bAutoMaxX1 = false;
        boolean bAutoMinY1 = false;
        boolean bAutoMaxY1 = false;
        boolean bAutoMinY2 = false;
        boolean bAutoMaxY2 = false;
        boolean bLiveScroll = this.m_Perspective.getZoomAndScroll() == 0;
        VC rsVC = this.m_Perspective.getRangeSliderVC();
        if (bLiveScroll) {
            rZoom = rsVC.destToVirt(this.m_Perspective.getVC().virtToDest(rZoom));
        }
        if (ChartFrameZoom.isZoomAllowed(this.m_Chart)) {
            int nYMaxCoord;
            int nYMinCoord;
            int nVertMaxCoord;
            int nVertMinCoord;
            JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
            AxisDescriptor ad = gt.getAxisDescriptor();
            RelativeAxisObj axisObj = ch.m_X1Axis;
            if (axisObj == null && this.m_Perspective.isContinuousTimeAxis()) {
                axisObj = ch.m_O1Axis;
            }
            if (axisObj != null) {
                int nXMaxCoord;
                int nXMinCoord;
                if (gt.isOrientHorz()) {
                    nXMinCoord = rZoom.y;
                    nXMaxCoord = rZoom.y + rZoom.height;
                } else {
                    nXMinCoord = rZoom.x;
                    nXMaxCoord = rZoom.x + rZoom.width;
                }
                fMin_X1 = (double)nXMinCoord <= axisObj.getMinCoord() ? axisObj.getMinValue() : axisObj.getValueFromCoord(nXMinCoord);
                fMax_X1 = (double)nXMaxCoord >= axisObj.getMaxCoord() ? axisObj.getMaxValue() : axisObj.getValueFromCoord(nXMaxCoord);
                if (this._almostEquals(fMin_X1, axisObj.getMinValue(), axisObj.getMaxValue() - axisObj.getMinValue())) {
                    bAutoMinX1 = true;
                }
                if (this._almostEquals(fMax_X1, axisObj.getMaxValue(), axisObj.getMaxValue() - axisObj.getMinValue())) {
                    bAutoMaxX1 = true;
                }
            }
            if (gt.isOrientHorz()) {
                nVertMinCoord = rZoom.x;
                nVertMaxCoord = rZoom.x + rZoom.width;
            } else {
                nVertMinCoord = rZoom.y;
                nVertMaxCoord = rZoom.y + rZoom.height;
            }
            if (ch.m_Y1Axis != null) {
                nYMinCoord = nVertMinCoord;
                nYMaxCoord = nVertMaxCoord;
                if (!((double)nYMinCoord > ch.m_Y1Axis.getMaxCoord()) && !((double)nYMaxCoord < ch.m_Y1Axis.getMinCoord())) {
                    fMin_Y1 = (double)nYMinCoord <= ch.m_Y1Axis.getMinCoord() ? ch.m_Y1Axis.getMinValue() : ch.m_Y1Axis.getValueFromCoord(nYMinCoord);
                    fMax_Y1 = (double)nYMaxCoord <= ch.m_Y1Axis.getMinCoord() ? ch.m_Y1Axis.getMinValue() : ((double)nYMaxCoord >= ch.m_Y1Axis.getMaxCoord() ? ch.m_Y1Axis.getMaxValue() : ch.m_Y1Axis.getValueFromCoord(nYMaxCoord));
                    if (this._almostEquals(fMin_Y1, ch.m_Y1Axis.getMinValue(), ch.m_Y1Axis.getMaxValue() - ch.m_Y1Axis.getMinValue())) {
                        bAutoMinY1 = true;
                    }
                    if (this._almostEquals(fMax_Y1, ch.m_Y1Axis.getMaxValue(), ch.m_Y1Axis.getMaxValue() - ch.m_Y1Axis.getMinValue())) {
                        bAutoMaxY1 = true;
                    }
                }
            }
            if (ch.m_Y2Axis != null) {
                nYMinCoord = nVertMinCoord;
                nYMaxCoord = nVertMaxCoord;
                RangeSlider y2RS = this.m_Perspective.getY2RangeSlider();
                if (bLiveScroll && y2RS != null && y2RS.getVC() != null) {
                    if (gt.isOrientHorz()) {
                        nYMinCoord = y2RS.getVC().destToVirtX(rsVC.virtToDestX(nVertMinCoord));
                        nYMaxCoord = y2RS.getVC().destToVirtX(rsVC.virtToDestX(nVertMaxCoord));
                    } else {
                        nYMinCoord = y2RS.getVC().destToVirtY(rsVC.virtToDestY(nVertMinCoord));
                        nYMaxCoord = y2RS.getVC().destToVirtY(rsVC.virtToDestY(nVertMaxCoord));
                    }
                }
                if (!((double)nYMinCoord > ch.m_Y2Axis.getMaxCoord()) && !((double)nYMaxCoord < ch.m_Y2Axis.getMinCoord())) {
                    fMin_Y2 = (double)nYMinCoord <= ch.m_Y2Axis.getMinCoord() ? ch.m_Y2Axis.getMinValue() : ch.m_Y2Axis.getValueFromCoord(nYMinCoord);
                    fMax_Y2 = (double)nYMaxCoord <= ch.m_Y2Axis.getMinCoord() ? ch.m_Y2Axis.getMinValue() : ((double)nYMaxCoord >= ch.m_Y2Axis.getMaxCoord() ? ch.m_Y2Axis.getMaxValue() : ch.m_Y2Axis.getValueFromCoord(nYMaxCoord));
                    if (this._almostEquals(fMin_Y2, ch.m_Y2Axis.getMinValue(), ch.m_Y2Axis.getMaxValue() - ch.m_Y2Axis.getMinValue())) {
                        bAutoMinY2 = true;
                    }
                    if (this._almostEquals(fMax_Y2, ch.m_Y2Axis.getMaxValue(), ch.m_Y2Axis.getMaxValue() - ch.m_Y2Axis.getMinValue())) {
                        bAutoMaxY2 = true;
                    }
                }
            }
            if (ch.m_O1Axis != null && !this.m_Perspective.isContinuousTimeAxis()) {
                int nLastGroup;
                int nFirstGroup;
                int nOMaxCoord;
                int nOMinCoord;
                if (gt.isOrientHorz()) {
                    nOMinCoord = rZoom.y;
                    nOMaxCoord = rZoom.y + rZoom.height;
                } else {
                    nOMinCoord = rZoom.x;
                    nOMaxCoord = rZoom.x + rZoom.width;
                }
                if (gt.isOrientHorz()) {
                    nFirstGroup = ch.m_O1Axis.getGroupBelowCoord(nOMaxCoord);
                    nLastGroup = ch.m_O1Axis.getGroupAboveCoord(nOMinCoord);
                } else {
                    nFirstGroup = ch.m_O1Axis.getGroupAboveCoord(nOMinCoord);
                    nLastGroup = ch.m_O1Axis.getGroupBelowCoord(nOMaxCoord);
                }
                if ((nLastGroup += nScrollOffsetGroup) < (nFirstGroup += nScrollOffsetGroup)) {
                    nLastGroup = nFirstGroup;
                }
                if ((nViewableGroups = nLastGroup - nFirstGroup + 1) < this.m_Perspective.getMinNumGroups()) {
                    nViewableGroups = this.m_Perspective.getMinNumGroups();
                }
                nScrollOffsetGroup = nFirstGroup;
                if (nFirstGroup + nViewableGroups > this.m_Perspective.getNumTotalGroups()) {
                    nScrollOffsetGroup = this.m_Perspective.getNumTotalGroups() - nViewableGroups;
                }
                if (nViewableGroups == this.m_Perspective.getNumTotalGroups()) {
                    nViewableGroups = 0;
                }
                if (bApply) {
                    this.m_Perspective.setViewableGroups(nViewableGroups);
                    this.m_Perspective.setScrollOffsetGroup(nScrollOffsetGroup);
                }
            }
            if (ch instanceof JChart_2D_Spec) {
                JChart_2D_Spec chSpec = (JChart_2D_Spec)ch;
                if (chSpec.m_O2Axis != null) {
                    int nFirstSeries = chSpec.m_O2Axis.getGroupAboveCoord(rZoom.y);
                    int nLastSeries = chSpec.m_O2Axis.getGroupBelowCoord(rZoom.y + rZoom.height);
                    if ((nLastSeries += nScrollOffsetSeries) < (nFirstSeries += nScrollOffsetSeries)) {
                        nLastSeries = nFirstSeries;
                    }
                    nViewableSeries = nLastSeries - nFirstSeries + 1;
                    nScrollOffsetSeries = nFirstSeries;
                    if (bApply) {
                        this.m_Perspective.setViewableSeries(nViewableSeries);
                        this.m_Perspective.setScrollOffsetSeries(nScrollOffsetSeries);
                    }
                }
            }
            zoomState.ChartFrame(fMin_X1, fMax_X1, fMin_Y1, fMax_Y1, fMin_Y2, fMax_Y2, nViewableGroups, nScrollOffsetGroup, nViewableSeries, nScrollOffsetSeries, ad, bAutoMinX1, bAutoMaxX1, bAutoMinY1, bAutoMaxY1, bAutoMinY2, bAutoMaxY2, 255);
        }
    }

    protected void doZoomIn(ZoomState zoomState, String axis, boolean bApply) {
        boolean bLiveScroll;
        JGraphType gt = this.m_Perspective.getJGraphType();
        JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
        boolean bl = bLiveScroll = this.m_Perspective.getZoomAndScroll() == 0;
        if (axis.equalsIgnoreCase(O1AXIS_ID) && ch.m_O1Axis != null && !this.m_Perspective.isContinuousTimeAxis()) {
            double minCoord = ((Axis2DObj)ch.m_O1Axis).m_axisOrgVC;
            double maxCoord = minCoord + (double)((Axis2DObj)ch.m_O1Axis).m_axisLengthVC;
            if (bLiveScroll) {
                int start = this.m_Perspective.getHorzRangeSlider().getZoomOffsetGroup();
                int count = this.m_Perspective.getHorzRangeSlider().getZoomViewableGroups();
                int coordPerGroup = (int)(maxCoord - minCoord) / this.m_Perspective.getNumTotalGroups();
                maxCoord = (minCoord += (double)(start * coordPerGroup)) + (double)(count * coordPerGroup);
            }
            int centerCoord = (int)(minCoord + (maxCoord - minCoord) / 2.0);
            if (gt.isOrientHorz()) {
                this.doZoomIn(zoomState, 0, centerCoord, bApply, 8);
            } else {
                this.doZoomIn(zoomState, centerCoord, 0, bApply, 8);
            }
        } else if (axis.equalsIgnoreCase(X1AXIS_ID) && (ch.m_X1Axis != null || ch.m_O1Axis != null && this.m_Perspective.isContinuousTimeAxis())) {
            RelativeAxisObj axisObj = ch.m_X1Axis;
            if (axisObj == null) {
                axisObj = ch.m_O1Axis;
            }
            double minCoord = bLiveScroll ? axisObj.getValueCoord(this.m_Perspective.getHorzRangeSlider().getZoomMin()) : axisObj.getMinCoord();
            double maxCoord = bLiveScroll ? axisObj.getValueCoord(this.m_Perspective.getHorzRangeSlider().getZoomMax()) : axisObj.getMaxCoord();
            int centerCoord = (int)(minCoord + (maxCoord - minCoord) / 2.0);
            if (gt.isOrientHorz()) {
                this.doZoomIn(zoomState, 0, centerCoord, bApply, 1);
            } else {
                this.doZoomIn(zoomState, centerCoord, 0, bApply, 1);
            }
        } else if (axis.equalsIgnoreCase(Y1AXIS_ID) && ch.m_Y1Axis != null) {
            double minCoord = bLiveScroll ? ch.m_Y1Axis.getValueCoord(this.m_Perspective.getY1RangeSlider().getZoomMin()) : ch.m_Y1Axis.getMinCoord();
            double maxCoord = bLiveScroll ? ch.m_Y1Axis.getValueCoord(this.m_Perspective.getY1RangeSlider().getZoomMax()) : ch.m_Y1Axis.getMaxCoord();
            int centerCoord = (int)(minCoord + (maxCoord - minCoord) / 2.0);
            if (gt.isOrientHorz()) {
                this.doZoomIn(zoomState, centerCoord, 0, bApply, 2);
            } else {
                this.doZoomIn(zoomState, 0, centerCoord, bApply, 2);
            }
        } else if (axis.equalsIgnoreCase(Y2AXIS_ID) && ch.m_Y2Axis != null) {
            double minCoord = bLiveScroll ? ch.m_Y2Axis.getValueCoord(this.m_Perspective.getY2RangeSlider().getZoomMin()) : ch.m_Y2Axis.getMinCoord();
            double maxCoord = bLiveScroll ? ch.m_Y2Axis.getValueCoord(this.m_Perspective.getY2RangeSlider().getZoomMax()) : ch.m_Y2Axis.getMaxCoord();
            int centerCoord = (int)(minCoord + (maxCoord - minCoord) / 2.0);
            if (gt.isOrientHorz()) {
                this.doZoomIn(zoomState, centerCoord, 0, bApply, 4);
            } else {
                this.doZoomIn(zoomState, 0, centerCoord, bApply, 4);
            }
        }
    }

    protected void doZoomIn(ZoomState zoomState, int x, int y, boolean bApply, int zoomedAxes) {
        boolean bLiveScroll;
        JGraphType gt = this.m_Perspective.getJGraphType();
        double newZoomRatio = -1.0;
        boolean bl = bLiveScroll = this.m_Perspective.getZoomAndScroll() == 0;
        if (ChartFrameZoom.isZoomAllowed(this.m_Chart)) {
            double min;
            double max;
            int nXCoord;
            JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
            if (ch.m_Y1Axis != null && (zoomedAxes & 2) > 0) {
                int nYCoord = gt.isOrientHorz() ? x : y;
                if (!((double)nYCoord > ch.m_Y1Axis.getMaxCoord()) && !((double)nYCoord < ch.m_Y1Axis.getMinCoord())) {
                    double zoomMin = ch.m_Y1Axis.getValueCoordForZoom(this.m_Perspective.getY1ScaleMinAutoValue());
                    double zoomMax = ch.m_Y1Axis.getValueCoordForZoom(this.m_Perspective.getY1ScaleMaxAutoValue());
                    if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && ch.m_Y1Axis.getAutoMinMaxArray() != null) {
                        zoomMin = ch.m_Y1Axis.getValueCoordForZoom(ch.m_Y1Axis.getAutoMinMaxArray()[0]);
                        zoomMax = ch.m_Y1Axis.getValueCoordForZoom(ch.m_Y1Axis.getAutoMinMaxArray()[1]);
                    }
                    Double scaleZoomMin = this.m_Perspective.getY1ScaleZoomMin();
                    Double scaleZoomMax = this.m_Perspective.getY1ScaleZoomMax();
                    if (scaleZoomMin != null) {
                        zoomMin = ch.m_Y1Axis.getValueCoordForZoom(scaleZoomMin);
                    }
                    if (scaleZoomMax != null) {
                        zoomMax = ch.m_Y1Axis.getValueCoordForZoom(scaleZoomMax);
                    }
                    double min2 = bLiveScroll ? ch.m_Y1Axis.getValueCoord(this.m_Perspective.getY1RangeSlider().getZoomMin()) : ch.m_Y1Axis.getMinCoord();
                    double max2 = bLiveScroll ? ch.m_Y1Axis.getValueCoord(this.m_Perspective.getY1RangeSlider().getZoomMax()) : ch.m_Y1Axis.getMaxCoord();
                    double ratio = (zoomMax - zoomMin) / (max2 - min2);
                    newZoomRatio = ChartFrameZoom.getNextIncrZoomInRatio(ratio);
                }
            } else if (ch.m_Y2Axis != null && (zoomedAxes & 4) > 0) {
                int nYCoord = gt.isOrientHorz() ? x : y;
                if (!((double)nYCoord > ch.m_Y2Axis.getMaxCoord()) && !((double)nYCoord < ch.m_Y2Axis.getMinCoord())) {
                    double zoomMin = ch.m_Y2Axis.getValueCoordForZoom(this.m_Perspective.getY2ScaleMinAutoValue());
                    double zoomMax = ch.m_Y2Axis.getValueCoordForZoom(this.m_Perspective.getY2ScaleMaxAutoValue());
                    if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && ch.m_Y2Axis.getAutoMinMaxArray() != null) {
                        zoomMin = ch.m_Y2Axis.getValueCoordForZoom(ch.m_Y2Axis.getAutoMinMaxArray()[0]);
                        zoomMax = ch.m_Y2Axis.getValueCoordForZoom(ch.m_Y2Axis.getAutoMinMaxArray()[1]);
                    }
                    Double scaleZoomMin = this.m_Perspective.getY2ScaleZoomMin();
                    Double scaleZoomMax = this.m_Perspective.getY2ScaleZoomMax();
                    if (scaleZoomMin != null) {
                        zoomMin = ch.m_Y2Axis.getValueCoordForZoom(scaleZoomMin);
                    }
                    if (scaleZoomMax != null) {
                        zoomMax = ch.m_Y2Axis.getValueCoordForZoom(scaleZoomMax);
                    }
                    double min3 = bLiveScroll ? ch.m_Y2Axis.getValueCoord(this.m_Perspective.getY2RangeSlider().getZoomMin()) : ch.m_Y2Axis.getMinCoord();
                    double max3 = bLiveScroll ? ch.m_Y2Axis.getValueCoord(this.m_Perspective.getY2RangeSlider().getZoomMax()) : ch.m_Y2Axis.getMaxCoord();
                    double ratio = (zoomMax - zoomMin) / (max3 - min3);
                    newZoomRatio = ChartFrameZoom.getNextIncrZoomInRatio(ratio);
                }
            } else if ((ch.m_X1Axis != null || ch.m_O1Axis != null && this.m_Perspective.isContinuousTimeAxis()) && (zoomedAxes & 1) > 0) {
                int nXCoord2;
                RelativeAxisObj axisObj = null;
                axisObj = ch.m_X1Axis;
                if (axisObj == null) {
                    axisObj = ch.m_O1Axis;
                }
                if (!((double)(nXCoord2 = !gt.isOrientHorz() ? x : y) > axisObj.getMaxCoord()) && !((double)nXCoord2 < axisObj.getMinCoord()) || this.m_Perspective.isAxisFlipped() && (double)nXCoord2 > axisObj.getMaxCoord() && (double)nXCoord2 < axisObj.getMinCoord()) {
                    double zoomMin = axisObj.getValueCoordForZoom(this.m_Perspective.getX1ScaleMinAutoValue());
                    double zoomMax = axisObj.getValueCoordForZoom(this.m_Perspective.getX1ScaleMaxAutoValue());
                    if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && axisObj.getAutoMinMaxArray() != null) {
                        zoomMin = axisObj.getValueCoordForZoom(axisObj.getAutoMinMaxArray()[0]);
                        zoomMax = axisObj.getValueCoordForZoom(axisObj.getAutoMinMaxArray()[1]);
                    }
                    Double scaleZoomMin = this.m_Perspective.getX1ScaleZoomMin();
                    Double scaleZoomMax = this.m_Perspective.getX1ScaleZoomMax();
                    if (scaleZoomMin != null) {
                        zoomMin = axisObj.getValueCoordForZoom(scaleZoomMin);
                    }
                    if (scaleZoomMax != null) {
                        zoomMax = axisObj.getValueCoordForZoom(scaleZoomMax);
                    }
                    double min4 = bLiveScroll ? axisObj.getValueCoord(this.m_Perspective.getHorzRangeSlider().getZoomMin()) : axisObj.getMinCoord();
                    double max4 = bLiveScroll ? axisObj.getValueCoord(this.m_Perspective.getHorzRangeSlider().getZoomMax()) : axisObj.getMaxCoord();
                    double ratio = (zoomMax - zoomMin) / (max4 - min4);
                    newZoomRatio = ChartFrameZoom.getNextIncrZoomInRatio(ratio);
                }
            } else if (ch.m_O1Axis != null && !this.m_Perspective.isContinuousTimeAxis() && (zoomedAxes & 8) > 0 && (!((double)(nXCoord = !gt.isOrientHorz() ? x : y) > (max = (min = (double)((Axis2DObj)ch.m_O1Axis).m_axisOrgVC) + (double)((Axis2DObj)ch.m_O1Axis).m_axisLengthVC)) && !((double)nXCoord < min) || this.m_Perspective.isAxisFlipped() && (double)nXCoord > max && (double)nXCoord < min)) {
                int nLastGroup;
                int nFirstGroup;
                int nScrollOffsetGroup = this.m_Perspective.getEffectiveGroupOffset();
                if (bLiveScroll) {
                    nFirstGroup = 0;
                    nLastGroup = nFirstGroup + this.m_Perspective.getHorzRangeSlider().getZoomViewableGroups() - 1;
                } else if (gt.isOrientHorz()) {
                    nFirstGroup = ch.m_O1Axis.getGroupBelowCoordForZoom((int)max);
                    nLastGroup = ch.m_O1Axis.getGroupAboveCoordForZoom((int)min);
                } else {
                    nFirstGroup = ch.m_O1Axis.getGroupAboveCoordForZoom((int)min);
                    nLastGroup = ch.m_O1Axis.getGroupBelowCoordForZoom((int)max);
                }
                if ((nLastGroup += nScrollOffsetGroup) < (nFirstGroup += nScrollOffsetGroup)) {
                    nLastGroup = nFirstGroup;
                }
                int nViewableGroups = nLastGroup - nFirstGroup + 1;
                double ratio = (double)this.m_Perspective.getNumTotalGroups() / (double)nViewableGroups;
                int newViewableGroups = nViewableGroups;
                while ((newViewableGroups == 0 || newViewableGroups >= this.m_Perspective.getMinNumGroups() && newViewableGroups >= nViewableGroups) && ratio < ZOOM_RATIOS[ZOOM_RATIOS.length - 1]) {
                    newZoomRatio = ChartFrameZoom.getNextIncrZoomInRatio(ratio);
                    int[] o1ViewableArray = new int[]{this.m_Perspective.getEffectiveViewableGroups(), this.m_Perspective.getEffectiveViewableSeries()};
                    int[] o1ScrollOffsetArray = new int[]{this.m_Perspective.getEffectiveGroupOffset(), this.m_Perspective.getEffectiveSeriesOffset()};
                    this.doZoomO1(o1ViewableArray, o1ScrollOffsetArray, x, y, newZoomRatio, false);
                    newViewableGroups = o1ViewableArray[0];
                    ratio = newZoomRatio;
                }
            }
            if (newZoomRatio > -1.0) {
                this.doZoom(zoomState, x, y, newZoomRatio, bApply, zoomedAxes);
            }
        }
    }

    protected void doZoomOut(ZoomState zoomState, int x, int y, boolean bApply, int zoomedAxes) {
        boolean bLiveScroll;
        JGraphType gt = this.m_Perspective.getJGraphType();
        double newZoomRatio = -1.0;
        boolean bl = bLiveScroll = this.m_Perspective.getZoomAndScroll() == 0;
        if (ChartFrameZoom.isZoomAllowed(this.m_Chart)) {
            double min;
            double max;
            int nXCoord;
            JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
            if (ch.m_Y1Axis != null && (zoomedAxes & 2) > 0) {
                int nYCoord = gt.isOrientHorz() ? x : y;
                if (!((double)nYCoord > ch.m_Y1Axis.getMaxCoord()) && !((double)nYCoord < ch.m_Y1Axis.getMinCoord())) {
                    double zoomMin = ch.m_Y1Axis.getValueCoordForZoom(this.m_Perspective.getY1ScaleMinAutoValue());
                    double zoomMax = ch.m_Y1Axis.getValueCoordForZoom(this.m_Perspective.getY1ScaleMaxAutoValue());
                    if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && ch.m_Y1Axis.getAutoMinMaxArray() != null) {
                        zoomMin = ch.m_Y1Axis.getValueCoordForZoom(ch.m_Y1Axis.getAutoMinMaxArray()[0]);
                        zoomMax = ch.m_Y1Axis.getValueCoordForZoom(ch.m_Y1Axis.getAutoMinMaxArray()[1]);
                    }
                    Double scaleZoomMin = this.m_Perspective.getY1ScaleZoomMin();
                    Double scaleZoomMax = this.m_Perspective.getY1ScaleZoomMax();
                    if (scaleZoomMin != null) {
                        zoomMin = ch.m_Y1Axis.getValueCoordForZoom(scaleZoomMin);
                    }
                    if (scaleZoomMax != null) {
                        zoomMax = ch.m_Y1Axis.getValueCoordForZoom(scaleZoomMax);
                    }
                    double min2 = bLiveScroll ? ch.m_Y1Axis.getValueCoord(this.m_Perspective.getY1RangeSlider().getZoomMin()) : ch.m_Y1Axis.getMinCoord();
                    double max2 = bLiveScroll ? ch.m_Y1Axis.getValueCoord(this.m_Perspective.getY1RangeSlider().getZoomMax()) : ch.m_Y1Axis.getMaxCoord();
                    double ratio = (zoomMax - zoomMin) / (max2 - min2);
                    newZoomRatio = ChartFrameZoom.getNextIncrZoomOutRatio(ratio);
                }
            } else if (ch.m_Y2Axis != null && (zoomedAxes & 4) > 0) {
                int nYCoord = gt.isOrientHorz() ? x : y;
                if (!((double)nYCoord > ch.m_Y2Axis.getMaxCoord()) && !((double)nYCoord < ch.m_Y2Axis.getMinCoord())) {
                    double zoomMin = ch.m_Y2Axis.getValueCoordForZoom(this.m_Perspective.getY2ScaleMinAutoValue());
                    double zoomMax = ch.m_Y2Axis.getValueCoordForZoom(this.m_Perspective.getY2ScaleMaxAutoValue());
                    if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && ch.m_Y2Axis.getAutoMinMaxArray() != null) {
                        zoomMin = ch.m_Y2Axis.getValueCoordForZoom(ch.m_Y2Axis.getAutoMinMaxArray()[0]);
                        zoomMax = ch.m_Y2Axis.getValueCoordForZoom(ch.m_Y2Axis.getAutoMinMaxArray()[1]);
                    }
                    Double scaleZoomMin = this.m_Perspective.getY2ScaleZoomMin();
                    Double scaleZoomMax = this.m_Perspective.getY2ScaleZoomMax();
                    if (scaleZoomMin != null) {
                        zoomMin = ch.m_Y2Axis.getValueCoordForZoom(scaleZoomMin);
                    }
                    if (scaleZoomMax != null) {
                        zoomMax = ch.m_Y2Axis.getValueCoordForZoom(scaleZoomMax);
                    }
                    double min3 = bLiveScroll ? ch.m_Y2Axis.getValueCoord(this.m_Perspective.getY2RangeSlider().getZoomMin()) : ch.m_Y2Axis.getMinCoord();
                    double max3 = bLiveScroll ? ch.m_Y2Axis.getValueCoord(this.m_Perspective.getY2RangeSlider().getZoomMax()) : ch.m_Y2Axis.getMaxCoord();
                    double ratio = (zoomMax - zoomMin) / (max3 - min3);
                    newZoomRatio = ChartFrameZoom.getNextIncrZoomOutRatio(ratio);
                }
            } else if ((ch.m_X1Axis != null || ch.m_O1Axis != null && this.m_Perspective.isContinuousTimeAxis()) && (zoomedAxes & 1) > 0) {
                int nXCoord2 = !gt.isOrientHorz() ? x : y;
                RelativeAxisObj axisObj = ch.m_X1Axis;
                if (axisObj == null) {
                    axisObj = ch.m_O1Axis;
                }
                if (!((double)nXCoord2 > axisObj.getMaxCoord()) && !((double)nXCoord2 < axisObj.getMinCoord())) {
                    double zoomMin = axisObj.getValueCoordForZoom(this.m_Perspective.getX1ScaleMinAutoValue());
                    double zoomMax = axisObj.getValueCoordForZoom(this.m_Perspective.getX1ScaleMaxAutoValue());
                    if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && axisObj.getAutoMinMaxArray() != null) {
                        zoomMin = axisObj.getValueCoordForZoom(axisObj.getAutoMinMaxArray()[0]);
                        zoomMax = axisObj.getValueCoordForZoom(axisObj.getAutoMinMaxArray()[1]);
                    }
                    Double scaleZoomMin = this.m_Perspective.getX1ScaleZoomMin();
                    Double scaleZoomMax = this.m_Perspective.getX1ScaleZoomMax();
                    if (scaleZoomMin != null) {
                        zoomMin = axisObj.getValueCoordForZoom(scaleZoomMin);
                    }
                    if (scaleZoomMax != null) {
                        zoomMax = axisObj.getValueCoordForZoom(scaleZoomMax);
                    }
                    double min4 = bLiveScroll ? axisObj.getValueCoord(this.m_Perspective.getHorzRangeSlider().getZoomMin()) : axisObj.getMinCoord();
                    double max4 = bLiveScroll ? axisObj.getValueCoord(this.m_Perspective.getHorzRangeSlider().getZoomMax()) : axisObj.getMaxCoord();
                    double ratio = (zoomMax - zoomMin) / (max4 - min4);
                    newZoomRatio = ChartFrameZoom.getNextIncrZoomOutRatio(ratio);
                }
            } else if (!(ch.m_O1Axis == null || this.m_Perspective.isContinuousTimeAxis() || (zoomedAxes & 8) <= 0 || (double)(nXCoord = !gt.isOrientHorz() ? x : y) > (max = (min = (double)((Axis2DObj)ch.m_O1Axis).m_axisOrgVC) + (double)((Axis2DObj)ch.m_O1Axis).m_axisLengthVC) || (double)nXCoord < min)) {
                int nLastGroup;
                int nFirstGroup;
                int nScrollOffsetGroup = this.m_Perspective.getEffectiveGroupOffset();
                if (bLiveScroll) {
                    nFirstGroup = 0;
                    nLastGroup = nFirstGroup + this.m_Perspective.getHorzRangeSlider().getZoomViewableGroups() - 1;
                } else if (gt.isOrientHorz()) {
                    nFirstGroup = ch.m_O1Axis.getGroupBelowCoordForZoom((int)max);
                    nLastGroup = ch.m_O1Axis.getGroupAboveCoordForZoom((int)min);
                } else {
                    nFirstGroup = ch.m_O1Axis.getGroupAboveCoordForZoom((int)min);
                    nLastGroup = ch.m_O1Axis.getGroupBelowCoordForZoom((int)max);
                }
                if ((nLastGroup += nScrollOffsetGroup) < (nFirstGroup += nScrollOffsetGroup)) {
                    nLastGroup = nFirstGroup;
                }
                int nViewableGroups = nLastGroup - nFirstGroup + 1;
                double ratio = (double)this.m_Perspective.getNumTotalGroups() / (double)nViewableGroups;
                int newViewableGroups = nViewableGroups;
                while (newViewableGroups < this.m_Perspective.getNumTotalGroups() && newViewableGroups <= nViewableGroups && ratio > ZOOM_RATIOS[0]) {
                    newZoomRatio = ChartFrameZoom.getNextIncrZoomOutRatio(ratio);
                    int[] o1ViewableArray = new int[]{this.m_Perspective.getEffectiveViewableGroups(), this.m_Perspective.getEffectiveViewableSeries()};
                    int[] o1ScrollOffsetArray = new int[]{this.m_Perspective.getEffectiveGroupOffset(), this.m_Perspective.getEffectiveSeriesOffset()};
                    this.doZoomO1(o1ViewableArray, o1ScrollOffsetArray, x, y, newZoomRatio, false);
                    newViewableGroups = o1ViewableArray[0];
                    ratio = newZoomRatio;
                }
            }
            if (newZoomRatio > -1.0) {
                this.doZoom(zoomState, x, y, newZoomRatio, bApply, zoomedAxes);
            }
        }
    }

    protected void doZoomOut(ZoomState zoomState, Rectangle zoomRect, boolean bApply) {
        boolean bLiveScroll;
        if (zoomRect.width < 0 && zoomRect.height < 0) {
            int zoomedAxes = 255;
            if (this.m_Perspective.getZoomDirection() == 1) {
                zoomedAxes = 9;
            } else if (this.m_Perspective.getZoomDirection() == 2) {
                zoomedAxes = 6;
            }
            this.doZoomOut(zoomState, zoomRect.x, zoomRect.y, bApply, zoomedAxes);
            return;
        }
        JGraphType gt = this.m_Perspective.getJGraphType();
        AxisDescriptor ad = gt.getAxisDescriptor();
        int[] o1ViewableArray = new int[]{this.m_Perspective.getEffectiveViewableGroups(), this.m_Perspective.getEffectiveViewableSeries()};
        int[] o1ScrollOffsetArray = new int[]{this.m_Perspective.getEffectiveGroupOffset(), this.m_Perspective.getEffectiveSeriesOffset()};
        double[] x1MinMaxArray = new double[]{0.0, 0.0};
        boolean[] x1AutoMinMaxArray = new boolean[]{false, false};
        double[] y1MinMaxArray = new double[]{0.0, 0.0};
        boolean[] y1AutoMinMaxArray = new boolean[]{false, false};
        double[] y2MinMaxArray = new double[]{0.0, 0.0};
        boolean[] y2AutoMinMaxArray = new boolean[]{false, false};
        boolean bl = bLiveScroll = this.m_Perspective.getZoomAndScroll() == 0;
        if (ChartFrameZoom.isZoomAllowed(this.m_Chart)) {
            JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
            if (ch.m_X1Axis != null) {
                this.doZoomOutNumericAxis(x1MinMaxArray, x1AutoMinMaxArray, zoomRect, ch.m_X1Axis, this.m_Perspective.getX1ScaleMinAutoValue(), this.m_Perspective.getX1ScaleMaxAutoValue());
            }
            if (ch.m_O1Axis != null && this.m_Perspective.isContinuousTimeAxis()) {
                this.doZoomOutNumericAxis(x1MinMaxArray, x1AutoMinMaxArray, zoomRect, ch.m_O1Axis, this.m_Perspective.getX1ScaleMinAutoValue(), this.m_Perspective.getX1ScaleMaxAutoValue());
            }
            if (ch.m_Y1Axis != null) {
                this.doZoomOutNumericAxis(y1MinMaxArray, y1AutoMinMaxArray, zoomRect, ch.m_Y1Axis, this.m_Perspective.getY1ScaleMinAutoValue(), this.m_Perspective.getY1ScaleMaxAutoValue());
            }
            if (ch.m_Y2Axis != null) {
                this.doZoomOutNumericAxis(y2MinMaxArray, y2AutoMinMaxArray, zoomRect, ch.m_Y2Axis, this.m_Perspective.getY2ScaleMinAutoValue(), this.m_Perspective.getY2ScaleMaxAutoValue());
            }
            if (ch.m_O1Axis != null && !this.m_Perspective.isContinuousTimeAxis()) {
                this.doZoomOutO1(o1ViewableArray, o1ScrollOffsetArray, zoomRect, bApply);
            }
            zoomState.ChartFrame(x1MinMaxArray[0], x1MinMaxArray[1], y1MinMaxArray[0], y1MinMaxArray[1], y2MinMaxArray[0], y2MinMaxArray[1], o1ViewableArray[0], o1ScrollOffsetArray[0], o1ViewableArray[1], o1ScrollOffsetArray[1], ad, x1AutoMinMaxArray[0], x1AutoMinMaxArray[1], y1AutoMinMaxArray[0], y1AutoMinMaxArray[1], y2AutoMinMaxArray[0], y2AutoMinMaxArray[1], 255);
        }
    }

    protected void doZoomOutO1(int[] viewableArray, int[] scrollOffsetArray, Rectangle zoomRect, boolean bApply) {
        int nLastGroup;
        int nFirstGroup;
        JGraphType gt = this.m_Perspective.getJGraphType();
        Rectangle rFrame = new Rectangle(this.m_Perspective.getFrameRect(false));
        double xZpct = (double)zoomRect.width * 1.0 / (double)rFrame.width;
        double yZpct = (double)zoomRect.height * 1.0 / (double)rFrame.height;
        double absMinX = rFrame.x;
        double absMaxX = rFrame.x + rFrame.width;
        double absMinY = rFrame.y;
        double absMaxY = rFrame.y + rFrame.height;
        int nViewableGroups = this.m_Perspective.getEffectiveViewableGroups();
        int nViewableSeries = this.m_Perspective.getEffectiveViewableSeries();
        int nScrollOffsetGroup = this.m_Perspective.getEffectiveGroupOffset();
        int nScrollOffsetSeries = this.m_Perspective.getEffectiveSeriesOffset();
        if (this.m_Perspective.getZoomAndScroll() == 0 && this.m_Perspective.getHorzRangeSlider() != null) {
            nViewableGroups = this.m_Perspective.getHorzRangeSlider().getZoomViewableGroups();
        }
        if (ChartFrameZoom.isZoomAllowed(this.m_Chart)) {
            JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
            if (ch.m_O1Axis != null) {
                double min = ((Axis2DObj)ch.m_O1Axis).m_axisOrgVC;
                double max = min + (double)((Axis2DObj)ch.m_O1Axis).m_axisLengthVC;
                if (gt.isOrientHorz()) {
                    nFirstGroup = ch.m_O1Axis.getGroupBelowCoordForZoom((int)max);
                    nLastGroup = ch.m_O1Axis.getGroupAboveCoordForZoom((int)min);
                } else {
                    nFirstGroup = ch.m_O1Axis.getGroupAboveCoordForZoom((int)min);
                    nLastGroup = ch.m_O1Axis.getGroupBelowCoordForZoom((int)max);
                }
                if ((nLastGroup += nScrollOffsetGroup) < (nFirstGroup += nScrollOffsetGroup)) {
                    nLastGroup = nFirstGroup;
                }
                nViewableGroups = nLastGroup - nFirstGroup + 1;
                nScrollOffsetGroup = nFirstGroup;
                double coordsPerGroup = (max - min) / (double)nViewableGroups;
                double ratio = (double)this.m_Perspective.getNumTotalGroups() / (double)nViewableGroups;
                if (gt.isOrientHorz()) {
                    yZpct = (double)zoomRect.height * 1.0 / (max - min);
                    yZpct *= ratio - 1.0;
                    rFrame.height = (int)(max - min);
                    absMinY = max + coordsPerGroup * (double)nFirstGroup;
                    absMaxY = min - coordsPerGroup * (double)(this.m_Perspective.getNumTotalGroups() - 1 - nLastGroup);
                } else {
                    xZpct = (double)zoomRect.width * 1.0 / (max - min);
                    xZpct *= ratio - 1.0;
                    rFrame.width = (int)(max - min);
                    absMinX = min - coordsPerGroup * (double)nFirstGroup;
                    absMaxX = max + coordsPerGroup * (double)(this.m_Perspective.getNumTotalGroups() - 1 - nLastGroup);
                }
            }
        }
        int xCenter = zoomRect.x + zoomRect.width / 2;
        int yCenter = zoomRect.y + zoomRect.height / 2;
        int newWidth = (int)((double)rFrame.width * (1.0 + xZpct));
        int newHeight = (int)((double)rFrame.height * (1.0 + yZpct));
        int newX = xCenter - newWidth / 2;
        int newY = yCenter - newHeight / 2;
        if ((double)newX < absMinX && (double)(newX + newWidth) <= absMaxX) {
            newX = (int)absMinX;
        } else if ((double)(newX + newWidth) > absMaxX && (double)newX >= absMinX) {
            int diffX = (int)((double)(newX + newWidth) - absMaxX);
            newX -= diffX;
        }
        if ((double)newY < absMinY && (double)(newY + newHeight) <= absMaxY) {
            newY = (int)absMinY;
        } else if ((double)(newY + newHeight) > absMaxY && (double)newY >= absMinY) {
            int diffY = (int)((double)(newY + newHeight) - absMaxY);
            newY -= diffY;
        }
        Rectangle rZoom = new Rectangle(newX, newY, newWidth, newHeight);
        if (ChartFrameZoom.isZoomAllowed(this.m_Chart)) {
            JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
            AxisDescriptor ad = gt.getAxisDescriptor();
            if (ch.m_O1Axis != null) {
                if (gt.isOrientHorz()) {
                    nFirstGroup = ch.m_O1Axis.getGroupBelowCoordForZoom(newY + newHeight);
                    nLastGroup = ch.m_O1Axis.getGroupAboveCoordForZoom(newY);
                } else {
                    nFirstGroup = ch.m_O1Axis.getGroupAboveCoordForZoom(newX);
                    nLastGroup = ch.m_O1Axis.getGroupBelowCoordForZoom(newX + newWidth);
                }
                if ((nLastGroup += nScrollOffsetGroup) < (nFirstGroup += nScrollOffsetGroup)) {
                    nLastGroup = nFirstGroup;
                }
                nViewableGroups = nLastGroup - nFirstGroup + 1;
                nScrollOffsetGroup = nFirstGroup;
                if (nViewableGroups == this.m_Perspective.getNumTotalGroups()) {
                    nViewableGroups = 0;
                }
                viewableArray[0] = nViewableGroups;
                scrollOffsetArray[0] = nScrollOffsetGroup;
                if (bApply) {
                    this.m_Perspective.setViewableGroups(nViewableGroups);
                    this.m_Perspective.setScrollOffsetGroup(nScrollOffsetGroup);
                }
            }
            if (ch instanceof JChart_2D_Spec) {
                JChart_2D_Spec chSpec = (JChart_2D_Spec)ch;
                if (chSpec.m_O2Axis != null) {
                    int nFirstSeries = chSpec.m_O2Axis.getGroupAboveCoord(rZoom.y);
                    int nLastSeries = chSpec.m_O2Axis.getGroupBelowCoord(rZoom.y + rZoom.height);
                    if ((nLastSeries += nScrollOffsetSeries) < (nFirstSeries += nScrollOffsetSeries)) {
                        nLastSeries = nFirstSeries;
                    }
                    nViewableSeries = nLastSeries - nFirstSeries + 1;
                    nScrollOffsetSeries = nFirstSeries;
                    viewableArray[1] = nViewableSeries;
                    scrollOffsetArray[1] = nScrollOffsetSeries;
                    if (bApply) {
                        this.m_Perspective.setViewableSeries(nViewableSeries);
                        this.m_Perspective.setScrollOffsetSeries(nScrollOffsetSeries);
                    }
                }
            }
        }
    }

    protected void doZoomOutNumericAxis(double[] minMaxArray, boolean[] bAutoMinMaxArray, Rectangle zoomRect, RelativeAxisObj relAxisObj, double minAutoValue, double maxAutoValue) {
        Rectangle rFrame = new Rectangle(this.m_Perspective.getFrameRect(false));
        double xZpct = (double)zoomRect.width * 1.0 / (double)rFrame.width;
        double yZpct = (double)zoomRect.height * 1.0 / (double)rFrame.height;
        double absMinX = rFrame.x;
        double absMaxX = rFrame.x + rFrame.width;
        double absMinY = rFrame.y;
        double absMaxY = rFrame.y + rFrame.height;
        if (ChartFrameZoom.isZoomAllowed(this.m_Chart) && relAxisObj != null) {
            double autoMin = relAxisObj.getValueCoordForZoom(minAutoValue);
            double autoMax = relAxisObj.getValueCoordForZoom(maxAutoValue);
            if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && relAxisObj.getAutoMinMaxArray() != null) {
                autoMin = relAxisObj.getValueCoordForZoom(relAxisObj.getAutoMinMaxArray()[0]);
                autoMax = relAxisObj.getValueCoordForZoom(relAxisObj.getAutoMinMaxArray()[1]);
            }
            double min = relAxisObj.getMinCoord();
            double max = relAxisObj.getMaxCoord();
            double ratio = (autoMax - autoMin) / (max - min);
            if (!relAxisObj.isVertical()) {
                xZpct = (double)zoomRect.width * 1.0 / (max - min);
                xZpct *= ratio - 1.0;
                rFrame.width = (int)(max - min);
                absMinX = autoMin;
                absMaxX = autoMax;
            } else {
                yZpct = (double)zoomRect.height * 1.0 / (max - min);
                yZpct *= ratio - 1.0;
                rFrame.height = (int)(max - min);
                absMinY = autoMin;
                absMaxY = autoMax;
            }
        }
        int xCenter = zoomRect.x + zoomRect.width / 2;
        int yCenter = zoomRect.y + zoomRect.height / 2;
        int newWidth = (int)((double)rFrame.width * (1.0 + xZpct));
        int newHeight = (int)((double)rFrame.height * (1.0 + yZpct));
        int newX = xCenter - newWidth / 2;
        int newY = yCenter - newHeight / 2;
        if ((double)newX < absMinX && (double)(newX + newWidth) <= absMaxX) {
            newX = (int)absMinX;
        } else if ((double)(newX + newWidth) > absMaxX && (double)newX >= absMinX) {
            int diffX = (int)((double)(newX + newWidth) - absMaxX);
            newX -= diffX;
        }
        if ((double)newY < absMinY && (double)(newY + newHeight) <= absMaxY) {
            newY = (int)absMinY;
        } else if ((double)(newY + newHeight) > absMaxY && (double)newY >= absMinY) {
            int diffY = (int)((double)(newY + newHeight) - absMaxY);
            newY -= diffY;
        }
        Rectangle rZoom = new Rectangle(newX, newY, newWidth, newHeight);
        double fMin = 0.0;
        double fMax = 0.0;
        boolean bAutoMin = false;
        boolean bAutoMax = false;
        if (ChartFrameZoom.isZoomAllowed(this.m_Chart) && relAxisObj != null) {
            int nMaxCoord;
            int nMinCoord;
            if (relAxisObj.isVertical()) {
                nMinCoord = rZoom.y;
                nMaxCoord = rZoom.y + rZoom.height;
            } else {
                nMinCoord = rZoom.x;
                nMaxCoord = rZoom.x + rZoom.width;
            }
            double autoMin = minAutoValue;
            double autoMax = maxAutoValue;
            if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && relAxisObj.getAutoMinMaxArray() != null) {
                autoMin = relAxisObj.getAutoMinMaxArray()[0];
                autoMax = relAxisObj.getAutoMinMaxArray()[1];
            }
            if ((fMin = relAxisObj.getValueFromCoord(nMinCoord)) < autoMin) {
                fMin = autoMin;
            }
            if (this._almostEquals(fMin, autoMin, autoMax - autoMin)) {
                bAutoMin = true;
            }
            if ((fMax = relAxisObj.getValueFromCoord(nMaxCoord)) > autoMax) {
                fMax = autoMax;
            }
            if (this._almostEquals(fMax, autoMax, autoMax - autoMin)) {
                bAutoMax = true;
            }
            minMaxArray[0] = fMin;
            minMaxArray[1] = fMax;
            bAutoMinMaxArray[0] = bAutoMin;
            bAutoMinMaxArray[1] = bAutoMax;
        }
    }

    protected void doZoomOut(ZoomState zoomState, String axis, boolean bApply) {
        boolean bLiveScroll;
        JGraphType gt = this.m_Perspective.getJGraphType();
        JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
        boolean bl = bLiveScroll = this.m_Perspective.getZoomAndScroll() == 0;
        if (axis.equalsIgnoreCase(O1AXIS_ID) && ch.m_O1Axis != null && !this.m_Perspective.isContinuousTimeAxis()) {
            double minCoord = ((Axis2DObj)ch.m_O1Axis).m_axisOrgVC;
            double maxCoord = minCoord + (double)((Axis2DObj)ch.m_O1Axis).m_axisLengthVC;
            if (bLiveScroll) {
                int start = this.m_Perspective.getHorzRangeSlider().getZoomOffsetGroup();
                int count = this.m_Perspective.getHorzRangeSlider().getZoomViewableGroups();
                int coordPerGroup = (int)(maxCoord - minCoord) / this.m_Perspective.getNumTotalGroups();
                maxCoord = (minCoord += (double)(start * coordPerGroup)) + (double)(count * coordPerGroup);
            }
            int centerCoord = (int)(minCoord + (maxCoord - minCoord) / 2.0);
            if (gt.isOrientHorz()) {
                this.doZoomOut(zoomState, 0, centerCoord, bApply, 8);
            } else {
                this.doZoomOut(zoomState, centerCoord, 0, bApply, 8);
            }
        } else if (axis.equalsIgnoreCase(X1AXIS_ID) && (ch.m_X1Axis != null || ch.m_O1Axis != null && this.m_Perspective.isContinuousTimeAxis())) {
            RelativeAxisObj axisObj = ch.m_X1Axis;
            if (axisObj == null) {
                axisObj = ch.m_O1Axis;
            }
            double minCoord = bLiveScroll ? axisObj.getValueCoord(this.m_Perspective.getHorzRangeSlider().getZoomMin()) : axisObj.getMinCoord();
            double maxCoord = bLiveScroll ? axisObj.getValueCoord(this.m_Perspective.getHorzRangeSlider().getZoomMax()) : axisObj.getMaxCoord();
            int centerCoord = (int)(minCoord + (maxCoord - minCoord) / 2.0);
            if (gt.isOrientHorz()) {
                this.doZoomOut(zoomState, 0, centerCoord, bApply, 1);
            } else {
                this.doZoomOut(zoomState, centerCoord, 0, bApply, 1);
            }
        } else if (axis.equalsIgnoreCase(Y1AXIS_ID) && ch.m_Y1Axis != null) {
            double minCoord = bLiveScroll ? ch.m_Y1Axis.getValueCoord(this.m_Perspective.getY1RangeSlider().getZoomMin()) : ch.m_Y1Axis.getMinCoord();
            double maxCoord = bLiveScroll ? ch.m_Y1Axis.getValueCoord(this.m_Perspective.getY1RangeSlider().getZoomMax()) : ch.m_Y1Axis.getMaxCoord();
            int centerCoord = (int)(minCoord + (maxCoord - minCoord) / 2.0);
            if (gt.isOrientHorz()) {
                this.doZoomOut(zoomState, centerCoord, 0, bApply, 2);
            } else {
                this.doZoomOut(zoomState, 0, centerCoord, bApply, 2);
            }
        } else if (axis.equalsIgnoreCase(Y2AXIS_ID) && ch.m_Y2Axis != null) {
            double minCoord = bLiveScroll ? ch.m_Y2Axis.getValueCoord(this.m_Perspective.getY2RangeSlider().getZoomMin()) : ch.m_Y2Axis.getMinCoord();
            double maxCoord = bLiveScroll ? ch.m_Y2Axis.getValueCoord(this.m_Perspective.getY2RangeSlider().getZoomMax()) : ch.m_Y2Axis.getMaxCoord();
            int centerCoord = (int)(minCoord + (maxCoord - minCoord) / 2.0);
            if (gt.isOrientHorz()) {
                this.doZoomOut(zoomState, centerCoord, 0, bApply, 4);
            } else {
                this.doZoomOut(zoomState, 0, centerCoord, bApply, 4);
            }
        }
    }

    public void doZoomOut(ZoomState zoomState, int x, int y) {
        JGraphType gt = this.m_Perspective.getJGraphType();
        Rectangle rFrame = this.m_Perspective.getFrameRect(false);
        double zpct = this.m_Perspective.getZoomPercentage();
        PfjAssert.pfjAssert(zpct >= 20.0 && zpct <= 100.0);
        int newWidth = (int)((double)rFrame.width * 100.0 / zpct);
        int newHeight = (int)((double)rFrame.height * 100.0 / zpct);
        int newX = x - newWidth / 2;
        int newY = y - newHeight / 2;
        Rectangle rZoom = new Rectangle(newX, newY, newWidth, newHeight);
        double fMin_X1 = 0.0;
        double fMin_Y1 = 0.0;
        double fMin_Y2 = 0.0;
        double fMax_X1 = 0.0;
        double fMax_Y1 = 0.0;
        double fMax_Y2 = 0.0;
        int nViewableGroups = this.m_Perspective.getEffectiveViewableGroups();
        int nViewableSeries = this.m_Perspective.getEffectiveViewableSeries();
        int nScrollOffsetGroup = this.m_Perspective.getEffectiveGroupOffset();
        int nScrollOffsetSeries = this.m_Perspective.getEffectiveSeriesOffset();
        if (this.m_Chart != null && this.m_Chart instanceof JChart_2D_BLA || this.m_Chart instanceof JChart_2D_Scat) {
            int nYMaxCoord;
            int nYMinCoord;
            JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
            AxisDescriptor ad = gt.getAxisDescriptor();
            if (ch.m_X1Axis != null || ch.m_O1Axis != null && this.m_Perspective.isContinuousTimeAxis()) {
                int nXMaxCoord;
                int nXMinCoord;
                RelativeAxisObj axisObj = ch.m_X1Axis;
                if (axisObj == null) {
                    axisObj = ch.m_O1Axis;
                }
                if (gt.isOrientHorz()) {
                    nXMinCoord = rZoom.y;
                    nXMaxCoord = rZoom.y + rZoom.height;
                } else {
                    nXMinCoord = rZoom.x;
                    nXMaxCoord = rZoom.x + rZoom.width;
                }
                fMin_X1 = (double)nXMinCoord <= axisObj.getMinCoord() ? axisObj.getMinValue() : axisObj.getValueFromCoord(nXMinCoord);
                fMax_X1 = (double)nXMaxCoord >= axisObj.getMaxCoord() ? axisObj.getMaxValue() : axisObj.getValueFromCoord(nXMaxCoord);
            }
            if (gt.isOrientHorz()) {
                nYMinCoord = rZoom.x;
                nYMaxCoord = rZoom.x + rZoom.width;
            } else {
                nYMinCoord = rZoom.y;
                nYMaxCoord = rZoom.y + rZoom.height;
            }
            if (ch.m_Y1Axis != null) {
                fMin_Y1 = (double)nYMinCoord <= ch.m_Y1Axis.getMinCoord() ? ch.m_Y1Axis.getMinValue() : ch.m_Y1Axis.getValueFromCoord(nYMinCoord);
                fMax_Y1 = (double)nYMaxCoord >= ch.m_Y1Axis.getMaxCoord() ? ch.m_Y1Axis.getMaxValue() : ch.m_Y1Axis.getValueFromCoord(nYMaxCoord);
            }
            if (ch.m_Y2Axis != null) {
                fMin_Y2 = (double)rZoom.y <= ch.m_Y2Axis.getMinCoord() ? ch.m_Y2Axis.getMinValue() : ch.m_Y2Axis.getValueFromCoord(nYMinCoord);
                fMax_Y2 = (double)nYMaxCoord >= ch.m_Y2Axis.getMaxCoord() ? ch.m_Y2Axis.getMaxValue() : ch.m_Y2Axis.getValueFromCoord(nYMaxCoord);
            }
            if (ch.m_O1Axis != null && !this.m_Perspective.isContinuousTimeAxis()) {
                int nLastGroup;
                int nFirstGroup;
                if (gt.isOrientHorz()) {
                    nFirstGroup = ch.m_O1Axis.getGroupAboveCoord(rZoom.y);
                    nLastGroup = ch.m_O1Axis.getGroupBelowCoord(rZoom.y + rZoom.height);
                } else {
                    nFirstGroup = ch.m_O1Axis.getGroupAboveCoord(rZoom.x);
                    nLastGroup = ch.m_O1Axis.getGroupBelowCoord(rZoom.x + rZoom.width);
                }
                if ((nLastGroup += nScrollOffsetGroup) < (nFirstGroup += nScrollOffsetGroup)) {
                    nLastGroup = nFirstGroup;
                }
                nViewableGroups = nLastGroup - nFirstGroup + 1;
                nScrollOffsetGroup = nFirstGroup;
                this.m_Perspective.setViewableGroups(nViewableGroups);
                this.m_Perspective.setScrollOffsetGroup(nScrollOffsetGroup);
            }
            if (ch instanceof JChart_2D_Spec) {
                JChart_2D_Spec chSpec = (JChart_2D_Spec)ch;
                if (chSpec.m_O2Axis != null) {
                    int nFirstSeries = chSpec.m_O2Axis.getGroupAboveCoord(rZoom.y);
                    int nLastSeries = chSpec.m_O2Axis.getGroupBelowCoord(rZoom.y + rZoom.height);
                    if ((nLastSeries += nScrollOffsetSeries) < (nFirstSeries += nScrollOffsetSeries)) {
                        nLastSeries = nFirstSeries;
                    }
                    nViewableSeries = nLastSeries - nFirstSeries + 1;
                    nScrollOffsetSeries = nFirstSeries;
                    this.m_Perspective.setViewableSeries(nViewableSeries);
                    this.m_Perspective.setScrollOffsetSeries(nScrollOffsetSeries);
                }
            }
            zoomState.ChartFrame(fMin_X1, fMax_X1, fMin_Y1, fMax_Y1, fMin_Y2, fMax_Y2, nViewableGroups, nScrollOffsetGroup, nViewableSeries, nScrollOffsetSeries, ad);
        }
    }

    protected void doZoom(ZoomState zoomState, int x, int y, double newRatio, boolean bApply, int zoomedAxes) {
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        if ((zoomedAxes & 8) > 0) {
            map.put(new Integer(8), new Double(newRatio));
        }
        if ((zoomedAxes & 1) > 0) {
            map.put(new Integer(1), new Double(newRatio));
        }
        if ((zoomedAxes & 2) > 0) {
            map.put(new Integer(2), new Double(newRatio));
        }
        if ((zoomedAxes & 4) > 0) {
            map.put(new Integer(4), new Double(newRatio));
        }
        this.doZoom(zoomState, x, y, map, bApply, zoomedAxes);
    }

    protected void doZoom(ZoomState zoomState, int x, int y, Map newRatios, boolean bApply, int zoomedAxes) {
        JGraphType gt = this.m_Perspective.getJGraphType();
        AxisDescriptor ad = gt.getAxisDescriptor();
        int[] o1ViewableArray = new int[]{this.m_Perspective.getEffectiveViewableGroups(), this.m_Perspective.getEffectiveViewableSeries()};
        int[] o1ScrollOffsetArray = new int[]{this.m_Perspective.getEffectiveGroupOffset(), this.m_Perspective.getEffectiveSeriesOffset()};
        double[] x1MinMaxArray = new double[]{0.0, 0.0};
        boolean[] x1AutoMinMaxArray = new boolean[]{false, false};
        double[] y1MinMaxArray = new double[]{0.0, 0.0};
        boolean[] y1AutoMinMaxArray = new boolean[]{false, false};
        double[] y2MinMaxArray = new double[]{0.0, 0.0};
        boolean[] y2AutoMinMaxArray = new boolean[]{false, false};
        if (ChartFrameZoom.isZoomAllowed(this.m_Chart)) {
            JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
            Double ratioObj = (Double)newRatios.get(new Integer(1));
            RelativeAxisObj axisObj = ch.m_X1Axis;
            if (axisObj == null && this.m_Perspective.isContinuousTimeAxis()) {
                axisObj = ch.m_O1Axis;
            }
            if ((zoomedAxes & 1) > 0 && ratioObj != null && axisObj != null) {
                this.doZoomNumericAxis(x1MinMaxArray, x1AutoMinMaxArray, x, y, ratioObj, axisObj, this.m_Perspective.getX1ScaleMinAutoValue(), this.m_Perspective.getX1ScaleMaxAutoValue());
            }
            ratioObj = (Double)newRatios.get(new Integer(2));
            if ((zoomedAxes & 2) > 0 && ratioObj != null && ch.m_Y1Axis != null) {
                this.doZoomNumericAxis(y1MinMaxArray, y1AutoMinMaxArray, x, y, ratioObj, ch.m_Y1Axis, this.m_Perspective.getY1ScaleMinAutoValue(), this.m_Perspective.getY1ScaleMaxAutoValue());
            }
            ratioObj = (Double)newRatios.get(new Integer(4));
            if ((zoomedAxes & 4) > 0 && ratioObj != null && ch.m_Y2Axis != null) {
                this.doZoomNumericAxis(y2MinMaxArray, y2AutoMinMaxArray, x, y, ratioObj, ch.m_Y2Axis, this.m_Perspective.getY2ScaleMinAutoValue(), this.m_Perspective.getY2ScaleMaxAutoValue());
            }
            ratioObj = (Double)newRatios.get(new Integer(8));
            if ((zoomedAxes & 8) > 0 && ratioObj != null && ch.m_O1Axis != null && !this.m_Perspective.isContinuousTimeAxis()) {
                this.doZoomO1(o1ViewableArray, o1ScrollOffsetArray, x, y, ratioObj, bApply);
            }
            zoomState.ChartFrame(x1MinMaxArray[0], x1MinMaxArray[1], y1MinMaxArray[0], y1MinMaxArray[1], y2MinMaxArray[0], y2MinMaxArray[1], o1ViewableArray[0], o1ScrollOffsetArray[0], o1ViewableArray[1], o1ScrollOffsetArray[1], ad, x1AutoMinMaxArray[0], x1AutoMinMaxArray[1], y1AutoMinMaxArray[0], y1AutoMinMaxArray[1], y2AutoMinMaxArray[0], y2AutoMinMaxArray[1], zoomedAxes);
        }
    }

    protected void doZoomO1(int[] viewableArray, int[] scrollOffsetArray, int x, int y, double newRatio, boolean bApply) {
        int newHeight;
        int newWidth;
        int nLastGroup;
        int nFirstGroup;
        boolean bLiveScroll;
        JGraphType gt = this.m_Perspective.getJGraphType();
        Rectangle rFrame = new Rectangle(this.m_Perspective.getFrameRect(false));
        double xZpct = 1.0;
        double yZpct = 1.0;
        double absMinX = rFrame.x;
        double absMaxX = rFrame.x + rFrame.width;
        double absMinY = rFrame.y;
        double absMaxY = rFrame.y + rFrame.height;
        int nViewableGroups = this.m_Perspective.getEffectiveViewableGroups();
        int nViewableSeries = this.m_Perspective.getEffectiveViewableSeries();
        int nScrollOffsetGroup = this.m_Perspective.getEffectiveGroupOffset();
        int nScrollOffsetSeries = this.m_Perspective.getEffectiveSeriesOffset();
        JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
        double min = ((Axis2DObj)ch.m_O1Axis).m_axisOrgVC;
        double max = min + (double)((Axis2DObj)ch.m_O1Axis).m_axisLengthVC;
        double coordPerAllGroup = 0.0;
        double coordSkew = 0.0;
        boolean bl = bLiveScroll = this.m_Perspective.getZoomAndScroll() == 0;
        if (bLiveScroll) {
            nViewableGroups = this.m_Perspective.getHorzRangeSlider().getZoomViewableGroups();
            coordPerAllGroup = (max - min) / (double)this.m_Perspective.getNumTotalGroups();
            coordSkew = coordPerAllGroup * (double)(this.m_Perspective.getNumTotalGroups() - nViewableGroups);
        }
        if (ChartFrameZoom.isZoomAllowed(this.m_Chart) && ch.m_O1Axis != null) {
            if (bLiveScroll) {
                nFirstGroup = this.m_Perspective.getHorzRangeSlider().getZoomOffsetGroup();
                nLastGroup = nFirstGroup + this.m_Perspective.getHorzRangeSlider().getZoomViewableGroups() - 1;
            } else {
                if (gt.isOrientHorz()) {
                    nFirstGroup = ch.m_O1Axis.getGroupBelowCoordForZoom((int)max);
                    nLastGroup = ch.m_O1Axis.getGroupAboveCoordForZoom((int)min);
                } else {
                    nFirstGroup = ch.m_O1Axis.getGroupAboveCoordForZoom((int)min);
                    nLastGroup = ch.m_O1Axis.getGroupBelowCoordForZoom((int)max);
                }
                nFirstGroup += nScrollOffsetGroup;
                nLastGroup += nScrollOffsetGroup;
            }
            if (nLastGroup < nFirstGroup) {
                nLastGroup = nFirstGroup;
            }
            nViewableGroups = nLastGroup - nFirstGroup + 1;
            nScrollOffsetGroup = nFirstGroup;
            double coordsPerGroup = (max - min) / (double)nViewableGroups;
            boolean bLineOrArea = false;
            if ((this.m_Perspective.isChartArea() || this.m_Perspective.isChartLine()) && nViewableGroups > 1) {
                bLineOrArea = true;
                coordsPerGroup = (max - min) / (double)(nViewableGroups - 1);
            }
            if (gt.isOrientHorz()) {
                rFrame.height = (int)(max - min);
                absMinY = min - coordsPerGroup * (double)(this.m_Perspective.getNumTotalGroups() - 1 - nLastGroup);
                absMaxY = max + coordsPerGroup * (double)nFirstGroup;
                if (bLineOrArea) {
                    absMinY -= 0.5 * coordsPerGroup;
                    absMaxY += 0.5 * coordsPerGroup;
                }
                yZpct = (absMaxY - absMinY) / (max - min);
                yZpct /= newRatio;
            } else {
                rFrame.width = (int)(max - min);
                absMinX = min - coordsPerGroup * (double)nFirstGroup;
                absMaxX = max + coordsPerGroup * (double)(this.m_Perspective.getNumTotalGroups() - 1 - nLastGroup);
                if (bLineOrArea) {
                    absMinX -= 0.5 * coordsPerGroup;
                    absMaxX += 0.5 * coordsPerGroup;
                }
                xZpct = (absMaxX - absMinX) / (max - min);
                xZpct /= newRatio;
            }
            if (bLineOrArea && bLiveScroll) {
                coordPerAllGroup = (max - min) / (double)(this.m_Perspective.getNumTotalGroups() - 1);
                coordSkew = coordPerAllGroup * (double)(this.m_Perspective.getNumTotalGroups() - nViewableGroups);
            }
            if (!bLiveScroll) {
                coordPerAllGroup = gt.isOrientHorz() ? (absMaxY - absMinY) / (double)this.m_Perspective.getNumTotalGroups() : (absMaxX - absMinX) / (double)this.m_Perspective.getNumTotalGroups();
            }
        }
        int xCenter = x;
        int yCenter = y;
        if (bLiveScroll) {
            if (!gt.isOrientHorz()) {
                newWidth = (int)(((double)rFrame.width - coordSkew) * xZpct);
                newHeight = (int)((double)rFrame.height * yZpct);
            } else {
                newWidth = (int)((double)rFrame.width * xZpct);
                newHeight = (int)(((double)rFrame.height - coordSkew) * yZpct);
            }
        } else {
            newWidth = (int)((double)rFrame.width * xZpct);
            newHeight = (int)((double)rFrame.height * yZpct);
        }
        int newX = xCenter - newWidth / 2;
        int newY = yCenter - newHeight / 2;
        if ((double)newX < absMinX && (double)(newX + newWidth) <= absMaxX) {
            newX = (int)absMinX;
        } else if ((double)(newX + newWidth) > absMaxX && (double)newX >= absMinX) {
            int diffX = (int)((double)(newX + newWidth) - absMaxX);
            newX -= diffX;
        }
        if ((double)newY < absMinY && (double)(newY + newHeight) <= absMaxY) {
            newY = (int)absMinY;
        } else if ((double)(newY + newHeight) > absMaxY && (double)newY >= absMinY) {
            int diffY = (int)((double)(newY + newHeight) - absMaxY);
            newY -= diffY;
        }
        Rectangle rZoom = new Rectangle(newX, newY, newWidth, newHeight);
        if (ChartFrameZoom.isZoomAllowed(this.m_Chart) && ch.m_O1Axis != null) {
            if (gt.isOrientHorz()) {
                if (bLiveScroll) {
                    nFirstGroup = ch.m_O1Axis.getGroupBelowCoordForZoom(newY + newHeight);
                    nLastGroup = ch.m_O1Axis.getGroupAboveCoordForZoom(newY);
                } else {
                    double fGroup = 0.0;
                    fGroup = (absMaxY - (double)(newY + newHeight) - coordPerAllGroup / 2.0) / coordPerAllGroup;
                    nFirstGroup = (int)Math.ceil(fGroup);
                    fGroup = (absMaxY - (double)newY - coordPerAllGroup / 2.0) / coordPerAllGroup;
                    nLastGroup = (int)Math.floor(fGroup);
                }
            } else if (bLiveScroll) {
                nFirstGroup = ch.m_O1Axis.getGroupAboveCoordForZoom(newX);
                nLastGroup = ch.m_O1Axis.getGroupBelowCoordForZoom(newX + newWidth);
            } else {
                double fGroup = 0.0;
                fGroup = ((double)newX - absMinX - coordPerAllGroup / 2.0) / coordPerAllGroup;
                nFirstGroup = (int)Math.ceil(fGroup);
                fGroup = ((double)(newX + newWidth) - absMinX - coordPerAllGroup / 2.0) / coordPerAllGroup;
                nLastGroup = (int)Math.floor(fGroup);
            }
            if (nFirstGroup < 0) {
                nFirstGroup = 0;
            }
            if (nLastGroup >= this.m_Perspective.getNumTotalGroups()) {
                nLastGroup = this.m_Perspective.getNumTotalGroups() - 1;
            }
            if (nLastGroup < nFirstGroup) {
                nLastGroup = nFirstGroup;
            }
            if ((nViewableGroups = nLastGroup - nFirstGroup + 1) < this.m_Perspective.getMinNumGroups()) {
                nViewableGroups = this.m_Perspective.getMinNumGroups();
            }
            nScrollOffsetGroup = nFirstGroup;
            if (nFirstGroup + nViewableGroups > this.m_Perspective.getNumTotalGroups()) {
                nScrollOffsetGroup = this.m_Perspective.getNumTotalGroups() - nViewableGroups;
            }
            if (nViewableGroups == this.m_Perspective.getNumTotalGroups()) {
                nViewableGroups = 0;
            }
            if (bApply) {
                this.m_Perspective.setViewableGroups(nViewableGroups);
                this.m_Perspective.setScrollOffsetGroup(nScrollOffsetGroup);
            }
        }
        viewableArray[0] = nViewableGroups;
        viewableArray[1] = nViewableSeries;
        scrollOffsetArray[0] = nScrollOffsetGroup;
        scrollOffsetArray[1] = nScrollOffsetSeries;
    }

    protected void doZoomNumericAxis(double[] minMaxArray, boolean[] bAutoMinMaxArray, int x, int y, double newRatio, RelativeAxisObj relAxisObj, double minAutoValue, double maxAutoValue) {
        Rectangle rFrame = new Rectangle(this.m_Perspective.getFrameRect(false));
        double xZpct = 1.0;
        double yZpct = 1.0;
        double absMinX = rFrame.x;
        double absMaxX = rFrame.x + rFrame.width;
        double absMinY = rFrame.y;
        double absMaxY = rFrame.y + rFrame.height;
        Double scaleZoomMin = null;
        Double scaleZoomMax = null;
        if (relAxisObj.m_nAxisObjectID == 2004) {
            scaleZoomMin = this.m_Perspective.getY1ScaleZoomMin();
            scaleZoomMax = this.m_Perspective.getY1ScaleZoomMax();
        } else if (relAxisObj.m_nAxisObjectID == 2005) {
            scaleZoomMin = this.m_Perspective.getY2ScaleZoomMin();
            scaleZoomMax = this.m_Perspective.getY2ScaleZoomMax();
        } else if (relAxisObj.m_nAxisObjectID == 2003) {
            scaleZoomMin = this.m_Perspective.getX1ScaleZoomMin();
            scaleZoomMax = this.m_Perspective.getX1ScaleZoomMax();
        }
        boolean bZoomAutoMin = true;
        boolean bZoomAutoMax = true;
        double scaleZoomMinCoord = 0.0;
        double scaleZoomMaxCoord = 0.0;
        if (scaleZoomMin != null) {
            scaleZoomMinCoord = relAxisObj.getValueCoordForZoom(scaleZoomMin);
            bZoomAutoMin = false;
        }
        if (scaleZoomMax != null) {
            scaleZoomMaxCoord = relAxisObj.getValueCoordForZoom(scaleZoomMax);
            bZoomAutoMax = false;
        }
        if (ChartFrameZoom.isZoomAllowed(this.m_Chart)) {
            JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
            if (relAxisObj != null) {
                double zoomMin = relAxisObj.getValueCoordForZoom(minAutoValue);
                double zoomMax = relAxisObj.getValueCoordForZoom(maxAutoValue);
                if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && relAxisObj.getAutoMinMaxArray() != null) {
                    zoomMin = relAxisObj.getValueCoordForZoom(relAxisObj.getAutoMinMaxArray()[0]);
                    zoomMax = relAxisObj.getValueCoordForZoom(relAxisObj.getAutoMinMaxArray()[1]);
                }
                if (!bZoomAutoMin) {
                    zoomMin = scaleZoomMinCoord;
                }
                if (!bZoomAutoMax) {
                    zoomMax = scaleZoomMaxCoord;
                }
                double min = relAxisObj.getMinCoord();
                double max = relAxisObj.getMaxCoord();
                if (!relAxisObj.isVertical()) {
                    xZpct = (zoomMax - zoomMin) / (max - min);
                    xZpct /= newRatio;
                    rFrame.width = (int)(max - min);
                    absMinX = zoomMin;
                    absMaxX = zoomMax;
                } else {
                    yZpct = (zoomMax - zoomMin) / (max - min);
                    yZpct /= newRatio;
                    rFrame.height = (int)(max - min);
                    absMinY = zoomMin;
                    absMaxY = zoomMax;
                }
            }
        }
        int xCenter = x;
        int yCenter = y;
        int newWidth = (int)((double)rFrame.width * xZpct);
        int newHeight = (int)((double)rFrame.height * yZpct);
        int newX = xCenter - newWidth / 2;
        int newY = yCenter - newHeight / 2;
        if ((double)newX < absMinX && (double)(newX + newWidth) <= absMaxX) {
            newX = (int)absMinX;
        } else if ((double)(newX + newWidth) > absMaxX && (double)newX >= absMinX) {
            int diffX = (int)((double)(newX + newWidth) - absMaxX);
            newX -= diffX;
        }
        if ((double)newY < absMinY && (double)(newY + newHeight) <= absMaxY) {
            newY = (int)absMinY;
        } else if ((double)(newY + newHeight) > absMaxY && (double)newY >= absMinY) {
            int diffY = (int)((double)(newY + newHeight) - absMaxY);
            newY -= diffY;
        }
        Rectangle rZoom = new Rectangle(newX, newY, newWidth, newHeight);
        double fMin = 0.0;
        double fMax = 0.0;
        boolean bAutoMin = false;
        boolean bAutoMax = false;
        if (ChartFrameZoom.isZoomAllowed(this.m_Chart)) {
            int nMaxCoord;
            int nMinCoord;
            JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
            if (!relAxisObj.isVertical()) {
                nMinCoord = rZoom.x;
                nMaxCoord = rZoom.x + rZoom.width;
            } else {
                nMinCoord = rZoom.y;
                nMaxCoord = rZoom.y + rZoom.height;
            }
            if (relAxisObj != null) {
                double autoMinVal = minAutoValue;
                double autoMaxVal = maxAutoValue;
                if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && relAxisObj.getAutoMinMaxArray() != null) {
                    autoMinVal = relAxisObj.getAutoMinMaxArray()[0];
                    autoMaxVal = relAxisObj.getAutoMinMaxArray()[1];
                }
                double zoomMinVal = !bZoomAutoMin ? scaleZoomMin : autoMinVal;
                double zoomMaxVal = !bZoomAutoMax ? scaleZoomMax : autoMaxVal;
                fMin = relAxisObj.getValueFromCoord(nMinCoord);
                if (fMin < zoomMinVal) {
                    fMin = zoomMinVal;
                }
                if (this._almostEquals(fMin, autoMinVal, autoMaxVal - autoMinVal)) {
                    bAutoMin = true;
                }
                if ((fMax = relAxisObj.getValueFromCoord(nMaxCoord)) > zoomMaxVal) {
                    fMax = zoomMaxVal;
                }
                if (this._almostEquals(fMax, autoMaxVal, autoMaxVal - autoMinVal)) {
                    bAutoMax = true;
                }
            }
        }
        minMaxArray[0] = fMin;
        minMaxArray[1] = fMax;
        bAutoMinMaxArray[0] = bAutoMin;
        bAutoMinMaxArray[1] = bAutoMax;
    }

    protected void doScroll(ZoomState zoomState, String axis, int count, int start, int span) {
        boolean bAutoMax;
        boolean bAutoMin;
        double newMaxVal;
        double newMinVal;
        int newMax;
        int newMin;
        double range;
        double autoMax;
        double autoMin;
        double autoMaxVal;
        double autoMinVal;
        RelativeAxisObj axisObj;
        JGraphType gt = this.m_Perspective.getJGraphType();
        AxisDescriptor ad = gt.getAxisDescriptor();
        JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
        boolean bLiveScroll = this.m_Perspective.getZoomAndScroll() == 0;
        boolean bAllAxes = axis.equalsIgnoreCase(ALLAXIS_ID);
        int[] o1ViewableArray = new int[]{this.m_Perspective.getEffectiveViewableGroups(), this.m_Perspective.getEffectiveViewableSeries()};
        int[] o1ScrollOffsetArray = new int[]{this.m_Perspective.getEffectiveGroupOffset(), this.m_Perspective.getEffectiveSeriesOffset()};
        double[] x1MinMaxArray = new double[]{0.0, 0.0};
        boolean[] x1AutoMinMaxArray = new boolean[]{false, false};
        double[] y1MinMaxArray = new double[]{0.0, 0.0};
        boolean[] y1AutoMinMaxArray = new boolean[]{false, false};
        double[] y2MinMaxArray = new double[]{0.0, 0.0};
        boolean[] y2AutoMinMaxArray = new boolean[]{false, false};
        int zoomedAxes = 0;
        if (bAllAxes || axis.equalsIgnoreCase(O1AXIS_ID) && ch.m_O1Axis != null && !this.m_Perspective.isContinuousTimeAxis()) {
            zoomedAxes |= 8;
            if (this.m_Perspective.isUseRangeSlider()) {
                int minGroups;
                double coordPerGroup;
                if (this.m_Perspective.isChartArea() || this.m_Perspective.isChartLine()) {
                    coordPerGroup = (double)count / (double)(this.m_Perspective.getNumTotalGroups() - 1);
                    minGroups = 2;
                    if (coordPerGroup != 0.0) {
                        o1ViewableArray[0] = Math.max((int)Math.round((double)span / coordPerGroup) + 1, minGroups);
                        o1ScrollOffsetArray[0] = this.m_Perspective.isChartOrientHorz() ? (int)Math.round((double)(count - span - start) / coordPerGroup) : (int)Math.round((double)start / coordPerGroup);
                    }
                } else {
                    coordPerGroup = (double)count / (double)this.m_Perspective.getNumTotalGroups();
                    minGroups = 1;
                    if (coordPerGroup != 0.0) {
                        o1ViewableArray[0] = Math.max((int)Math.round((double)span / coordPerGroup), minGroups);
                        o1ScrollOffsetArray[0] = this.m_Perspective.isChartOrientHorz() ? (int)((double)(count - span - start) / coordPerGroup) : (int)((double)start / coordPerGroup);
                    }
                }
                if (o1ViewableArray[0] == this.m_Perspective.getNumTotalGroups()) {
                    o1ViewableArray[0] = 0;
                }
                o1ScrollOffsetArray[0] = Math.min(o1ScrollOffsetArray[0], this.m_Perspective.getNumTotalGroups() - minGroups);
            } else {
                int newDisplayGroups = span;
                if (newDisplayGroups == this.m_Perspective.getNumTotalGroups()) {
                    newDisplayGroups = 0;
                }
                o1ViewableArray[0] = newDisplayGroups;
                o1ScrollOffsetArray[0] = start;
            }
            RelativeAxisObj axisObj2 = ch.m_O1Axis;
            if (axisObj2 != null && axisObj2.axisRS != null && bLiveScroll) {
                axisObj2.axisRS.setThumbStart(start);
            }
        }
        if ((bAllAxes || axis.equalsIgnoreCase(X1AXIS_ID)) && (ch.m_X1Axis != null || ch.m_O1Axis != null && this.m_Perspective.isContinuousTimeAxis())) {
            zoomedAxes |= 1;
            double pctMin = (double)start / (double)count;
            double pctMax = (double)(start + span) / (double)count;
            axisObj = ch.m_X1Axis;
            if (axisObj == null) {
                axisObj = ch.m_O1Axis;
            }
            if (axisObj != null) {
                autoMinVal = this.m_Perspective.getX1ScaleMinAutoValue();
                autoMaxVal = this.m_Perspective.getX1ScaleMaxAutoValue();
                if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && axisObj.getAutoMinMaxArray() != null) {
                    autoMinVal = axisObj.getAutoMinMaxArray()[0];
                    autoMaxVal = axisObj.getAutoMinMaxArray()[1];
                }
                if (this.m_Perspective.getX1ScaleZoomMin() != null) {
                    autoMinVal = this.m_Perspective.getX1ScaleZoomMin();
                }
                if (this.m_Perspective.getX1ScaleZoomMax() != null) {
                    autoMaxVal = this.m_Perspective.getX1ScaleZoomMax();
                }
                autoMin = axisObj.getValueCoordForZoom(autoMinVal);
                autoMax = axisObj.getValueCoordForZoom(autoMaxVal);
                range = autoMax - autoMin;
                newMin = (int)Math.round(autoMin + pctMin * range);
                newMax = (int)Math.round(autoMin + pctMax * range);
                newMinVal = axisObj.getValueFromCoord(newMin);
                newMaxVal = axisObj.getValueFromCoord(newMax);
                bAutoMin = false;
                bAutoMax = false;
                if (newMinVal < autoMinVal) {
                    newMinVal = autoMinVal;
                }
                if (newMaxVal > autoMaxVal) {
                    newMaxVal = autoMaxVal;
                }
                if (!bLiveScroll) {
                    if (this._almostEquals(newMinVal, autoMinVal, autoMaxVal - autoMinVal)) {
                        bAutoMin = true;
                    }
                    if (this._almostEquals(newMaxVal, autoMaxVal, autoMaxVal - autoMinVal)) {
                        bAutoMax = true;
                    }
                }
                x1MinMaxArray[0] = newMinVal;
                x1MinMaxArray[1] = newMaxVal;
                x1AutoMinMaxArray[0] = bAutoMin;
                x1AutoMinMaxArray[1] = bAutoMax;
            }
            if (axisObj != null && axisObj.axisRS != null && bLiveScroll) {
                axisObj.axisRS.setThumbStart(start);
            }
        }
        if ((bAllAxes || axis.equalsIgnoreCase(Y1AXIS_ID)) && ch.m_Y1Axis != null) {
            zoomedAxes |= 2;
            double pctMin = (double)start / (double)count;
            double pctMax = (double)(start + span) / (double)count;
            axisObj = ch.m_Y1Axis;
            if (axisObj != null) {
                autoMinVal = this.m_Perspective.getY1ScaleMinAutoValue();
                autoMaxVal = this.m_Perspective.getY1ScaleMaxAutoValue();
                if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && axisObj.getAutoMinMaxArray() != null) {
                    autoMinVal = axisObj.getAutoMinMaxArray()[0];
                    autoMaxVal = axisObj.getAutoMinMaxArray()[1];
                }
                if (this.m_Perspective.getY1ScaleZoomMin() != null) {
                    autoMinVal = this.m_Perspective.getY1ScaleZoomMin();
                }
                if (this.m_Perspective.getY1ScaleZoomMax() != null) {
                    autoMaxVal = this.m_Perspective.getY1ScaleZoomMax();
                }
                autoMin = axisObj.getValueCoordForZoom(autoMinVal);
                autoMax = axisObj.getValueCoordForZoom(autoMaxVal);
                range = autoMax - autoMin;
                newMin = (int)Math.round(autoMin + pctMin * range);
                newMax = (int)Math.round(autoMin + pctMax * range);
                newMinVal = axisObj.getValueFromCoord(newMin);
                newMaxVal = axisObj.getValueFromCoord(newMax);
                bAutoMin = false;
                bAutoMax = false;
                if (newMinVal < autoMinVal) {
                    newMinVal = autoMinVal;
                }
                if (newMaxVal > autoMaxVal) {
                    newMaxVal = autoMaxVal;
                }
                if (!bLiveScroll) {
                    if (start == 0 || this._almostEquals(newMinVal, autoMinVal, autoMaxVal - autoMinVal)) {
                        bAutoMin = true;
                    }
                    if (start + span >= count - 1 || this._almostEquals(newMaxVal, autoMaxVal, autoMaxVal - autoMinVal)) {
                        bAutoMax = true;
                    }
                }
                y1MinMaxArray[0] = newMinVal;
                y1MinMaxArray[1] = newMaxVal;
                y1AutoMinMaxArray[0] = bAutoMin;
                y1AutoMinMaxArray[1] = bAutoMax;
            }
            if (axisObj != null && axisObj.axisRS != null && bLiveScroll) {
                axisObj.axisRS.setThumbStart(start);
            }
        }
        if ((bAllAxes || axis.equalsIgnoreCase(Y2AXIS_ID)) && ch.m_Y2Axis != null) {
            zoomedAxes |= 4;
            double pctMin = (double)start / (double)count;
            double pctMax = (double)(start + span) / (double)count;
            axisObj = ch.m_Y2Axis;
            if (axisObj != null) {
                autoMinVal = this.m_Perspective.getY2ScaleMinAutoValue();
                autoMaxVal = this.m_Perspective.getY2ScaleMaxAutoValue();
                if (this.m_Perspective.isAlwaysCalcAxisAutoMinMax() && axisObj.getAutoMinMaxArray() != null) {
                    autoMinVal = axisObj.getAutoMinMaxArray()[0];
                    autoMaxVal = axisObj.getAutoMinMaxArray()[1];
                }
                if (this.m_Perspective.getY2ScaleZoomMin() != null) {
                    autoMinVal = this.m_Perspective.getY2ScaleZoomMin();
                }
                if (this.m_Perspective.getY2ScaleZoomMax() != null) {
                    autoMaxVal = this.m_Perspective.getY2ScaleZoomMax();
                }
                autoMin = axisObj.getValueCoordForZoom(autoMinVal);
                autoMax = axisObj.getValueCoordForZoom(autoMaxVal);
                range = autoMax - autoMin;
                newMin = (int)Math.round(autoMin + pctMin * range);
                newMax = (int)Math.round(autoMin + pctMax * range);
                newMinVal = axisObj.getValueFromCoord(newMin);
                newMaxVal = axisObj.getValueFromCoord(newMax);
                bAutoMin = false;
                bAutoMax = false;
                if (newMinVal < autoMinVal) {
                    newMinVal = autoMinVal;
                }
                if (newMaxVal > autoMaxVal) {
                    newMaxVal = autoMaxVal;
                }
                if (!bLiveScroll) {
                    if (this._almostEquals(newMinVal, autoMinVal, autoMaxVal - autoMinVal)) {
                        bAutoMin = true;
                    }
                    if (this._almostEquals(newMaxVal, autoMaxVal, autoMaxVal - autoMinVal)) {
                        bAutoMax = true;
                    }
                }
                y2MinMaxArray[0] = newMinVal;
                y2MinMaxArray[1] = newMaxVal;
                y2AutoMinMaxArray[0] = bAutoMin;
                y2AutoMinMaxArray[1] = bAutoMax;
            }
            if (axisObj != null && axisObj.axisRS != null && bLiveScroll) {
                axisObj.axisRS.setThumbStart(start);
            }
        }
        zoomState.ChartFrame(x1MinMaxArray[0], x1MinMaxArray[1], y1MinMaxArray[0], y1MinMaxArray[1], y2MinMaxArray[0], y2MinMaxArray[1], o1ViewableArray[0], o1ScrollOffsetArray[0], o1ViewableArray[1], o1ScrollOffsetArray[1], ad, x1AutoMinMaxArray[0], x1AutoMinMaxArray[1], y1AutoMinMaxArray[0], y1AutoMinMaxArray[1], y2AutoMinMaxArray[0], y2AutoMinMaxArray[1], zoomedAxes);
    }

    protected static double getNextIncrZoomInRatio(double ratio) {
        int iRatio = (int)(ratio * 100.0);
        ratio = (double)iRatio / 100.0;
        int index = -1;
        for (int i = 0; i < ZOOM_RATIOS.length; ++i) {
            double adjZoomRatio = ZOOM_RATIOS[i] * 0.975;
            if (!(adjZoomRatio > ratio)) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return ratio;
        }
        return ZOOM_RATIOS[index];
    }

    protected static double getNextIncrZoomOutRatio(double ratio) {
        int iRatio = (int)(ratio * 100.0);
        ratio = (double)iRatio / 100.0;
        int index = -1;
        for (int i = ZOOM_RATIOS.length - 1; i >= 0; --i) {
            if (!(ZOOM_RATIOS[i] < ratio)) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return ratio;
        }
        return ZOOM_RATIOS[index];
    }

    private boolean _almostEquals(double val1, double val2, double range) {
        return Math.abs(val1 - val2) <= 0.01 * Math.abs(range);
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

