/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.managers;

import java.util.Vector;
import oracle.adf.share.mt.util.MultiTenantStorage;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.managers.RuleManager;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.graph.GraphFormatManager;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.ResolutionService;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.RuleContext;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.QDR;
import oracle.dss.util.format.DvtNumberConverter;
import oracle.dss.util.xml.ObjectNode;
import oracle.javatools.annotations.Concealed;

@Concealed
public class GraphRuleFormatter
extends RuleManager
implements GraphFormatManager {
    private static final long serialVersionUID = 1L;
    protected ViewFormat m_viewFormat;
    private boolean useViewFormatPool;
    private static MultiTenantStorage<ViewFormatPool> viewFormatPool = new MultiTenantStorage<ViewFormatPool>(){

        protected ViewFormatPool initialValue() {
            return new ViewFormatPool();
        }
    };

    public GraphRuleFormatter() {
        this.useViewFormatPool = true;
    }

    public GraphRuleFormatter(boolean usePool) {
        this.useViewFormatPool = usePool;
    }

    @Override
    public void dataSourceChanged() {
    }

    private int _getPowerOfTen(double dValue) {
        int power;
        block5: {
            double testValue;
            block4: {
                power = 0;
                if (testValue < 1.0E-15) {
                    return 0;
                }
                if (testValue == Double.POSITIVE_INFINITY) {
                    return Integer.MAX_VALUE;
                }
                if (!(testValue >= 10.0)) break block4;
                for (testValue = dValue >= 0.0 ? dValue : -dValue; testValue >= 10.0; testValue /= 10.0) {
                    ++power;
                }
                break block5;
            }
            if (!(testValue < 1.0)) break block5;
            while (testValue < 1.0) {
                --power;
                testValue *= 10.0;
            }
        }
        return power;
    }

    private int _getScaleFactorPowerOfTen(int scaleFactor) {
        switch (scaleFactor) {
            case 1: {
                return 3;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 9;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 15;
            }
        }
        return 0;
    }

    @Override
    public String formatAxisValue(double data, ViewFormat componentFormat, double maxValue, double minValue, int axisID, boolean isPercent) {
        ViewFormat format = null;
        ViewFormat defaultFormat = ((ViewFormatPool)viewFormatPool.get()).getInstance(this.useViewFormatPool);
        if (defaultFormat.getNumberConverter() instanceof DvtNumberConverter) {
            return "";
        }
        double absMax = minValue < 0.0 && -minValue > maxValue ? -minValue : maxValue;
        int power = this._getPowerOfTen(absMax);
        if (isPercent) {
            power += 2;
            defaultFormat.setNumberType(2);
        } else if (power <= 1) {
            defaultFormat.setScaleFactor(0);
            defaultFormat.setDecimalDigit(1 - power);
        } else if (power >= 16) {
            defaultFormat.setScaleFactor(5);
            defaultFormat.setDecimalDigit(0);
        } else {
            switch ((power - 1) / 3 * 3) {
                case 3: {
                    defaultFormat.setScaleFactor(1);
                    break;
                }
                case 6: {
                    defaultFormat.setScaleFactor(2);
                    break;
                }
                case 9: {
                    defaultFormat.setScaleFactor(3);
                    break;
                }
                case 12: {
                    defaultFormat.setScaleFactor(4);
                    break;
                }
                case 15: {
                    defaultFormat.setScaleFactor(5);
                    break;
                }
                default: {
                    defaultFormat.setScaleFactor(0);
                }
            }
            defaultFormat.setDecimalDigit(0);
        }
        defaultFormat.merge((Mergeable)componentFormat);
        defaultFormat.setView(componentFormat.getView());
        defaultFormat.setLocale(componentFormat.getLocale());
        try {
            Vector bundles = this.getBundles();
            if (bundles != null) {
                RuleContext context = new RuleContext();
                context.put((Object)"NUMBER_VALUE", (Object)new Double(data));
                context.put((Object)"COMPONENT_TYPE", (Object)new Integer(axisID));
                context.put((Object)"ISPERCENT", (Object)isPercent);
                format = (ViewFormat)ResolutionService.resolveRules((RuleContext)context, (Mergeable)defaultFormat, (Vector)bundles);
            }
        }
        catch (ClassCastException e) {
            return new Double(data).toString();
        }
        if (format == null) {
            ((ViewFormatPool)viewFormatPool.get()).releaseInstance(defaultFormat, this.useViewFormatPool);
            return new Double(data).toString();
        }
        String ret = format.DoubleToString(data);
        ((ViewFormatPool)viewFormatPool.get()).releaseInstance(defaultFormat, this.useViewFormatPool);
        return ret;
    }

    @Override
    public String formatAxisValue(double data, ViewFormat componentFormat, double maxValue, double minValue, double tickStep, int axisID, boolean isPercent, boolean bLogScale, double logBase) {
        boolean bUseDefaultDecimalDigit;
        ViewFormat initFormat;
        ViewFormat defaultFormat = ((ViewFormatPool)viewFormatPool.get()).getInstance(this.useViewFormatPool);
        if (isPercent && !(defaultFormat.getNumberConverter() instanceof DvtNumberConverter)) {
            defaultFormat.setNumberType(2);
        }
        defaultFormat.merge((Mergeable)componentFormat);
        defaultFormat.setView(componentFormat.getView());
        defaultFormat.setLocale(componentFormat.getLocale());
        RuleContext context = new RuleContext();
        context.put((Object)"NUMBER_VALUE", (Object)new Double(data));
        context.put((Object)"COMPONENT_TYPE", (Object)new Integer(axisID));
        context.put((Object)"ISPERCENT", (Object)isPercent);
        ViewFormat format = initFormat = defaultFormat;
        try {
            if (this.m_bundles != null) {
                initFormat = format = (ViewFormat)ResolutionService.resolveRules((RuleContext)context, (Mergeable)initFormat, (Vector)this.m_bundles);
            }
            if (this.m_uiBundle != null && initFormat != null) {
                format = (ViewFormat)ResolutionService.resolveRules((RuleContext)context, (Mergeable)initFormat, (RuleBundle)this.m_uiBundle);
            }
        }
        catch (ClassCastException e) {
            return new Double(data).toString();
        }
        if (format == null) {
            return new Double(data).toString();
        }
        boolean bUseDefaultScaleFactor = !format.isScaleFactorUsed();
        boolean bl = bUseDefaultDecimalDigit = !format.isDecimalDigitUsed();
        if (!isPercent && (bUseDefaultScaleFactor || bUseDefaultDecimalDigit)) {
            if (!bLogScale) {
                this.formatLinearScaleAxisValue(minValue, maxValue, tickStep, format, bUseDefaultScaleFactor, bUseDefaultDecimalDigit);
            } else {
                this.formatLogScaleAxisValue(logBase, data, format, bUseDefaultScaleFactor, bUseDefaultDecimalDigit);
            }
        }
        String ret = format.DoubleToString(data);
        ((ViewFormatPool)viewFormatPool.get()).releaseInstance(defaultFormat, this.useViewFormatPool);
        return ret;
    }

    protected void formatLinearScaleAxisValue(double minValue, double maxValue, double tickStep, ViewFormat format, boolean bUseDefaultScaleFactor, boolean bUseDefaultDecimalDigit) {
        double absMax = minValue < 0.0 && -minValue > maxValue ? -minValue : maxValue;
        int power = this._getPowerOfTen(absMax);
        DvtNumberConverter converter = null;
        if (format.getNumberConverter() != null && format.getNumberConverter() instanceof DvtNumberConverter) {
            converter = (DvtNumberConverter)format.getNumberConverter();
        }
        int scaleFactor = format.getScaleFactor();
        int decimalPlaces = converter == null ? format.getDecimalDigit() : 2;
        if (bUseDefaultScaleFactor) {
            if (power <= 1) {
                scaleFactor = 0;
            } else if (power >= 16) {
                scaleFactor = 5;
            } else {
                int scaleFactorPower = (power - 1) / 3 * 3;
                switch (scaleFactorPower) {
                    case 3: {
                        scaleFactor = 1;
                        break;
                    }
                    case 6: {
                        scaleFactor = 2;
                        break;
                    }
                    case 9: {
                        scaleFactor = 3;
                        break;
                    }
                    case 12: {
                        scaleFactor = 4;
                        break;
                    }
                    case 15: {
                        scaleFactor = 5;
                        break;
                    }
                    default: {
                        scaleFactor = 0;
                    }
                }
            }
        }
        if (bUseDefaultDecimalDigit) {
            double scaledMinVal;
            int tickStepPowerOfTen;
            int scaleFactorPowerOfTen = this._getScaleFactorPowerOfTen(scaleFactor);
            decimalPlaces = scaleFactorPowerOfTen - (tickStepPowerOfTen = this._getPowerOfTen(tickStep));
            if (decimalPlaces < 0) {
                decimalPlaces = 0;
            }
            double scaledTickStep = tickStep;
            double d = scaledMinVal = minValue < maxValue ? minValue : maxValue;
            if (scaleFactorPowerOfTen > 0) {
                scaledTickStep *= Math.pow(10.0, -scaleFactorPowerOfTen);
                scaledMinVal *= Math.pow(10.0, -scaleFactorPowerOfTen);
            }
            double targetLevOfPrec = 1.0;
            if (decimalPlaces > 0) {
                targetLevOfPrec = Math.pow(10.0, -decimalPlaces);
            }
            double nearestStepAtTLOP = Math.rint(scaledTickStep / targetLevOfPrec) * targetLevOfPrec;
            double deltaIncrementAndNearestNumAtTLOP = scaledTickStep - nearestStepAtTLOP;
            double nearestStartAtTLOP = Math.rint(scaledMinVal / targetLevOfPrec) * targetLevOfPrec;
            double deltaStartAndNearestNumAtTLOP = scaledMinVal - nearestStartAtTLOP;
            if (Math.abs(deltaStartAndNearestNumAtTLOP) >= 0.1 * targetLevOfPrec) {
                ++decimalPlaces;
            } else if (Math.abs(deltaIncrementAndNearestNumAtTLOP) >= 0.001 * targetLevOfPrec) {
                int numTicks;
                double error;
                double axisRange = maxValue - minValue;
                if (minValue > maxValue) {
                    axisRange = minValue - maxValue;
                }
                if ((error = Math.abs(deltaIncrementAndNearestNumAtTLOP * (double)(numTicks = (int)Math.floor(axisRange / tickStep)) + deltaStartAndNearestNumAtTLOP)) >= 0.1 * targetLevOfPrec) {
                    ++decimalPlaces;
                }
            }
            if (bUseDefaultScaleFactor) {
                while (scaleFactor != 0 && decimalPlaces > 2) {
                    decimalPlaces -= 3;
                    switch (scaleFactor) {
                        case 1: {
                            scaleFactor = 0;
                            break;
                        }
                        case 2: {
                            scaleFactor = 1;
                            break;
                        }
                        case 3: {
                            scaleFactor = 2;
                            break;
                        }
                        case 4: {
                            scaleFactor = 3;
                            break;
                        }
                        case 5: {
                            scaleFactor = 4;
                        }
                    }
                }
            }
        }
        if (bUseDefaultScaleFactor) {
            format.setScaleFactor(scaleFactor);
        }
        if (bUseDefaultDecimalDigit) {
            decimalPlaces = decimalPlaces >= 0 ? decimalPlaces : 0;
            format.setDecimalDigit(decimalPlaces);
        }
    }

    protected void formatLogScaleAxisValue(double logBase, double data, ViewFormat format, boolean bUseDefaultScaleFactor, boolean bUseDefaultDecimalDigit) {
        if (logBase == 10.0 || logBase == Math.E) {
            if (bUseDefaultScaleFactor) {
                if (logBase == 10.0 && data >= 1000.0) {
                    format.setScaleFactor(1);
                } else {
                    format.setScaleFactor(0);
                }
            }
            if (bUseDefaultDecimalDigit) {
                int power = this._getPowerOfTen(data);
                int scaleFactorPowerOfTen = this._getScaleFactorPowerOfTen(format.getScaleFactor());
                int decimalPlaces = scaleFactorPowerOfTen - power;
                decimalPlaces = decimalPlaces > 0 ? decimalPlaces : 0;
                format.setDecimalDigit(decimalPlaces);
            }
        } else if (logBase == 2.0) {
            if (bUseDefaultScaleFactor) {
                format.setScaleFactor(0);
            }
            if (bUseDefaultDecimalDigit) {
                int scaleFactorPowerOfTen;
                int decimalPlaces;
                int exponent = (int)Math.rint(Math.log(data) / Math.log(2.0));
                if (exponent > 0) {
                    exponent = 0;
                }
                decimalPlaces = (decimalPlaces = (scaleFactorPowerOfTen = this._getScaleFactorPowerOfTen(format.getScaleFactor())) - exponent) > 0 ? decimalPlaces : 0;
                format.setDecimalDigit(decimalPlaces);
            }
        }
    }

    @Override
    public String formatPieValue(double data, ViewFormat componentFormat, boolean isPercent, QDR qdr, boolean isTooltip) {
        int power = this._getPowerOfTen(data);
        boolean bCallbackUsed = componentFormat.isViewFormatCallbackUsed();
        componentFormat.setViewFormatCallbackUsed(false);
        boolean bNumberTypeUsed = componentFormat.isNumberTypeUsed();
        boolean bDecimalDigitUsed = componentFormat.isDecimalDigitUsed();
        boolean bScaleFactorUsed = componentFormat.isScaleFactorUsed();
        int numberType = componentFormat.getNumberType();
        int decimalDigit = componentFormat.getDecimalDigit();
        int scaleFactor = componentFormat.getScaleFactor();
        boolean restoreNumberType = false;
        boolean restoreScaleFactor = false;
        if (isPercent) {
            power += 2;
            componentFormat.setNumberType(2);
            restoreNumberType = true;
            componentFormat.setScaleFactor(0);
            restoreScaleFactor = true;
        }
        this.setDefaultScaleValues(componentFormat, power, bDecimalDigitUsed, bScaleFactorUsed);
        ViewFormat format = componentFormat;
        try {
            if (this.m_bundles != null || this.m_uiBundle != null) {
                RuleContext context = new RuleContext();
                context.put((Object)"NUMBER_VALUE", (Object)new Double(data));
                context.put((Object)"ISPERCENT", (Object)isPercent);
                if (qdr != null) {
                    context.put((Object)"QDR", (Object)qdr);
                }
                if (this.m_bundles != null) {
                    format = (ViewFormat)ResolutionService.resolveRules((RuleContext)context, (Mergeable)format, (Vector)this.m_bundles);
                }
                if (this.m_uiBundle != null && format != null) {
                    format = (ViewFormat)ResolutionService.resolveRules((RuleContext)context, (Mergeable)format, (RuleBundle)this.m_uiBundle);
                }
            }
        }
        catch (ClassCastException e) {
            format = null;
        }
        String value = format == null ? Double.valueOf(data).toString() : format.DoubleToString(data);
        if (restoreNumberType) {
            componentFormat.setNumberType(numberType);
            componentFormat.setNumberTypeUsed(bNumberTypeUsed);
        }
        if (!bDecimalDigitUsed) {
            componentFormat.setDecimalDigit(decimalDigit);
            componentFormat.setDecimalDigitUsed(bDecimalDigitUsed);
        }
        if (!bScaleFactorUsed || restoreScaleFactor) {
            componentFormat.setScaleFactor(scaleFactor);
            componentFormat.setScaleFactorUsed(bScaleFactorUsed);
        }
        componentFormat.setViewFormatCallbackUsed(bCallbackUsed);
        return value;
    }

    @Override
    public String formatDataValue(double data, ViewFormat componentFormat, int axisID, int column, int row, boolean isPercent, QDR qdr, boolean isTooltip) {
        int power = this._getPowerOfTen(data);
        boolean bCallbackUsed = componentFormat.isViewFormatCallbackUsed();
        componentFormat.setViewFormatCallbackUsed(false);
        boolean bNumberTypeUsed = componentFormat.isNumberTypeUsed();
        boolean bDecimalDigitUsed = componentFormat.isDecimalDigitUsed();
        boolean bScaleFactorUsed = componentFormat.isScaleFactorUsed();
        int numberType = componentFormat.getNumberType();
        int decimalDigit = componentFormat.getDecimalDigit();
        int scaleFactor = componentFormat.getScaleFactor();
        boolean restoreNumberType = false;
        boolean restoreScaleFactor = false;
        if (isPercent) {
            power += 2;
            componentFormat.setNumberType(2);
            restoreNumberType = true;
            componentFormat.setScaleFactor(0);
            restoreScaleFactor = true;
        }
        this.setDefaultScaleValues(componentFormat, power, bDecimalDigitUsed, bScaleFactorUsed);
        ViewFormat format = componentFormat;
        try {
            if (this.m_bundles != null || this.m_uiBundle != null) {
                RuleContext context = new RuleContext();
                context.put((Object)"NUMBER_VALUE", (Object)new Double(data));
                context.put((Object)"POSITION", (Object)new DataComponentInfo(row, column));
                context.put((Object)"COMPONENT_TYPE", (Object)new Integer(axisID));
                context.put((Object)"ISPERCENT", (Object)isPercent);
                if (qdr != null) {
                    context.put((Object)"QDR", (Object)qdr);
                }
                if (this.m_bundles != null) {
                    format = (ViewFormat)ResolutionService.resolveRules((RuleContext)context, (Mergeable)componentFormat, (Vector)this.m_bundles);
                }
                if (this.m_uiBundle != null && format != null) {
                    format = (ViewFormat)ResolutionService.resolveRules((RuleContext)context, (Mergeable)format, (RuleBundle)this.m_uiBundle);
                }
            }
        }
        catch (ClassCastException e) {
            format = null;
        }
        String value = format == null ? Double.valueOf(data).toString() : format.DoubleToString(data);
        if (restoreNumberType) {
            componentFormat.setNumberType(numberType);
            componentFormat.setNumberTypeUsed(bNumberTypeUsed);
        }
        if (!bDecimalDigitUsed) {
            componentFormat.setDecimalDigit(decimalDigit);
            componentFormat.setDecimalDigitUsed(bDecimalDigitUsed);
        }
        if (!bScaleFactorUsed || restoreScaleFactor) {
            componentFormat.setScaleFactor(scaleFactor);
            componentFormat.setScaleFactorUsed(bScaleFactorUsed);
        }
        componentFormat.setViewFormatCallbackUsed(bCallbackUsed);
        return value;
    }

    @Override
    public Object formatDataValue(DataviewCommon view, Object data, int column, int row, int[] pageHPos, ViewFormat vf) {
        return null;
    }

    @Concealed
    public ObjectNode getXML(boolean allProperties, DataviewCommon dataview) {
        return this.getXML(allProperties, "FormatManager", dataview);
    }

    @Override
    public void setUIBundle(DataviewCommon view, RuleBundle bundle) {
        super.setUIBundle(view, bundle);
        if (view != null) {
            view.dataFormatChanged();
            view.repaint();
        }
    }

    private void setDefaultScaleValues(ViewFormat defaultFormat, int power, boolean isDecimalDigitUsed, boolean isScaleFactorUsed) {
        int decimalDigit;
        int scaleFactor;
        if (power <= 0) {
            scaleFactor = 0;
            decimalDigit = 3 - power;
        } else if (power <= 2) {
            scaleFactor = 0;
            decimalDigit = 3 - power;
        } else if (power >= 16) {
            scaleFactor = 5;
            decimalDigit = power - 15 < 3 ? 3 - (power - 15) : 0;
        } else {
            int scale = (power - 1) / 3 * 3;
            switch (scale) {
                case 3: {
                    scaleFactor = 1;
                    break;
                }
                case 6: {
                    scaleFactor = 2;
                    break;
                }
                case 9: {
                    scaleFactor = 3;
                    break;
                }
                case 12: {
                    scaleFactor = 4;
                    break;
                }
                case 15: {
                    scaleFactor = 5;
                    break;
                }
                default: {
                    scaleFactor = 0;
                }
            }
            decimalDigit = 3 - (power - scale);
        }
        if (!isDecimalDigitUsed) {
            defaultFormat.setDecimalDigit(decimalDigit);
        }
        if (!isScaleFactorUsed) {
            defaultFormat.setScaleFactor(scaleFactor);
        }
    }

    @Concealed
    public boolean isUsingRuleBundles() {
        return this.m_bundles != null || this.m_uiBundle != null;
    }

    private static class ViewFormatPool {
        private Vector<ViewFormat> m_pool = new Vector();

        public ViewFormat getInstance(boolean usePool) {
            ViewFormat ret;
            if (usePool && !this.m_pool.isEmpty()) {
                try {
                    ret = this.m_pool.remove(0);
                    ret.init();
                }
                catch (IndexOutOfBoundsException e) {
                    ret = new ViewFormat();
                }
            } else {
                ret = new ViewFormat();
            }
            return ret;
        }

        public void releaseInstance(ViewFormat vf, boolean usePool) {
            if (usePool && vf != null) {
                this.m_pool.add(vf);
            }
        }
    }
}

