/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseDataAxis;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class Y2Axis
extends BaseDataAxis {
    @Concealed
    protected static final String a_paretoMajorTickStep = "paretoMajorTickStep";

    @Concealed
    public Y2Axis(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getY2Axis();
        this.m_identObj2 = this.m_pfj.getY2AxisLine();
        this.m_majorGridIdentObj = this.m_pfj.getY2MajorGrid();
        this.m_minorGridIdentObj = this.m_pfj.getY2MinorGrid();
        this.m_labelIdentObj = this.m_pfj.getY2Label();
        this.m_id = 51;
    }

    @Override
    public boolean isAxisAutoScaledFromZero() {
        return this.m_pfj.getY2MustIncludeZero();
    }

    @Override
    public void setAxisAutoScaledFromZero(boolean yesNo) {
        this.m_pfj.setY2MustIncludeZero(yesNo);
    }

    @Override
    public boolean isAxisMaxAutoScaled() {
        return this.m_pfj.getY2ScaleMaxAuto();
    }

    @Override
    public void setAxisMaxAutoScaled(boolean yesNo) {
        this.m_pfj.setY2ScaleMaxAuto(yesNo);
    }

    @Override
    public boolean isAxisMinAutoScaled() {
        return this.m_pfj.getY2ScaleMinAuto();
    }

    @Override
    public void setAxisMinAutoScaled(boolean yesNo) {
        this.m_pfj.setY2ScaleMinAuto(yesNo);
    }

    @Override
    public double getAxisMaxAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getY2ScaleMaxAutoValue();
    }

    @Override
    public double getAxisMaxValue() {
        return this.m_pfj.getY2ScaleMax();
    }

    @Override
    public void setAxisMaxValue(double value) {
        this.m_pfj.setY2ScaleMax(value);
    }

    @Override
    public double getAxisMinAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getY2ScaleMinAutoValue();
    }

    @Override
    public double getAxisMinValue() {
        return this.m_pfj.getY2ScaleMin();
    }

    @Override
    public void setAxisMinValue(double value) {
        this.m_pfj.setY2ScaleMin(value);
    }

    @Override
    public double getAxisZoomMaxValue() {
        Double val = this.m_pfj.getY2ScaleZoomMax();
        if (val != null) {
            return val;
        }
        return 0.0;
    }

    @Override
    public void setAxisZoomMaxValue(double value) {
        this.m_pfj.setY2ScaleZoomMax(value);
    }

    @Override
    public double getAxisZoomMinValue() {
        Double val = this.m_pfj.getY2ScaleZoomMin();
        if (val != null) {
            return val;
        }
        return 0.0;
    }

    @Override
    public void setAxisZoomMinValue(double value) {
        this.m_pfj.setY2ScaleZoomMin(value);
    }

    @Override
    public double getMajorTickStep() {
        if (this.isMajorTickStepAutomatic() && !this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        if (this.m_commonGraph.getGraphType() == 96) {
            return this.m_pfj.getParetoY2MajorGridStep();
        }
        return this.m_pfj.getY2MajorGridStep();
    }

    @Override
    public double getMinorTickStep() {
        if (this.getMinorTickStepType() != GraphConstants.MinorGridStepType.AUTO && !this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getY2MinorGridStep();
    }

    @Override
    @Concealed
    public double getAutoMajorTickStep() {
        if (!this.m_pfj.isCalculated()) {
            this.m_commonGraph.calculatePlacement();
        }
        return this.m_pfj.getY2MajorGridStepAutoValue();
    }

    @Override
    public void setMajorTickStep(double value) {
        if (value < 0.0) {
            this.m_commonGraph.getErrorHandler().log("invalid major tick step", this.getClass().getName(), "setMajorTickStep (double value)");
        } else if (this.m_commonGraph.getGraphType() == 96) {
            this.m_pfj.setParetoY2MajorGridStep(value);
        } else {
            this.m_pfj.setY2MajorGridStep(value);
        }
    }

    @Override
    public void setMinorTickStep(double value) {
        if (value < 0.0) {
            this.m_commonGraph.getErrorHandler().log("invalid minor tick step", this.getClass().getName(), "setMinorTickStep (double value)");
        } else {
            this.m_pfj.setY2MinorGridStep(value);
        }
    }

    @Override
    public boolean isMajorTickStepAutomatic() {
        return this.m_pfj.getY2MajorGridStepAuto();
    }

    @Override
    public void setMajorTickStepAutomatic(boolean yesNo) {
        this.m_pfj.setY2MajorGridStepAuto(yesNo);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.m_pfj.setY2LabelDisplay(visible);
        this.m_pfj.setY2MajorGridDisplay(visible);
        this.m_pfj.setY2MinorGridDisplay(visible);
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "Y2Axis";
    }

    private void logError() {
        this.m_commonGraph.getErrorHandler().log("invalid major tick step", this.getClass().getName(), "setXML()");
    }

    @Override
    @Concealed
    protected void setMajorTickStepXML(ObjectNode node) {
        super.setMajorTickStepXML(node);
        PropertyNode pNode = node.getProperty(a_paretoMajorTickStep);
        if (pNode != null) {
            double value = pNode.getValueAsDouble();
            if (value < 0.0) {
                this.logError();
            } else {
                this.m_pfj.setParetoY2MajorGridStep(value);
            }
        }
    }

    @Override
    @Concealed
    protected boolean getMajorTickStepXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getMajorTickStepXML(allProperties, node);
        Object val = this.m_pfj.getObjProp(Attr.ParetoY2MajorGridStep);
        if (val != null) {
            node.addProperty(a_paretoMajorTickStep, ((Double)val).doubleValue());
            nodeExists = true;
        }
        return nodeExists;
    }
}

