/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.UIFillColor;
import oracle.dss.graph.BaseDataComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class VolumeMarker
extends BaseDataComponent
implements UIFillColor {
    @Concealed
    public VolumeMarker(CommonGraph graph, IdentObj identObj) {
        super(graph, identObj);
    }

    @Override
    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_pfj.getStockVolumeRiser());
    }

    @Override
    public void setFillColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor( Color newColor)");
            return;
        }
        this.m_pfj.setFillColor(this.m_pfj.getStockVolumeRiser(), newColor);
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "VolumeMarker";
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("fillColor");
        if (pNode != null) {
            Color c = new Color(VolumeMarker.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillColor", c);
            } else {
                this.setFillColor(c);
            }
        }
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = false;
        Color val = this.getFillColor();
        if (val != null) {
            node.addProperty("fillColor", VolumeMarker.toHexString(val.getRGB()));
            styleOverridden = true;
        }
        return styleOverridden;
    }

    @Concealed
    protected void resetStyle() {
        this.setFillColor(Color.black);
    }
}

