/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Visible;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public abstract class PanelGrid
extends BaseGraphComponent
implements Visible {
    @Concealed
    protected IdentObj m_identObj2;

    @Concealed
    public PanelGrid(CommonGraph graph) {
        super(graph);
    }

    public Color getColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, newColor);
        this.m_pfj.setBorderColor(this.m_identObj2, newColor);
    }

    @Override
    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    @Override
    public void setVisible(boolean yesNo) {
        this.m_pfj.setDisplay(this.m_identObj, yesNo);
        this.m_pfj.setDisplay(this.m_identObj2, yesNo);
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty("color");
        if (pNode != null) {
            this.setColor(new Color(PanelGrid.hexStringToInt(pNode.getValueAsString()), true));
        }
        if ((pNode = node.getProperty("visible")) != null) {
            this.setVisible(pNode.getValueAsBoolean());
        }
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean styleOverridden = false;
        Object val = this.getColor();
        if (val != null) {
            node.addProperty("color", PanelGrid.toHexString(((Color)val).getRGB()));
            styleOverridden = true;
        }
        if ((val = this.m_pfj.getDisplayObj(this.m_identObj)) != null) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            styleOverridden = true;
        }
        return styleOverridden;
    }

    @Concealed
    protected void resetStyle() {
        this.setColor(Color.black);
        this.setVisible(true);
    }
}

