/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.dataView.ViewStyleHandle;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.graph.CommonGraph;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.ResolutionService;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.RuleContext;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeComponentInfo;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.SliceOutOfRangeException;

public class GraphExtendedStyleManager {
    private static final String m_getMetadataStyle = "getMetadataStyle";

    public static ViewStyle getMetadataStyle(Vector m_bundles, RuleBundle m_uiBundle, CommonGraph view, Object metaData, ViewStyle initStyle, int edge, int depth, int index) {
        ViewStyleHandle vsHandle;
        Object obj;
        boolean bRunRules = true;
        EdgeComponentInfo einfo = new EdgeComponentInfo(0, 0, 0);
        boolean bClonedInitStyle = false;
        DataAccess baseDataAccess = null;
        if (view.getModel() != null) {
            baseDataAccess = view.getModel().getDataAccess();
        }
        if (baseDataAccess == null) {
            baseDataAccess = view.getDataAccess();
        }
        if (view.isLayerMetaViewStyleSupported()) {
            obj = null;
            try {
                obj = baseDataAccess.getLayerMetadata(edge, depth, "viewStyle");
            }
            catch (EdgeOutOfRangeException coore) {
                view.getErrorHandler().log("edge out of range", "GraphStyleRules", m_getMetadataStyle);
            }
            catch (LayerOutOfRangeException roore) {
                view.getErrorHandler().log("layer out of range", "GraphStyleRules", m_getMetadataStyle);
            }
            vsHandle = null;
            if (obj != null) {
                if (obj instanceof ViewStyleHandle) {
                    vsHandle = (ViewStyleHandle)obj;
                } else {
                    view.getErrorHandler().log("object not ViewStyleHandle type", "GraphStyleRules", m_getMetadataStyle);
                }
            }
            if (vsHandle != null) {
                if (vsHandle.getViewStyle() != null) {
                    if (!bClonedInitStyle) {
                        initStyle = (ViewStyle)initStyle.clone();
                        bClonedInitStyle = true;
                    }
                    initStyle.merge((Mergeable)vsHandle.getViewStyle());
                }
                if (vsHandle.getRunRulesForViewStyle() == 0) {
                    bRunRules = false;
                } else if (vsHandle.getRunRulesForViewStyle() == 1) {
                    bRunRules = true;
                }
            }
        }
        if (view.isMetadataViewStyleSupported()) {
            obj = null;
            try {
                obj = baseDataAccess.getMemberMetadata(edge, depth, index, "viewStyle");
            }
            catch (EdgeOutOfRangeException coore) {
                view.getErrorHandler().log("edge out of range", "GraphStyleRules", m_getMetadataStyle);
            }
            catch (LayerOutOfRangeException roore) {
                view.getErrorHandler().log("layer out of range", "GraphStyleRules", m_getMetadataStyle);
            }
            catch (SliceOutOfRangeException soore) {
                view.getErrorHandler().log("slice out of range", "GraphStyleRules", m_getMetadataStyle);
            }
            vsHandle = null;
            if (obj != null) {
                if (obj instanceof ViewStyleHandle) {
                    vsHandle = (ViewStyleHandle)obj;
                } else {
                    view.getErrorHandler().log("object not ViewStyleHandle type", "GraphStyleRules", m_getMetadataStyle);
                }
            }
            if (vsHandle != null) {
                if (vsHandle.getViewStyle() != null) {
                    if (!bClonedInitStyle) {
                        initStyle = (ViewStyle)initStyle.clone();
                        bClonedInitStyle = true;
                    }
                    initStyle.merge((Mergeable)vsHandle.getViewStyle());
                }
                if (vsHandle.getRunRulesForViewStyle() == 0) {
                    bRunRules = false;
                } else if (vsHandle.getRunRulesForViewStyle() == 1) {
                    bRunRules = true;
                }
            }
        }
        if (!bRunRules) {
            return initStyle;
        }
        einfo.setEdgeDepthIndex(edge, depth, index);
        RuleContext location = new RuleContext();
        String type = metaData instanceof Number ? "NUMBER_VALUE" : (metaData instanceof Date ? "DATE_VALUE" : "STRING_VALUE");
        location.put((Object)"POSITION", (Object)einfo);
        if (metaData != null) {
            location.put((Object)type, metaData);
        }
        String layerName = null;
        try {
            QDR qdr = null;
            qdr = baseDataAccess.getLayerQDR(edge, depth, 0);
            if (qdr != null) {
                location.put((Object)"DIMENSIONQDR", (Object)qdr);
                Enumeration layers = qdr.getDimensions();
                if (layers.hasMoreElements()) {
                    layerName = layers.nextElement().toString();
                }
            }
        }
        catch (NullPointerException e) {
            view.getErrorHandler().log("DataProvider is null", "GraphStyleRules", m_getMetadataStyle);
        }
        catch (EdgeOutOfRangeException ee) {
            view.getErrorHandler().log("edge out of range when getting layer QDR", "GraphStyleRules", m_getMetadataStyle);
        }
        catch (LayerOutOfRangeException le) {
            view.getErrorHandler().log("layer out of range when getting layer QDR", "GraphStyleRules", m_getMetadataStyle);
        }
        QDR memberQDR = null;
        memberQDR = einfo.getQDR(baseDataAccess, 1);
        if (memberQDR != null) {
            if (layerName != null) {
                memberQDR.setTarget(new QDRMember(layerName));
            }
            location.put((Object)"QDR", (Object)memberQDR);
        }
        if (edge == 2) {
            location.put((Object)"COMPONENT_TYPE", (Object)new Integer(3));
        }
        ViewStyle style = initStyle;
        try {
            if (m_bundles != null) {
                initStyle = style = (ViewStyle)ResolutionService.resolveRules((RuleContext)location, (Mergeable)initStyle, (Vector)m_bundles);
            }
            if (m_uiBundle != null && initStyle != null) {
                style = (ViewStyle)ResolutionService.resolveRules((RuleContext)location, (Mergeable)initStyle, (RuleBundle)m_uiBundle);
            }
        }
        catch (ClassCastException e) {
            view.getErrorHandler().log("Class cast exception of ResolutionService", "GraphStyleRules", m_getMetadataStyle);
            return null;
        }
        if (style == null) {
            view.getErrorHandler().log("Error in resolving rules", "GraphStyleRules", m_getMetadataStyle);
            return null;
        }
        return style;
    }
}

