/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class BaseLegendMarker
extends BaseGraphComponent {
    @Concealed
    protected int m_maxSize;
    private static final String a_size = "size";
    private static final String m_method_setSize = "void setSize(int size)";

    @Concealed
    public BaseLegendMarker(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getLegendMarker();
    }

    public void setSize(int size) {
        if (size < 1) {
            this.m_commonGraph.getErrorHandler().log("size out of range", this.getClass().getName(), m_method_setSize);
            return;
        }
        this.m_pfj.setLegendMarkerSize(size);
    }

    public int getSize() {
        return this.m_pfj.getLegendMarkerSize();
    }

    @Override
    @Concealed
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getObjProp(Attr.LegendMarkerSize);
        if (val != null) {
            node.addProperty(a_size, ((Integer)val).intValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    @Concealed
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty(a_size);
        if (pNode != null) {
            this.setSize(pNode.getValueAsInteger());
        }
    }

    @Concealed
    protected void resetStyle() {
        this.setSize(2);
    }
}

