/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class DataSpecification
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String METRIC = "DST_METRIC";
    public static final String MINIMUM = "DST_MINIMUM";
    public static final String MAXIMUM = "DST_MAXIMUM";
    public static final String THRESHOLD = "DST_THRESHOLD";
    public static final String TOP_LABEL = "DST_TOPLABEL";
    public static final String BOTTOM_LABEL = "DST_BOTTOMLABEL";
    @Concealed
    public static final String NAME_DIMENSION = "Dimension";
    @Concealed
    public static final String NAME_SPECIFICATION = "Specification";
    public static final String a_type = "type";
    public static final String a_index = "index";
    public static final String a_name = "name";
    public static final int INIT_THRESHOLD_CAPACITY = 10;
    public static final int INIT_METRIC_CAPACITY = 5;
    private String m_measDimName = null;
    private String m_minValue = null;
    private String m_maxValue = null;
    private ArrayList m_thresholdValues = new ArrayList(10);
    private List<String> m_metricValues = new ArrayList<String>(5);
    private transient CommonGauge m_commonGauge = null;
    private transient boolean _processingXML = false;

    public String getMeasureDimensionName() {
        return this.m_measDimName;
    }

    public void setMeasureDimensionName(String dimName) {
        boolean newMeasDim = true;
        if (dimName == null && this.m_measDimName == null) {
            newMeasDim = false;
        } else if (dimName.equals(this.m_measDimName)) {
            newMeasDim = false;
        }
        if (newMeasDim) {
            this.m_measDimName = dimName;
            this.updateCommonGauge();
        }
    }

    public String getMetric() {
        return this.getMetric(0);
    }

    public String getMetric(int i) {
        if (this.m_metricValues != null && this.m_metricValues.size() > i) {
            return this.m_metricValues.get(i);
        }
        return null;
    }

    public List<String> getMetrics() {
        return this.m_metricValues;
    }

    public void setMetric(String value) {
        this.setMetric(value, 0);
    }

    public void setMetric(String value, int index) {
        if (index >= 0) {
            if (this.m_metricValues.size() <= index) {
                for (int i = this.m_metricValues.size(); i <= index; ++i) {
                    this.m_metricValues.add(null);
                }
            }
            boolean newMetric = true;
            if (value == null) {
                if (this.m_metricValues.size() == 0) {
                    newMetric = false;
                }
            } else if (value.equals(this.m_metricValues.get(index))) {
                newMetric = false;
            }
            if (newMetric) {
                this.m_metricValues.set(index, value);
                this.updateCommonGauge();
            }
        }
    }

    public void setMetrics(List<String> list) {
        boolean newMetric = true;
        if (list == null) {
            if (this.m_metricValues.size() == 0) {
                newMetric = false;
            }
        } else if (list.equals(this.m_metricValues)) {
            newMetric = false;
        }
        if (newMetric) {
            if (list == null) {
                this.m_metricValues.clear();
            } else {
                this.m_metricValues = new ArrayList<String>(list);
            }
            this.updateCommonGauge();
        }
    }

    public String getMinimum() {
        return this.m_minValue;
    }

    public void setMinimum(String value) {
        boolean newMin = true;
        if (value == null && this.m_minValue == null) {
            newMin = false;
        } else if (value.equals(this.m_minValue)) {
            newMin = false;
        }
        if (newMin) {
            this.m_minValue = value;
            this.updateCommonGauge();
        }
    }

    public String getMaximum() {
        return this.m_maxValue;
    }

    public void setMaximum(String value) {
        boolean newMax = true;
        if (value == null && this.m_maxValue == null) {
            newMax = false;
        } else if (value.equals(this.m_maxValue)) {
            newMax = false;
        }
        if (newMax) {
            this.m_maxValue = value;
            this.updateCommonGauge();
        }
    }

    public ArrayList getThresholds() {
        return this.m_thresholdValues;
    }

    public void setThresholds(ArrayList values) {
        boolean newTholds = true;
        if (values == null && this.m_thresholdValues != null) {
            newTholds = false;
        } else if (values.equals(this.m_thresholdValues)) {
            newTholds = false;
        }
        if (newTholds) {
            this.m_thresholdValues = values;
            this.updateCommonGauge();
        }
    }

    public String getThreshold(int index) {
        String value = null;
        if (this.m_thresholdValues != null && this.m_thresholdValues.size() >= index) {
            value = (String)this.m_thresholdValues.get(index);
        }
        return value;
    }

    public void setThreshold(int index, String value) {
        if (index < this.m_thresholdValues.size()) {
            this.m_thresholdValues.set(index, value);
        } else {
            for (int i = this.m_thresholdValues.size(); i < index; ++i) {
                this.m_thresholdValues.add(null);
            }
            this.m_thresholdValues.add(value);
        }
        this.updateCommonGauge();
    }

    @Concealed
    public boolean setDataSpecByName(String type, String value) {
        boolean applied = false;
        int loc = -1;
        if (type.equals(METRIC)) {
            this.m_metricValues.add(value);
            applied = true;
        } else if (type.equals(MINIMUM)) {
            this.setMinimum(value);
            applied = true;
        } else if (type.equals(MAXIMUM)) {
            this.setMaximum(value);
            applied = true;
        } else {
            loc = type.indexOf(THRESHOLD);
            if (loc >= 0) {
                int index = -1;
                int keyNameLen = THRESHOLD.length();
                index = keyNameLen < type.length() ? Integer.parseInt(type.substring(THRESHOLD.length())) : this.m_thresholdValues.size();
                if (index >= this.m_thresholdValues.size()) {
                    for (int i = this.m_thresholdValues.size(); i < index; ++i) {
                        this.m_thresholdValues.add(null);
                    }
                    this.m_thresholdValues.add(value);
                } else {
                    this.m_thresholdValues.set(index, value);
                }
                applied = true;
            }
        }
        return applied;
    }

    @Concealed
    private boolean setDataSpecFromXML(String type, String value, Integer index) {
        boolean applied = false;
        if (type.equals(METRIC)) {
            if (index == null) {
                this.m_metricValues.add(value);
            } else {
                this.setMetric(value, index);
            }
        } else {
            return this.setDataSpecByName(type, value);
        }
        applied = true;
        return applied;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DataSpecification)) {
            return false;
        }
        DataSpecification dataSpec = (DataSpecification)obj;
        if (this.m_measDimName == null ? dataSpec.getMeasureDimensionName() != null : this.m_measDimName.equals(dataSpec.getMeasureDimensionName())) {
            return false;
        }
        if (this.m_metricValues == null ? dataSpec.getMetric() != null : !this.m_metricValues.equals(dataSpec.getMetrics())) {
            return false;
        }
        if (this.m_minValue == null ? dataSpec.getMinimum() != null : !this.m_minValue.equals(dataSpec.getMinimum())) {
            return false;
        }
        if (this.m_maxValue == null ? dataSpec.getMaximum() != null : !this.m_maxValue.equals(dataSpec.getMaximum())) {
            return false;
        }
        return this.m_thresholdValues.equals(dataSpec.getThresholds());
    }

    public boolean isEmpty() {
        return this.m_metricValues.size() == 0 && this.m_minValue == null && this.m_maxValue == null && this.m_thresholdValues.size() == 0 && this.m_measDimName == null;
    }

    public void setXML(ContainerNode node) {
        Enumeration specEnum = node.getContainedObject();
        if (specEnum != null) {
            boolean dataSpecSet = false;
            this._processingXML = true;
            while (specEnum.hasMoreElements()) {
                boolean set;
                ObjectNode specNode = (ObjectNode)specEnum.nextElement();
                String specName = specNode.getName();
                if (specName.equals(NAME_DIMENSION)) {
                    PropertyNode propNode = specNode.getProperty(a_name);
                    if (propNode == null) continue;
                    this.setMeasureDimensionName(propNode.getValueAsString());
                    continue;
                }
                if (!specName.equals(NAME_SPECIFICATION)) continue;
                PropertyNode indexProp = specNode.getProperty(a_index);
                Integer index = null;
                if (indexProp != null) {
                    index = indexProp.getValueAsInteger();
                }
                if (!(set = this.setDataSpecFromXML(specNode.getProperty(a_type).getValueAsString(), specNode.getProperty("value").getValueAsString(), index))) continue;
                dataSpecSet = true;
            }
            this._processingXML = false;
            if (dataSpecSet) {
                this.updateCommonGauge();
            }
        }
    }

    protected boolean getXML(ObjectNode parent) {
        int i;
        ContainerNode cnode = new ContainerNode("DataSpecification");
        boolean cnodeExists = false;
        ObjectNode node = null;
        if (this.getMeasureDimensionName() != null) {
            node = new ObjectNode(NAME_DIMENSION);
            node.addProperty(a_name, this.getMeasureDimensionName());
            cnode.addContainedObject((BaseNode)node);
            cnodeExists = true;
        }
        for (i = 0; i < this.m_metricValues.size(); ++i) {
            node = new ObjectNode(NAME_SPECIFICATION);
            node.addProperty(a_type, METRIC);
            if (i > 0) {
                node.addProperty(a_index, Integer.toString(i + 1));
            }
            node.addProperty("value", this.getMetric(i));
            cnode.addContainedObject((BaseNode)node);
            cnodeExists = true;
        }
        if (this.getMinimum() != null) {
            node = new ObjectNode(NAME_SPECIFICATION);
            node.addProperty(a_type, MINIMUM);
            node.addProperty("value", this.getMinimum());
            cnode.addContainedObject((BaseNode)node);
            cnodeExists = true;
        }
        if (this.getMaximum() != null) {
            node = new ObjectNode(NAME_SPECIFICATION);
            node.addProperty(a_type, MAXIMUM);
            node.addProperty("value", this.getMaximum());
            cnode.addContainedObject((BaseNode)node);
            cnodeExists = true;
        }
        for (i = 0; i < this.m_thresholdValues.size(); ++i) {
            node = new ObjectNode(NAME_SPECIFICATION);
            node.addProperty(a_type, THRESHOLD);
            node.addProperty(a_index, Integer.toString(i + 1));
            node.addProperty("value", this.getThreshold(i));
            cnode.addContainedObject((BaseNode)node);
            cnodeExists = true;
        }
        if (cnodeExists) {
            parent.addContainer(cnode);
        }
        return cnodeExists;
    }

    private void updateCommonGauge() {
        if (!this._processingXML && this.m_commonGauge != null) {
            this.m_commonGauge.setRecalcState(2);
        }
    }

    @Concealed
    protected void setCommonGauge(CommonGauge cg) {
        this.m_commonGauge = cg;
    }
}

