/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import oracle.dss.dataView.Attributes;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataComponentInfo;

public class DataComponentHandle
extends ComponentHandle {
    private static final long serialVersionUID = 1L;
    private DataComponentInfo _dataInfo;
    private boolean m_seriesComponent = true;
    private boolean m_seriesAndGroups = false;
    private int m_group;
    private int m_series;
    protected boolean m_seriesAreRows;
    public static final String UNFORMATTED_VALUE = "dataValue";
    public static final String ROW_KEY = "dataRowKey";
    public static final String KEY_PATH = "dataKeyPath";

    public DataComponentHandle(int id, String name, Object comp, int r, int c) {
        super(id, name, comp);
        this._dataInfo = new DataComponentInfo(r, c);
        this.m_group = this.getColumn();
        this.m_series = this.getRow();
    }

    public DataComponentHandle(int id, String name, Object comp, int r, int c, boolean seriesAreRows) {
        super(id, name, comp);
        this._dataInfo = new DataComponentInfo(r, c);
        this.m_group = seriesAreRows ? this.getColumn() : this.getRow();
        this.m_series = seriesAreRows ? this.getRow() : this.getColumn();
        this.m_seriesAreRows = seriesAreRows;
    }

    public DataComponentHandle(int id, String name, Object comp, DataComponentInfo dataInfo) {
        super(id, name, comp);
        this._dataInfo = dataInfo;
        this.m_group = this.getColumn();
        this.m_series = this.getRow();
    }

    public DataComponentHandle(int id, String name, Object comp, DataComponentInfo info, boolean seriesAreRows) {
        super(id, name, comp);
        this._dataInfo = info;
        this.m_group = seriesAreRows ? this.getColumn() : this.getRow();
        this.m_series = seriesAreRows ? this.getRow() : this.getColumn();
    }

    public DataComponentHandle(int id, String name, Object comp, int row, int column, int group, int series) {
        super(id, name, comp);
        this._dataInfo = new DataComponentInfo(row, column);
        this.m_group = group;
        this.m_series = series;
        this.m_seriesAndGroups = true;
    }

    public DataComponentHandle(int id, String name, Object comp, DataComponentInfo info, int group, int series) {
        super(id, name, comp);
        this._dataInfo = info;
        this.m_group = group;
        this.m_series = series;
        this.m_seriesAndGroups = true;
    }

    public Object getValue(String attrName) {
        if (this.m_dataAccess != null) {
            try {
                return this.m_dataAccess.getValue(this.getRow(), this.getColumn(), attrName);
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    public Attributes[] getSeriesAttributes() {
        int edge = 0;
        if (this.m_seriesAreRows) {
            edge = 1;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, this.getSeries(), edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Attributes[] getGroupAttributes() {
        int edge = 1;
        if (this.m_seriesAreRows) {
            edge = 0;
        }
        try {
            int layers = this.m_dataAccess.getLayerCount(edge);
            Attributes[] attrs = new Attributes[layers];
            for (int i = 0; i < layers; ++i) {
                attrs[i] = new Attributes(this.m_dataAccess, i, this.m_group, edge);
            }
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getRow() {
        return this._dataInfo.getRow();
    }

    public int getColumn() {
        return this._dataInfo.getColumn();
    }

    public int getSeries() {
        return this.m_series;
    }

    public int getGroup() {
        return this.m_group;
    }

    public String toString() {
        if (this.m_seriesAndGroups) {
            return this.getClass().getName() + " [Name=" + this.getName() + ",series=" + this.m_series + ",group=" + this.m_group + "]";
        }
        return this.getClass().getName() + " [Name=" + this.getName() + "," + this._dataInfo.toString() + "]";
    }

    @Override
    public ComponentInfo getComponentInfo() {
        return this._dataInfo;
    }

    public boolean isSeriesComponent() {
        return this.m_seriesComponent;
    }

    public void setSeriesComponent(boolean series) {
        this.m_seriesComponent = series;
    }

    public void setSeriesAreRows(boolean seriesAreRows) {
        this.m_seriesAreRows = seriesAreRows;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DataComponentHandle)) {
            return false;
        }
        DataComponentHandle c = (DataComponentHandle)o;
        return super.equals(c) && this.getSeries() == c.getSeries() && this.getGroup() == c.getGroup();
    }
}

