/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime.ess;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.Attribute;
import oracle.security.crypto.cert.X509PolicyInformation;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.cms.ESSCertID;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.smime.Smime;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class SigningCertificate
implements ASN1Object {
    private Vector certIDs;
    private Vector policies;
    private ASN1Sequence contents;

    public SigningCertificate(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        this(cert, null);
    }

    public SigningCertificate(X509Certificate cert, Vector policy) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (cert == null) {
            throw new IllegalArgumentException("Null Signing Certificate");
        }
        ESSCertID certID = new ESSCertID(cert);
        this.certIDs = new Vector();
        this.certIDs.addElement(certID);
        if (policy == null) {
            this.policies = null;
        } else {
            this.policies = new Vector();
            int j = policy.size();
            for (int i = 0; i < j; ++i) {
                this.policies.addElement((X509PolicyInformation)policy.elementAt(i));
            }
        }
        this.contents = null;
    }

    public SigningCertificate(X509Certificate cert, X509Certificate caCert, boolean addIssuerSerial) throws NoSuchAlgorithmException, CertificateEncodingException {
        this(cert, caCert, addIssuerSerial, null);
    }

    public SigningCertificate(X509Certificate cert, X509Certificate caCert, boolean useIssuerSerial, Vector policy) throws CertificateEncodingException, NoSuchAlgorithmException {
        if (cert == null) {
            throw new IllegalArgumentException("Null Signing Certificate");
        }
        ESSCertID certID = new ESSCertID(cert, caCert, useIssuerSerial);
        this.certIDs = new Vector();
        this.certIDs.addElement(certID);
        if (policy == null) {
            this.policies = null;
        } else {
            this.policies = new Vector();
            int j = policy.size();
            for (int i = 0; i < j; ++i) {
                this.policies.addElement((X509PolicyInformation)policy.elementAt(i));
            }
        }
        this.contents = null;
    }

    public SigningCertificate(InputStream is) throws IOException {
        this.input(is);
        this.contents = null;
    }

    public SigningCertificate(CMSSignerInfo si) throws InvalidInputException {
        try {
            if (si == null) {
                throw new InvalidInputException("CMSSignerInfo Not Present");
            }
            Attribute vals = si.getSignedAttributes().getAttribute(Smime.id_aa_signingCertificate);
            if (vals == null) {
                throw new InvalidInputException("SigningCertificateAttribute is NOT present");
            }
            if (vals.getValues().size() != 1) {
                throw new InvalidInputException("SigningCertificateAttibute is NOT Single Valued");
            }
            try {
                this.input((InputStream)new UnsyncByteArrayInputStream(Utils.toBytes((Streamable)((ASN1Sequence)vals.getValues().elementAt(0)))));
            }
            catch (IOException ex) {
                throw new InvalidInputException(ex.toString());
            }
            this.contents = null;
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex.toString());
        }
    }

    public void addCertificate(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (cert == null) {
            throw new IllegalArgumentException("Null Authorization Certificate");
        }
        this.certIDs.addElement(new ESSCertID(cert));
        this.contents = null;
    }

    public void addCertificate(X509Certificate cert, X509Certificate caCert, boolean issuerSerial) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (cert == null) {
            throw new IllegalArgumentException("Null Authorization Certificate");
        }
        this.certIDs.addElement(new ESSCertID(cert, caCert, issuerSerial));
        this.contents = null;
    }

    public void addPolicy(X509PolicyInformation policy) {
        if (this.policies == null) {
            this.policies = new Vector();
        }
        if (policy != null) {
            this.policies.addElement(policy);
        }
        this.contents = null;
    }

    public Enumeration certIDs() {
        return this.certIDs.elements();
    }

    public Enumeration policies() {
        if (this.policies != null) {
            return this.policies.elements();
        }
        return null;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("ESS Cert IDs:\n");
        int j = this.certIDs.size();
        for (i = 0; i < j; ++i) {
            sb.append(i + 1 + ". " + this.certIDs.elementAt(i).toString() + " \n");
        }
        sb.append("Policy Information:\n");
        for (i = 0; this.policies != null && i < this.policies.size(); ++i) {
            sb.append(i + 1 + ". " + this.policies.elementAt(i).toString() + " \n");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SigningCertificate)) {
            return false;
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)((SigningCertificate)o)));
    }

    public int hashCode() {
        return new String(Utils.toBytes((Streamable)this)).hashCode();
    }

    public void verifySignerCertificate(X509Certificate cert) throws AuthenticationException {
        try {
            ESSCertID essCertID = (ESSCertID)this.certIDs.elementAt(0);
            if (!essCertID.compareTo(cert)) {
                throw new AuthenticationException("The certificate used to verify the signature is not identical to the one used to create the signature");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    public void verifySignerCertificate(X509Certificate cert, X509Certificate caCert) throws AuthenticationException {
        try {
            ESSCertID essCertID = (ESSCertID)this.certIDs.elementAt(0);
            if (!essCertID.compareTo(cert, caCert)) {
                throw new AuthenticationException("The certificate used to verify the signature is not identical to the one used to create the signature");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    public void verifyAuthorizationCertificate(X509Certificate cert) throws AuthenticationException {
        try {
            boolean matched = false;
            if (this.certIDs.size() < 2) {
                throw new AuthenticationException("No authorization certificates are present in the SigningCertificateAttribute");
            }
            int j = this.certIDs.size();
            for (int i = 1; i < j && !matched; ++i) {
                ESSCertID essCertID = (ESSCertID)this.certIDs.elementAt(i);
                if (!essCertID.compareTo(cert)) continue;
                matched = true;
            }
            if (!matched) {
                throw new AuthenticationException("The hash from the certificate is different from the one in the SigningCertificateAttribute");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (ClassCastException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    public void verifyAuthorizationCertificate(X509Certificate cert, X509Certificate caCert) throws AuthenticationException {
        try {
            boolean matched = false;
            if (this.certIDs.size() < 2) {
                throw new AuthenticationException("No authorization certificates are present in the SigningCertificateAttribute");
            }
            int j = this.certIDs.size();
            for (int i = 1; i < j && !matched; ++i) {
                ESSCertID essCertID = (ESSCertID)this.certIDs.elementAt(i);
                if (!essCertID.compareTo(cert, caCert)) continue;
                matched = true;
            }
            if (!matched) {
                throw new AuthenticationException("The hash from the certificate is different from the one in the SigningCertificateAttribute");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (ClassCastException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        if (!seq.hasMoreData()) {
            throw new InvalidInputException("unexpected end of stream");
        }
        ASN1SequenceInputStream seq1 = new ASN1SequenceInputStream((InputStream)seq);
        if (seq1.hasMoreData()) {
            this.certIDs = new Vector();
            while (seq1.hasMoreData()) {
                this.certIDs.addElement(new ESSCertID((InputStream)seq1));
            }
            if (this.certIDs.size() < 1) {
                throw new IOException("Expected non-empty list of CertID's");
            }
        } else {
            throw new IOException("Expected non-empty list of CertID's");
        }
        seq1.terminate();
        if (seq.hasMoreData()) {
            ASN1SequenceInputStream seq2 = new ASN1SequenceInputStream((InputStream)seq);
            if (seq2.hasMoreData()) {
                this.policies = new Vector();
                while (seq2.hasMoreData()) {
                    this.policies.addElement(new X509PolicyInformation((InputStream)seq2));
                }
                if (this.policies.size() < 1) {
                    this.policies = null;
                }
            } else {
                this.policies = null;
            }
            seq2.terminate();
        } else {
            this.policies = null;
        }
        seq.terminate();
        this.contents = null;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            seq.addElement((ASN1Object)new ASN1Sequence(this.certIDs));
            if (this.policies != null) {
                seq.addElement((ASN1Object)new ASN1Sequence(this.policies));
            }
            this.contents = seq;
        }
        return this.contents;
    }
}

