/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime.ess;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.Attribute;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.smime.Smime;
import oracle.security.crypto.smime.ess.MLData;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class MLExpansionHistory
implements ASN1Object {
    private Vector vect;
    private ASN1Sequence contents;
    public static final int UB_ML_EXPANSION_HISTORY = 64;

    public MLExpansionHistory(InputStream is) throws IOException {
        this.input(is);
        this.contents = null;
    }

    public MLExpansionHistory(CMSSignerInfo si) throws InvalidInputException {
        try {
            if (si == null) {
                throw new InvalidInputException("No SignerInfo Present");
            }
            Attribute vals = si.getSignedAttributes().getAttribute(Smime.id_aa_mlExpandHistory);
            if (vals == null) {
                throw new InvalidInputException("mlExpansionHistory Values is NULL");
            }
            if (vals.getValues().size() != 1) {
                throw new InvalidInputException("mlExpansionHistory Must Be Single Valued");
            }
            this.vect = new Vector();
            try {
                this.input((InputStream)new UnsyncByteArrayInputStream(Utils.toBytes((Streamable)((ASN1Sequence)vals.getValues().elementAt(0)))));
            }
            catch (IOException ex) {
                throw new InvalidInputException(ex.toString());
            }
            if (this.vect.size() < 1) {
                throw new InvalidInputException("mlExpansionHistory MUST NOT be Empty");
            }
            if (this.vect.size() > 64) {
                throw new InvalidInputException("mlExpansionHistory Mamimum allowed size exceeded");
            }
            this.contents = null;
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex.toString());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new InvalidInputException(ex.toString());
        }
    }

    public MLExpansionHistory(MLData mlData) {
        this.vect = new Vector();
        this.vect.addElement(mlData);
        this.contents = null;
    }

    public MLExpansionHistory(Vector mlDatas) throws InvalidInputException {
        if (mlDatas == null || mlDatas.size() < 1) {
            throw new InvalidInputException("Null or Empty MLData elements");
        }
        int j = mlDatas.size();
        if (j + 1 > 64) {
            throw new InvalidInputException("Maximum number of MLData elements will be exceeded: " + String.valueOf(64));
        }
        this.vect = new Vector();
        for (int i = 0; i < j; ++i) {
            this.vect.addElement((MLData)mlDatas.elementAt(i));
        }
        this.contents = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MLExpansionHistory)) {
            return false;
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)((MLExpansionHistory)o)));
    }

    public int hashCode() {
        return new String(Utils.toBytes((Streamable)this)).hashCode();
    }

    public void addMLData(MLData mlData) throws InvalidInputException {
        if (mlData == null) {
            throw new InvalidInputException("Null MLData Element");
        }
        if (this.vect.size() + 1 > 64) {
            throw new InvalidInputException("Maximum number of MLData elements will be exceeded: " + String.valueOf(64));
        }
        this.vect.addElement(mlData);
        this.contents = null;
    }

    public void addMLData(Vector mlDatas) throws InvalidInputException {
        if (mlDatas == null) {
            throw new InvalidInputException("Null MLData Elements");
        }
        if (this.vect.size() + mlDatas.size() > 64) {
            throw new InvalidInputException("Maximum number of MLData elements will be exceeded: " + String.valueOf(64));
        }
        int j = mlDatas.size();
        for (int i = 0; i < j; ++i) {
            this.vect.addElement((MLData)mlDatas.elementAt(i));
        }
        this.contents = null;
    }

    public Vector getMLDatas() {
        return this.vect;
    }

    public Enumeration mldatas() {
        if (this.vect == null || this.vect.size() < 1) {
            return null;
        }
        return this.vect.elements();
    }

    public String toString() {
        return "MLExpansionHistory contains " + this.vect.size() + " mailing list data elements";
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        if (seq.hasMoreData()) {
            this.vect = new Vector();
            while (seq.hasMoreData()) {
                this.vect.addElement(new MLData((InputStream)seq));
            }
        }
        seq.terminate();
        if (this.vect == null || this.vect.size() < 1) {
            throw new InvalidInputException("mlExpansionHistory MUST NOT be Empty");
        }
        if (this.vect.size() > 64) {
            throw new InvalidInputException("mlExpansionHistory Mamimum allowed size exceeded");
        }
    }

    public void output(OutputStream os) throws IOException {
        if (this.vect == null || this.vect.size() < 1) {
            throw new InvalidInputException("mlExpansionHistory MUST NOT be Empty");
        }
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.vect);
        }
        return this.contents;
    }
}

