/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime.ess;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.Attribute;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.smime.Smime;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class ESSSecurityLabel
implements ASN1Object {
    private ASN1ObjectID securityPolicyID;
    private ASN1Integer securityClassification;
    private String privacyMark;
    boolean useUTF8privMark;
    private Hashtable securityCategories;
    private ASN1Set contents;
    public static final int UNMARKED = 0;
    public static final int UNCLASSIFIED = 1;
    public static final int RESTRICTED = 2;
    public static final int CONFIDENTIAL = 3;
    public static final int SECRET = 4;
    public static final int TOP_SECRET = 5;
    public static final int UB_INTEGER_OPTIONS = 256;
    public static final int UB_PRIVACY_MARK_LENGTH = 128;
    public static final int UB_SECURITY_CATEGORIES = 64;

    public ESSSecurityLabel(InputStream is) throws IOException {
        this.input(is);
        this.contents = null;
    }

    public ESSSecurityLabel(CMSSignerInfo si) throws InvalidInputException {
        try {
            if (si == null) {
                throw new InvalidInputException("No SignerInfo Present");
            }
            Attribute vals = si.getSignedAttributes().getAttribute(Smime.id_aa_securityLabel);
            if (vals == null) {
                throw new InvalidInputException("SecurityLabel Values is NULL");
            }
            if (vals.getValues().size() != 1) {
                throw new InvalidInputException("SecurityLabel Must Be Single Valued");
            }
            try {
                this.input((InputStream)new UnsyncByteArrayInputStream(Utils.toBytes((Streamable)((ASN1Set)vals.getValues().elementAt(0)))));
            }
            catch (IOException ex) {
                throw new InvalidInputException(ex.toString());
            }
            this.contents = null;
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex.toString());
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new InvalidInputException(ex.toString());
        }
    }

    public ESSSecurityLabel(ASN1ObjectID securityPolicyID) {
        this.securityPolicyID = securityPolicyID;
        this.securityClassification = null;
        this.privacyMark = null;
        this.securityCategories = null;
        this.contents = null;
    }

    public ESSSecurityLabel(ASN1ObjectID securityPolicyID, int secClass) throws InvalidInputException {
        this.securityPolicyID = securityPolicyID;
        this.setSecurityClassification(secClass);
        this.privacyMark = null;
        this.securityCategories = null;
        this.contents = null;
    }

    public ESSSecurityLabel(ASN1ObjectID securityPolicyID, int secClass, String privMark, boolean useUTF8) throws InvalidInputException {
        this.securityPolicyID = securityPolicyID;
        this.setSecurityClassification(secClass);
        this.setPrivacyMark(privMark, useUTF8);
        this.securityCategories = null;
        this.contents = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ESSSecurityLabel)) {
            return false;
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)((ESSSecurityLabel)o)));
    }

    public int hashCode() {
        return new String(Utils.toBytes((Streamable)this)).hashCode();
    }

    public void setSecurityClassification(int secClass) throws InvalidInputException {
        if (secClass < 0) {
            throw new InvalidInputException("The value of securityClassification is less the minimum allowed: 0");
        }
        if (secClass > 256) {
            throw new InvalidInputException("The value of securityClassification exceeds the maximum allowed:" + String.valueOf(256));
        }
        this.securityClassification = new ASN1Integer((long)secClass);
        this.contents = null;
    }

    public void setPrivacyMark(String privacyMark, boolean useUTF8) throws InvalidInputException {
        if (privacyMark == null || privacyMark.length() < 1) {
            throw new InvalidInputException("Null or Zero length privacyMark not allowed");
        }
        if (!useUTF8 && privacyMark.length() > 128) {
            throw new InvalidInputException("The length of the privacyMark exceed the maximum allowed: " + String.valueOf(128));
        }
        this.privacyMark = privacyMark;
        this.useUTF8privMark = useUTF8;
        this.contents = null;
    }

    public void addSecurityCategory(ASN1ObjectID type, ASN1Object value) throws InvalidInputException {
        if (this.securityCategories == null) {
            this.securityCategories = new Hashtable();
        }
        if (this.securityCategories.size() + 1 > 64) {
            throw new InvalidInputException("Operation failed. The maximum number of securityCategories has been reached.");
        }
        this.securityCategories.put(type, value);
        this.contents = null;
    }

    public ASN1ObjectID getSecurityPolicyIdentifier() {
        return this.securityPolicyID;
    }

    public int getSecurityClassification() {
        if (this.securityClassification != null) {
            return this.securityClassification.intValue();
        }
        return -1;
    }

    public String getPrivacyMark() {
        return this.privacyMark;
    }

    public boolean isUTF8StringPrivacyMark() {
        return this.useUTF8privMark;
    }

    public Hashtable getSecurityCategories() {
        return this.securityCategories;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ESS Security Label\n");
        sb.append("Security Policy Identifier: " + this.securityPolicyID + "\n");
        if (this.securityClassification != null) {
            sb.append("Security Classification: " + this.securityClassification.intValue() + "\n");
        } else {
            sb.append("Security Classification: Not Present\n");
        }
        if (this.privacyMark != null) {
            sb.append("Privacy Mark: " + this.privacyMark + "\n");
        } else {
            sb.append("Privacy Mark: Not Present\n");
        }
        if (this.securityCategories != null) {
            sb.append("Security Policies:");
            Enumeration e = this.securityCategories.keys();
            while (e != null && e.hasMoreElements()) {
                sb.append(((ASN1ObjectID)e.nextElement()).toString() + " ; ");
            }
        } else {
            sb.append("Security Policies: Not Present\n");
        }
        return sb.toString();
    }

    public void input(InputStream is) throws IOException {
        this.securityPolicyID = null;
        this.securityClassification = null;
        this.privacyMark = null;
        this.securityCategories = null;
        ASN1SetInputStream si = new ASN1SetInputStream(is);
        while (si.hasMoreData()) {
            ASN1String pStr;
            int tag = si.getCurrentTag();
            if (tag == 6) {
                this.securityPolicyID = new ASN1ObjectID((InputStream)si);
                continue;
            }
            if (tag == 2) {
                this.securityClassification = new ASN1Integer((InputStream)si);
                if (this.securityClassification.intValue() < 0) {
                    throw new InvalidInputException("The value of securityClassification is lesser than the minimum allowed");
                }
                if (this.securityClassification.intValue() <= 256) continue;
                throw new InvalidInputException("The value of securityClassification is bigger than the maximum allowed");
            }
            if (tag == 19) {
                pStr = new ASN1String((InputStream)si);
                this.privacyMark = pStr.getValue();
                this.useUTF8privMark = false;
                if (this.privacyMark == null || this.privacyMark.length() < 1) {
                    throw new InvalidInputException("Null or Zero length privacyMark is not allowed");
                }
                if (this.privacyMark.length() <= 128) continue;
                throw new InvalidInputException("The length of privacyMark is bigger than the maximum allowed");
            }
            if (tag == 12) {
                pStr = new ASN1String((InputStream)si);
                this.privacyMark = pStr.getValue();
                if (this.privacyMark == null || this.privacyMark.length() < 1) {
                    throw new InvalidInputException("Null or Zero length privacyMark is not allowed");
                }
                this.useUTF8privMark = true;
                continue;
            }
            if (tag == 17) {
                ASN1SetInputStream si1 = new ASN1SetInputStream((InputStream)si);
                if (si1.hasMoreData()) {
                    this.securityCategories = new Hashtable();
                    while (si1.hasMoreData()) {
                        ASN1SequenceInputStream seq = new ASN1SequenceInputStream((InputStream)si1);
                        if (seq.getCurrentTag() != 0) {
                            throw new IOException("Expected Implicit [0] in Security Category");
                        }
                        seq.setCurrentTag(6);
                        ASN1ObjectID objID = new ASN1ObjectID((InputStream)seq);
                        if (seq.hasMoreData()) {
                            this.securityCategories.put(objID, ASN1Utils.inputASN1Object((InputStream)seq));
                        }
                        seq.terminate();
                    }
                    if (this.securityCategories.size() < 1) {
                        throw new InvalidInputException("Expected securityCategories");
                    }
                    if (this.securityCategories.size() > 64) {
                        throw new InvalidInputException("The length of securityCategories is bigger than the maximum allowed");
                    }
                }
                si1.terminate();
                continue;
            }
            throw new InvalidInputException("Unrecognized element in ESSSecurityLabel");
        }
        si.terminate();
    }

    public void output(OutputStream os) throws IOException {
        if (this.securityPolicyID == null) {
            throw new IOException("Security Policy Identifier MUST be specified");
        }
        this.toASN1Set().output(os);
    }

    public int length() {
        return this.toASN1Set().length();
    }

    private ASN1Set toASN1Set() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Set set = new ASN1Set();
        set.addElement((ASN1Object)this.securityPolicyID);
        if (this.securityClassification != null) {
            set.addElement((ASN1Object)this.securityClassification);
        }
        if (this.privacyMark != null) {
            if (this.useUTF8privMark) {
                set.addElement((ASN1Object)new ASN1String(new String(this.privacyMark.getBytes()), 12));
            } else {
                set.addElement((ASN1Object)new ASN1String(new String(this.privacyMark.getBytes()), 19));
            }
        }
        if (this.securityCategories != null) {
            ASN1Set set1 = new ASN1Set();
            Enumeration e = this.securityCategories.keys();
            while (e.hasMoreElements()) {
                Object obj = e.nextElement();
                ASN1Sequence seq = new ASN1Sequence();
                seq.addElement(ASN1Utils.addImplicitTag((ASN1Object)((ASN1ObjectID)obj), (int)0));
                seq.addElement(ASN1Utils.addImplicitTag((ASN1Object)((ASN1Object)this.securityCategories.get(obj)), (int)1));
                set1.addElement((ASN1Object)seq);
            }
            set.addElement((ASN1Object)set1);
        }
        this.contents = set;
        return this.contents;
    }
}

