/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime.ess;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class ContentReference
implements ASN1Object {
    private ASN1ObjectID contentType;
    private byte[] signedContentIdentifier;
    private byte[] originatorSignatureValue;
    private ASN1Sequence contents;

    public ContentReference(InputStream is) throws IOException {
        this.input(is);
        this.contents = null;
    }

    public ContentReference(ASN1ObjectID contentType, byte[] signedContentIdentifier, byte[] originatorSignatureValue) {
        this.contentType = contentType;
        this.signedContentIdentifier = signedContentIdentifier;
        this.originatorSignatureValue = originatorSignatureValue;
        this.contents = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ContentReference)) {
            return false;
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this), (byte[])Utils.toBytes((Streamable)((ContentReference)o)));
    }

    public int hashCode() {
        return new String(Utils.toBytes((Streamable)this)).hashCode();
    }

    public ASN1ObjectID getContentType() {
        return this.contentType;
    }

    public void setContentType(ASN1ObjectID contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("Null Content Type");
        }
        this.contentType = contentType;
        this.contents = null;
    }

    public byte[] getSignedContentIdentifier() {
        return this.signedContentIdentifier;
    }

    public void setSignedContentIdentifier(byte[] signedContentIdentifier) {
        if (signedContentIdentifier == null) {
            throw new IllegalArgumentException("Null Signed Content Identifier");
        }
        this.signedContentIdentifier = signedContentIdentifier;
        this.contents = null;
    }

    public byte[] getOriginatorSignatureValue() {
        return this.originatorSignatureValue;
    }

    public void setOriginatorSignatureValue(byte[] originatorSignatureValue) {
        if (originatorSignatureValue == null) {
            throw new IllegalArgumentException("Null Originator Signature Value");
        }
        this.originatorSignatureValue = originatorSignatureValue;
        this.contents = null;
    }

    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        this.contentType = new ASN1ObjectID((InputStream)seq);
        this.signedContentIdentifier = ASN1OctetString.inputValue((InputStream)seq);
        this.originatorSignatureValue = ASN1OctetString.inputValue((InputStream)seq);
        seq.terminate();
        this.contents = null;
    }

    public void output(OutputStream os) throws IOException {
        if (this.signedContentIdentifier == null) {
            throw new IOException("Signed Content Identifier is Null");
        }
        if (this.originatorSignatureValue == null) {
            throw new IOException("Originator Signature Value is Null");
        }
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            seq.addElement((ASN1Object)this.contentType);
            seq.addElement((ASN1Object)new ASN1OctetString(this.signedContentIdentifier));
            seq.addElement((ASN1Object)new ASN1OctetString(this.originatorSignatureValue));
            this.contents = seq;
        }
        return this.contents;
    }
}

