/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.smime;

import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import oracle.security.crypto.cert.CertificateTrustPolicy;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.smime.SmimeObject;
import oracle.security.crypto.smime.ess.ESSSecurityLabel;
import oracle.security.crypto.smime.ess.EquivalentLabels;
import oracle.security.crypto.smime.ess.MLExpansionHistory;
import oracle.security.crypto.smime.ess.ReceiptRequest;
import oracle.security.crypto.smime.ess.SigningCertificate;
import oracle.security.crypto.util.InvalidInputException;

public interface SmimeSignedObject
extends SmimeObject {
    public Enumeration signers();

    public Vector getCertificates();

    public Vector getCRLs();

    public MimeBodyPart getEnclosedBodyPart() throws InvalidInputException, MessagingException;

    public void verifySignature(X509Certificate var1) throws AuthenticationException, SignatureException;

    public void verifySignature(X509Certificate var1, Address[] var2) throws AuthenticationException, SignatureException;

    public void verify(CertificateTrustPolicy var1) throws AuthenticationException;

    public void verify(CertificateTrustPolicy var1, Address[] var2) throws AuthenticationException;

    public ESSSecurityLabel getESSSecurityLabel(X509Certificate var1) throws AuthenticationException, SignatureException;

    public EquivalentLabels getEquivalentLabels(X509Certificate var1) throws AuthenticationException, SignatureException;

    public SigningCertificate getSigningCertificate(X509Certificate var1) throws AuthenticationException, SignatureException;

    public MLExpansionHistory getMLExpansionHistory(X509Certificate var1) throws AuthenticationException, SignatureException;

    public ReceiptRequest getReceiptRequest(X509Certificate var1) throws AuthenticationException, SignatureException;
}

