/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.hadoop.ui.OLHIPartitionPanel;
import oracle.dbtools.raptor.hadoop.ui.OSCHIPredicatePanel;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class OSCHIPredicatePage
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private HadoopProperties _hProps;
    private ExtractObject _eo;
    private JTextPane _instructions;
    private OSCHIPredicatePanel _predicatePanel;
    private TreeCellCheckedListener _partitionCheckedListener;
    private JScrollPane _partKeysScrollPane;
    private JPanel _partKeysPanel;
    private DefaultListModel<String> _partKeysListModel;
    private JList<String> _partKeysJList;
    private OLHIPartitionPanel _partitionPanel;
    private JTabbedPane _tabbedPane;
    private boolean _init = false;

    public void onEntry(TraversableContext traversableContext) {
        BasicDBObject basicDBObject;
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        BasicDBObject basicDBObject2 = this._eo == null ? null : this._eo.getDBObject();
        this._eo = (ExtractObject)this._hProps.get(HadoopKeys.EXTRACT_OBJECT);
        BasicDBObject basicDBObject3 = basicDBObject = this._eo == null ? null : this._eo.getDBObject();
        if (basicDBObject2 != null && basicDBObject != null && !HadoopUtils.isSame(basicDBObject2, basicDBObject)) {
            this._init = false;
        }
        if (!this._init) {
            this.build();
            this._init = true;
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    private void build() {
        this.removeAll();
        this._instructions = new JTextPane();
        this._instructions.setEditable(false);
        this._instructions.setOpaque(false);
        this._instructions.setRequestFocusEnabled(false);
        this._instructions.setFocusable(false);
        this._instructions.setText(HadoopWizArb.getString("OSCH_WHERE_INSTRUCTIONS"));
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)this._instructions, "North");
        this._predicatePanel = new OSCHIPredicatePanel((ExtractObject)this._hProps.get(HadoopKeys.EXTRACT_OBJECT), "", false);
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this._predicatePanel), "f1_idedexporttabledata_html");
        this._predicatePanel.setVerticalDisplay(false);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(HadoopWizArb.getString("WHERE")));
        jPanel2.add((Component)((Object)this._predicatePanel), "Center");
        this.setLayout(new GridBagLayout());
        if (this._hProps.getValueBoolean(HadoopKeys.IS_SOURCE_PARTITIONED).booleanValue()) {
            this._tabbedPane = new JTabbedPane();
            this._tabbedPane.add(HadoopWizArb.getString("PARTITION_KEYS"), this.getPartitionKeysPanel());
            this._partitionPanel = new OLHIPartitionPanel(this._eo, this._eo.getPartitions());
            this._partitionPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
            this._partitionPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
            this._tabbedPane.add(HadoopWizArb.getString("PARTITIONS"), this._partitionPanel);
            JSplitPane jSplitPane = new JSplitPane(0);
            jSplitPane.setTopComponent(this._tabbedPane);
            jSplitPane.setBottomComponent(jPanel2);
            jSplitPane.setOneTouchExpandable(false);
            jSplitPane.setDividerSize(16);
            jSplitPane.setDividerLocation(200);
            int n = 0;
            this.add(jPanel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 0), 0, 0));
            this.add(jSplitPane, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.8, 18, 1, new Insets(8, 0, 0, 0), 0, 0));
        } else {
            int n = 0;
            this.add(jPanel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 2, new Insets(6, 0, 0, 0), 0, 0));
            this.add(jPanel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.8, 18, 1, new Insets(8, 0, 0, 0), 0, 0));
        }
    }

    public JPanel getPartitionKeysPanel() {
        this._partKeysPanel = new JPanel(new BorderLayout());
        this._partKeysPanel.setBorder(BorderFactory.createTitledBorder(HadoopWizArb.getString("PARTITION_KEYS")));
        this._partKeysScrollPane = new JScrollPane(22, 32);
        this._partKeysPanel.add((Component)this._partKeysScrollPane, "Center");
        this._partKeysListModel = new DefaultListModel();
        String[] stringArray = (String[])this._hProps.get(HadoopKeys.PARTITION_KEYS);
        if (stringArray != null) {
            for (String string : stringArray) {
                this._partKeysListModel.addElement(string);
            }
        }
        this._partKeysJList = new JList<String>(this._partKeysListModel){
            private static final long serialVersionUID = 1L;
        };
        this._partKeysScrollPane.setViewportView(this._partKeysJList);
        return this._partKeysPanel;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this._hProps.put(HadoopKeys.WHERE, this._predicatePanel.getWhere());
        }
    }

    public Object getExitTransition() {
        return this.getTransition();
    }

    private Object getTransition() {
        return "F";
    }
}

