/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.performancemonitor;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.Connection;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import oracle.dbtools.raptor.timesten.performancemonitor.data.SummaryDataProvider;
import oracle.dbtools.raptor.timesten.performancemonitor.distribution.TopologyInfoSplitPane;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;

public class JFXTopologyPane
extends JFXPanel {
    private static final long serialVersionUID = 1L;
    private Connection connection;
    private TopologyInfoSplitPane pane;
    private ShutdownHook fxShutdownHook;

    public JFXTopologyPane(Connection connection) {
        this.connection = connection;
        this.init();
        Platform.setImplicitExit((boolean)false);
        this.fxShutdownHook = new ShutdownHook(){

            public boolean canShutdown() {
                return true;
            }

            public void shutdown() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Platform.exit();
                    }
                });
            }
        };
        ExitCommand.removeShutdownHook((ShutdownHook)this.fxShutdownHook);
        ExitCommand.addShutdownHook((ShutdownHook)this.fxShutdownHook);
    }

    private void init() {
        if (Platform.isFxApplicationThread()) {
            this.setUpFx();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JFXTopologyPane.this.setUpFx();
                }
            });
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(final ComponentEvent componentEvent) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JFXTopologyPane.this.pane.setMinSize(componentEvent.getComponent().getWidth(), componentEvent.getComponent().getHeight());
                        JFXTopologyPane.this.pane.setMaxSize(componentEvent.getComponent().getWidth(), componentEvent.getComponent().getHeight());
                        JFXTopologyPane.this.pane.setPrefSize(componentEvent.getComponent().getWidth(), componentEvent.getComponent().getHeight());
                    }
                });
            }
        });
    }

    private void setUpFx() {
        Scene scene = new Scene((Parent)new Group());
        String string = ((Object)((Object)this)).getClass().getResource("ottPerformanceStyle.css").toExternalForm();
        scene.getStylesheets().add((Object)string);
        SummaryDataProvider summaryDataProvider = new SummaryDataProvider(this.connection);
        this.pane = new TopologyInfoSplitPane(this.connection, summaryDataProvider);
        ((Group)scene.getRoot()).getChildren().add((Object)this.pane);
        this.setScene(scene);
    }

    public TopologyInfoSplitPane getTopologyPane() {
        return this.pane;
    }
}

