/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.panels;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigInteger;
import java.sql.Connection;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.text.NumberFormatter;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenPlugInDatabaseImpl;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.IncrementerPanel;
import oracle.javatools.db.AbstractIncrementer;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Sequence;
import oracle.javatools.dialogs.MessageDialog;

public class TTSequencePanel
extends IncrementerPanel<Sequence> {
    private static final String BATCH_LABEL = Messages.getString("TimesTen.sequence.batchValueLabel");
    private JLabel batchLabel;
    private JFormattedTextField batchTextField;
    private String DIALOG_KEY = "TT_SEC_DIALOG";
    private boolean m_useTwoColumns = false;
    private ComponentWrapper cwStartWith;
    private ComponentWrapper cwIncrement;
    private ComponentWrapper cwMinValue;
    private ComponentWrapper cwMaxValue;
    private ComponentWrapper cwCacheSize;
    private ComponentWrapper cwCache;
    private ComponentWrapper cwCycle;

    protected void initialisePanel() {
        super.initialisePanel();
        if (this.isEditing()) {
            this.cwStartWith.getComponent().setEnabled(false);
            this.cwIncrement.setEnabled(false);
            this.cwMinValue.setEnabled(false);
            this.cwMaxValue.setEnabled(false);
            this.cwCacheSize.setEnabled(false);
            this.cwCache.setEnabled(false);
            this.cwCycle.setEnabled(false);
        } else {
            this.cwStartWith.setEnabled(true);
            this.cwIncrement.setEnabled(true);
            this.cwMinValue.setEnabled(true);
            this.cwMaxValue.setEnabled(true);
            this.cwCacheSize.setEnabled(true);
            this.cwCache.setEnabled(true);
            this.cwCycle.setEnabled(true);
        }
    }

    protected void initialiseComponents() {
        this.cwStartWith = this.getOrCreateWrapper("startWith");
        this.cwIncrement = this.getOrCreateWrapper("incrementBy");
        this.cwMinValue = this.getOrCreateWrapper("minValue");
        this.cwMaxValue = this.getOrCreateWrapper("maxValue");
        this.cwCacheSize = this.getOrCreateWrapper("cacheSize");
        this.cwCache = this.getOrCreateWrapper("cacheFlag");
        this.cwCycle = this.getOrCreateWrapper("cycleFlag");
        this.cwCache.addListener(propertyChangeEvent -> this.processCacheSize(propertyChangeEvent.getNewValue(), true));
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        dBUILayoutHelper.add(this.cwStartWith);
        if (!this.m_useTwoColumns) {
            dBUILayoutHelper.nextRow();
        }
        dBUILayoutHelper.add(this.cwIncrement);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.cwMinValue);
        if (!this.m_useTwoColumns) {
            dBUILayoutHelper.nextRow();
        }
        dBUILayoutHelper.add(this.cwMaxValue);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.cwCache);
        if (!this.m_useTwoColumns) {
            dBUILayoutHelper.nextRow();
        }
        dBUILayoutHelper.add(this.cwCacheSize);
        if (!this.m_useTwoColumns) {
            dBUILayoutHelper.indent((Component)this.cwCacheSize.getLabel());
        }
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add(this.cwCycle);
        this.completeLayout();
    }

    private void processCacheSize(Object object, boolean bl) {
        boolean bl2 = Boolean.TRUE.equals(object);
        ComponentWrapper componentWrapper = this.getOrCreateWrapper("cacheSize");
        componentWrapper.setEnabled(bl2);
        if (bl) {
            componentWrapper.resetPropertyValue((Object)(bl2 ? this.getCacheSizeDefault() : null));
        }
    }

    private BigInteger getCacheSizeDefault() {
        BigInteger bigInteger;
        AbstractIncrementer abstractIncrementer = (AbstractIncrementer)this.getComponentFactoryUpdatedObject();
        BigInteger bigInteger2 = abstractIncrementer.getMaxValue();
        BigInteger bigInteger3 = abstractIncrementer.getMinValue();
        BigInteger bigInteger4 = abstractIncrementer.getIncrementBy();
        if (bigInteger4 == null || bigInteger4.equals(BigInteger.ZERO)) {
            bigInteger4 = BigInteger.ONE;
        }
        if (bigInteger2 == null) {
            bigInteger2 = bigInteger4.signum() > 0 ? BigInteger.valueOf(10L).pow(27) : BigInteger.ONE.negate();
        }
        if (bigInteger3 == null) {
            bigInteger3 = bigInteger4.signum() > 0 ? BigInteger.ONE : BigInteger.valueOf(10L).pow(26).negate();
        }
        BigInteger[] bigIntegerArray = bigInteger2.subtract(bigInteger3).abs().divideAndRemainder(bigInteger4.abs());
        BigInteger bigInteger5 = bigIntegerArray[0];
        if (bigIntegerArray[1].signum() > 0) {
            bigInteger5 = bigInteger5.add(BigInteger.ONE);
        }
        if (bigInteger5.subtract(bigInteger = new BigInteger("20")).signum() > 0) {
            bigInteger5 = bigInteger;
        }
        return bigInteger5;
    }

    protected void completeLayout() {
        DBUILayoutHelper dBUILayoutHelper = this.getDBUILayoutHelper();
        Connection connection = ((JdbcDatabase)this.getProvider()).getConnection();
        if (TimesTenPlugInDatabaseImpl.isGridDatabase(connection)) {
            this.setupGridComponents(dBUILayoutHelper);
        }
        if (this.isInFlatEditor()) {
            dBUILayoutHelper.pushLeft();
        }
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.pushUp();
        dBUILayoutHelper.layout();
    }

    private void setupGridComponents(DBUILayoutHelper dBUILayoutHelper) {
        dBUILayoutHelper.nextRow();
        NumberFormat numberFormat = NumberFormat.getInstance();
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setValueClass(Integer.class);
        numberFormatter.setMinimum(Integer.valueOf(0));
        numberFormatter.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        numberFormatter.setCommitsOnValidEdit(true);
        this.batchTextField = new JFormattedTextField(numberFormatter);
        Object object = ((AbstractIncrementer)this.getUpdatedObject()).getProperty("batchValue");
        if (object != null && object instanceof String) {
            int n = Integer.parseInt((String)object);
            this.batchTextField.setValue(n);
        }
        this.batchLabel = new JLabel(BATCH_LABEL);
        dBUILayoutHelper.add((Component)this.batchLabel);
        dBUILayoutHelper.add((Component)this.batchTextField);
        this.batchTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                super.focusLost(focusEvent);
                if (TTSequencePanel.this.batchTextField.isEditValid()) {
                    String string = null;
                    if (TTSequencePanel.this.batchTextField.getValue() != null) {
                        string = TTSequencePanel.this.batchTextField.getValue().toString();
                    }
                    ((AbstractIncrementer)TTSequencePanel.this.getUpdatedObject()).setProperty("batchValue", (Object)string);
                }
            }
        });
    }

    protected void validateObject() throws TraversalException {
        int n;
        super.validateObject();
        Object object = ((AbstractIncrementer)this.getUpdatedObject()).getProperty("batchValue");
        if (object != null && (n = Integer.parseInt(object.toString())) == 0 && !MessageDialog.optionalConfirm((String)this.DIALOG_KEY, (Component)((Object)this), (Object)Messages.getString("TimesTen.sequence.confirmBatchValue"), (String)Messages.getString("TimesTen.common.confirm"), null)) {
            throw new TraversalException(null);
        }
    }
}

