/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.SquareIconButton;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditor;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorFactory;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorHandler;
import oracle.dbtools.raptor.navigator.net.editor.BreakoutEditorListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.icons.OracleIcons;

public class LongTextEditor
extends JPanel
implements PopupCellEditorHandler {
    private int columnDataType = 12;
    private String columnDataTypeName = "VARCHAR";
    private PopupCellEditor popupEditor;
    private JTextField editorTxt;
    private Boolean isDataStore;
    private static final Logger logger = Logger.getLogger(LongTextEditor.class.getName());

    public LongTextEditor() {
        this(false);
    }

    public LongTextEditor(boolean bl) {
        this.isDataStore = bl;
        this.setLayout(new BorderLayout());
        this.editorTxt = new JTextField();
        this.add((Component)this.editorTxt, "Center");
        this.popupEditor = PopupCellEditorFactory.getPopupCellEditorForDriver((String)"oracle.jdbc.OracleDriver", (int)this.columnDataType, (String)this.columnDataTypeName);
        this.popupEditor.setEditable(true);
        SquareIconButton squareIconButton = new SquareIconButton(OracleIcons.getIcon((String)"edit.png"));
        squareIconButton.setName("EditCell");
        squareIconButton.setMargin(new Insets(2, 2, 2, 2));
        squareIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LongTextEditor.this.handlePopupEdit(LongTextEditor.this.popupEditor);
            }
        });
        this.add((Component)squareIconButton, "East");
    }

    public String getText() {
        return this.editorTxt.getText();
    }

    public void setText(String string) {
        this.editorTxt.setText(string);
    }

    public void setCaretPosition(int n) {
        this.editorTxt.setCaretPosition(n);
    }

    public int getCaretPosition() {
        return this.editorTxt.getCaretPosition();
    }

    public Document getDocument() {
        return this.editorTxt.getDocument();
    }

    public void handlePopupEdit(PopupCellEditor popupCellEditor) {
        JComponent jComponent = popupCellEditor.getComponent();
        if (jComponent == null) {
            logger.severe("Editor is null in LongTextEditor");
            return;
        }
        String string = this.isDataStore != false ? "TimesTenGrid.editDataStoreValue" : "TimesTenGrid.editLogDirValue";
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jComponent, (Component)popupCellEditor.getDefaultComponent(), (String)Messages.getString(string));
        jEWTDialog.setResizable(true);
        jEWTDialog.setOKButtonEnabled(popupCellEditor.isEditable());
        if (this.isDataStore.booleanValue()) {
            popupCellEditor.setValue((Object)this.editorTxt.getText().substring(0, this.editorTxt.getText().lastIndexOf("/")));
        } else {
            popupCellEditor.setValue((Object)this.editorTxt.getText());
        }
        popupCellEditor.setPopupDialog(jEWTDialog);
        popupCellEditor.setBreakoutEditorListener(new BreakoutEditorListener(){

            public void save(Object object) {
                LongTextEditor.this.editorTxt.setText((String)object);
            }
        });
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            this.editorTxt.setText((String)popupCellEditor.getValue());
        }
        popupCellEditor.dismissPopupEditor();
    }
}

